(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/db/sqlite#sqlite-connection::t
    (make-struct-type
     'std/db/sqlite#sqlite-connection::t
     std/db/dbi#connection::t
     '0
     'sqlite-connection
     '((final: . #t))
     '#f
     '()))
  (define std/db/sqlite#sqlite-connection?
    (make-struct-predicate std/db/sqlite#sqlite-connection::t))
  (define std/db/sqlite#make-sqlite-connection
    (lambda _$args221290_
      (apply make-struct-instance
             std/db/sqlite#sqlite-connection::t
             _$args221290_)))
  (define std/db/sqlite#sqlite-statement::t
    (make-struct-type
     'std/db/sqlite#sqlite-statement::t
     std/db/dbi#statement::t
     '0
     'sqlite-statement
     '((final: . #t))
     '#f
     '()))
  (define std/db/sqlite#sqlite-statement?
    (make-struct-predicate std/db/sqlite#sqlite-statement::t))
  (define std/db/sqlite#make-sqlite-statement
    (lambda _$args221287_
      (apply make-struct-instance
             std/db/sqlite#sqlite-statement::t
             _$args221287_)))
  (define std/db/sqlite#sqlite-connection:::init!
    std/db/dbi#connection:::init!)
  (bind-method!
   std/db/sqlite#sqlite-connection::t
   ':init!
   std/db/sqlite#sqlite-connection:::init!
   '#f)
  (define std/db/sqlite#raise-sqlite-error
    (lambda (_where221160_ _err221161_)
      (let ((_errstr221163_ (std/db/_sqlite#sqlite3_errstr _err221161_)))
        (std/db/dbi#raise-sql-error
         _where221160_
         (std/format#format '"SQLite error: ~a" _errstr221163_)
         _err221161_))))
  (define std/db/sqlite#sqlite-open__%
    (lambda (_file221142_ _flags221143_)
      (let* ((_ptr221145_ (std/db/_sqlite#make_sqlite3_ptr_ptr))
             (_r221147_
              (std/db/_sqlite#sqlite3_open
               _ptr221145_
               _file221142_
               _flags221143_)))
        (if (##fx= _r221147_ std/db/_sqlite#SQLITE_OK)
            (let ((__obj221292
                   (make-object std/db/sqlite#sqlite-connection::t '4)))
              (if (##fx< '1 (##vector-length __obj221292))
                  (##vector-set!
                   __obj221292
                   '1
                   (std/db/_sqlite#sqlite3_ptr _ptr221145_))
                  (error '"struct-instance-init!: too many arguments for struct"
                         __obj221292))
              __obj221292)
            (std/db/sqlite#raise-sqlite-error 'sqlite-open _r221147_)))))
  (define std/db/sqlite#sqlite-open__0
    (lambda (_file221153_)
      (let ((_flags221155_
             (fxior std/db/_sqlite#SQLITE_OPEN_READWRITE
                    std/db/_sqlite#SQLITE_OPEN_CREATE)))
        (std/db/sqlite#sqlite-open__% _file221153_ _flags221155_))))
  (define std/db/sqlite#sqlite-open
    (lambda _g221294_
      (let ((_g221293_ (length _g221294_)))
        (cond ((##fx= _g221293_ 1)
               (apply std/db/sqlite#sqlite-open__0 _g221294_))
              ((##fx= _g221293_ 2)
               (apply std/db/sqlite#sqlite-open__% _g221294_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/db/sqlite#sqlite-open
                _g221294_))))))
  (define std/db/sqlite#sqlite-connection::close
    (lambda (_self221139_)
      (std/db/_sqlite#sqlite3_close
       (##structure-ref _self221139_ '1 std/db/dbi#connection::t '#f))))
  (bind-method!
   std/db/sqlite#sqlite-connection::t
   'close
   std/db/sqlite#sqlite-connection::close
   '#f)
  (define std/db/sqlite#sqlite-connection::prepare
    (lambda (_self221009_ _sql221010_)
      (let* ((_ptr221012_ (std/db/_sqlite#make_sqlite3_stmt_ptr_ptr))
             (_r221014_
              (std/db/_sqlite#sqlite3_prepare
               _ptr221012_
               (##structure-ref _self221009_ '1 std/db/dbi#connection::t '#f)
               _sql221010_)))
        (if (##fx= _r221014_ std/db/_sqlite#SQLITE_OK)
            (##structure
             std/db/sqlite#sqlite-statement::t
             (std/db/_sqlite#sqlite3_stmt_ptr _ptr221012_))
            (std/db/sqlite#raise-sqlite-error 'sqlite-prepare _r221014_)))))
  (bind-method!
   std/db/sqlite#sqlite-connection::t
   'prepare
   std/db/sqlite#sqlite-connection::prepare
   '#f)
  (define std/db/sqlite#sqlite-statement::finalize
    (lambda (_self220885_)
      (std/db/_sqlite#sqlite3_finalize
       (##structure-ref _self220885_ '1 std/db/dbi#statement::t '#f))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'finalize
   std/db/sqlite#sqlite-statement::finalize
   '#f)
  (define std/db/sqlite#sqlite-statement::bind
    (lambda (_self220689_ . _args220690_)
      (let* ((_self220691220697_ _self220689_)
             (_E220693220701_
              (lambda () (error '"No clause matching" _self220691220697_)))
             (_K220694220755_
              (lambda (_stmt220704_)
                (let* ((_params220706_
                        (std/db/_sqlite#sqlite3_bind_parameter_count
                         _stmt220704_))
                       (_g221295_
                        (if (= _params220706_ (length _args220690_))
                            '#!void
                            (error '"bind parameters do not match statement count"
                                   _args220690_
                                   _params220706_))))
                  (let ((_g220709220714_ (std/iter#iter _args220690_))
                        (_g220710220716_
                         (std/iter#iter
                          (std/iter#in-range__1 _params220706_ '1))))
                    (let _lp220719_ ()
                      (let ((_g220711220723_
                             (std/iter#iter-next! _g220709220714_))
                            (_g220712220725_
                             (std/iter#iter-next! _g220710220716_)))
                        (if (or (eq? std/iter#iter-end _g220711220723_)
                                (eq? std/iter#iter-end _g220712220725_))
                            '#!void
                            (begin
                              (let ((_g220730220736_ _g220711220723_)
                                    (_g220731220738_ _g220712220725_))
                                (let* ((_E220733220742_
                                        (lambda ()
                                          (error '"No clause matching"
                                                 _g220730220736_
                                                 _g220731220738_)))
                                       (_K220734220748_
                                        (lambda (_arg220745_ _param220746_)
                                          (if (not _arg220745_)
                                              (std/db/_sqlite#sqlite3_bind_null
                                               _stmt220704_
                                               _param220746_)
                                              (if (number? _arg220745_)
                                                  (if (integer? _arg220745_)
                                                      (if (< (abs _arg220745_)
                                                             (expt '2 '32))
                                                          (std/db/_sqlite#sqlite3_bind_int
                                                           _stmt220704_
                                                           _param220746_
                                                           _arg220745_)
                                                          (std/db/_sqlite#sqlite3_bind_int64
                                                           _stmt220704_
                                                           _param220746_
                                                           _arg220745_))
                                                      (if (real? _arg220745_)
                                                          (std/db/_sqlite#sqlite3_bind_double
                                                           _stmt220704_
                                                           _param220746_
                                                           (exact->inexact
                                                            _arg220745_))
                                                          (error '"cannot bind number; not a real"
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _arg220745_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                  (if (string? _arg220745_)
                                                      (std/db/_sqlite#sqlite3_bind_text
                                                       _stmt220704_
                                                       _param220746_
                                                       _arg220745_)
                                                      (if (u8vector?
                                                           _arg220745_)
                                                          (std/db/_sqlite#sqlite3_bind_blob
                                                           _stmt220704_
                                                           _param220746_
                                                           _arg220745_)
                                                          (if error
                                                              _arg220745_
                                                              '#!void)))))))
                                       (_arg220751_ _g220730220736_)
                                       (_param220753_ _g220731220738_))
                                  (_K220734220748_ _arg220751_ _param220753_)))
                              (_lp220719_)))))
                    (std/iter#iter-fini! _g220709220714_)
                    (std/iter#iter-fini! _g220710220716_)
                    '#!void)))))
        (if (##structure-direct-instance-of?
             _self220691220697_
             'std/db/sqlite#sqlite-statement::t)
            (let* ((_e220695220758_ (##vector-ref _self220691220697_ '1))
                   (_stmt220761_ _e220695220758_))
              (_K220694220755_ _stmt220761_))
            (_E220693220701_)))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'bind
   std/db/sqlite#sqlite-statement::bind
   '#f)
  (define std/db/sqlite#sqlite-statement::clear
    (lambda (_self220565_)
      (std/db/_sqlite#sqlite3_clear_bindings
       (##structure-ref _self220565_ '1 std/db/dbi#statement::t '#f))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'clear
   std/db/sqlite#sqlite-statement::clear
   '#f)
  (define std/db/sqlite#sqlite-statement::reset
    (lambda (_self220441_)
      (std/db/_sqlite#sqlite3_reset
       (##structure-ref _self220441_ '1 std/db/dbi#statement::t '#f))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'reset
   std/db/sqlite#sqlite-statement::reset
   '#f)
  (define std/db/sqlite#sqlite-statement::exec
    (lambda (_self220290_)
      (let* ((_self220291220297_ _self220290_)
             (_E220293220301_
              (lambda () (error '"No clause matching" _self220291220297_)))
             (_K220294220311_
              (lambda (_stmt220304_)
                (let ((_r220306_ (std/db/_sqlite#sqlite3_step _stmt220304_)))
                  (if (or (eq? _r220306_ std/db/_sqlite#SQLITE_DONE)
                          (eq? _r220306_ std/db/_sqlite#SQLITE_ROW))
                      '#!void
                      (std/db/sqlite#raise-sqlite-error
                       'sqlite-exec
                       _r220306_))))))
        (if (##structure-direct-instance-of?
             _self220291220297_
             'std/db/sqlite#sqlite-statement::t)
            (let* ((_e220295220314_ (##vector-ref _self220291220297_ '1))
                   (_stmt220317_ _e220295220314_))
              (_K220294220311_ _stmt220317_))
            (_E220293220301_)))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'exec
   std/db/sqlite#sqlite-statement::exec
   '#f)
  (define std/db/sqlite#sqlite-statement::query-start void)
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'query-start
   std/db/sqlite#sqlite-statement::query-start
   '#f)
  (define std/db/sqlite#sqlite-statement::query-fetch
    (lambda (_self220020_)
      (let* ((_self220021220027_ _self220020_)
             (_E220023220031_
              (lambda () (error '"No clause matching" _self220021220027_)))
             (_K220024220038_
              (lambda (_stmt220034_)
                (let ((_r220036_ (std/db/_sqlite#sqlite3_step _stmt220034_)))
                  (if (eq? _r220036_ std/db/_sqlite#SQLITE_ROW)
                      '#!void
                      (if (eq? _r220036_ std/db/_sqlite#SQLITE_DONE)
                          std/iter#iter-end
                          (std/db/sqlite#raise-sqlite-error
                           'sqlite-query-fetch
                           _r220036_)))))))
        (if (##structure-direct-instance-of?
             _self220021220027_
             'std/db/sqlite#sqlite-statement::t)
            (let* ((_e220025220041_ (##vector-ref _self220021220027_ '1))
                   (_stmt220044_ _e220025220041_))
              (_K220024220038_ _stmt220044_))
            (_E220023220031_)))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'query-fetch
   std/db/sqlite#sqlite-statement::query-fetch
   '#f)
  (define std/db/sqlite#sqlite-statement::query-row
    (lambda (_self219818_)
      (let* ((_self219819219825_ _self219818_)
             (_E219821219829_
              (lambda () (error '"No clause matching" _self219819219825_)))
             (_K219822219890_
              (lambda (_stmt219832_)
                (letrec ((_column-e219834_
                          (lambda (_col219881_)
                            (let ((_t219883_
                                   (std/db/_sqlite#sqlite3_column_type
                                    _stmt219832_
                                    _col219881_)))
                              (if (eq? _t219883_ std/db/_sqlite#SQLITE_INTEGER)
                                  (std/db/_sqlite#sqlite3_column_int64
                                   _stmt219832_
                                   _col219881_)
                                  (if (eq? _t219883_
                                           std/db/_sqlite#SQLITE_FLOAT)
                                      (std/db/_sqlite#sqlite3_column_double
                                       _stmt219832_
                                       _col219881_)
                                      (if (eq? _t219883_
                                               std/db/_sqlite#SQLITE_TEXT)
                                          (std/db/_sqlite#sqlite3_column_text
                                           _stmt219832_
                                           _col219881_)
                                          (if (eq? _t219883_
                                                   std/db/_sqlite#SQLITE_NULL)
                                              '#f
                                              (if (eq? _t219883_
                                                       std/db/_sqlite#SQLITE_BLOB)
                                                  (let* ((_count219885_
                                                          (std/db/_sqlite#sqlite3_column_bytes
                                                           _stmt219832_
                                                           _col219881_))
                                                         (_bytes219887_
                                                          (make-u8vector
                                                           _count219885_)))
                                                    (std/db/_sqlite#sqlite3_column_blob
                                                     _stmt219832_
                                                     _col219881_
                                                     _bytes219887_)
                                                    _bytes219887_)
                                                  (error '"Unexpected column type"
                                                         _t219883_))))))))))
                  (let* ((_count219836_
                          (std/db/_sqlite#sqlite3_column_count _stmt219832_))
                         (_$e219838_ _count219836_))
                    (if (eq? '0 _$e219838_)
                        '#!void
                        (if (eq? '1 _$e219838_)
                            (_column-e219834_ '0)
                            (list->vector
                             (let ((_iterable219862_
                                    (std/iter#in-range__0 _count219836_))
                                   (_iter-do219864_
                                    (lambda (_val219841_)
                                      (let* ((_val219843219848_ _val219841_)
                                             (_E219845219852_
                                              (lambda ()
                                                (error '"No clause matching"
                                                       _val219843219848_)))
                                             (_K219846219857_
                                              (lambda (_x219855_)
                                                (_column-e219834_ _x219855_)))
                                             (_x219860_ _val219843219848_))
                                        (_column-e219834_ _x219860_)))))
                               (if (pair? _iterable219862_)
                                   (map _iter-do219864_ _iterable219862_)
                                   (if (null? _iterable219862_)
                                       '()
                                       (let ((_it219867_
                                              (std/iter#iter
                                               _iterable219862_)))
                                         (let _lp219870_ ((_rval219873_ '()))
                                           (let ((_val219876_
                                                  (std/iter#iter-next!
                                                   _it219867_)))
                                             (if (eq? std/iter#iter-end
                                                      _val219876_)
                                                 (begin
                                                   (std/iter#iter-fini!
                                                    _it219867_)
                                                   (reverse _rval219873_))
                                                 (let ((_xval219878_
                                                        (_iter-do219864_
                                                         _val219876_)))
                                                   (_lp219870_
                                                    (cons _xval219878_
                                                          _rval219873_))))))))))))))))))
        (if (##structure-direct-instance-of?
             _self219819219825_
             'std/db/sqlite#sqlite-statement::t)
            (let* ((_e219823219893_ (##vector-ref _self219819219825_ '1))
                   (_stmt219896_ _e219823219893_))
              (_K219822219890_ _stmt219896_))
            (_E219821219829_)))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'query-row
   std/db/sqlite#sqlite-statement::query-row
   '#f)
  (define std/db/sqlite#sqlite-statement::query-fini
    std/db/sqlite#sqlite-statement::reset)
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'query-fini
   std/db/sqlite#sqlite-statement::query-fini
   '#f)
  (define std/db/sqlite#sqlite-statement::columns
    (lambda (_self219541_)
      (let* ((_self219542219548_ _self219541_)
             (_E219544219552_
              (lambda () (error '"No clause matching" _self219542219548_)))
             (_K219545219566_
              (lambda (_stmt219555_)
                (let ((_count219557_
                       (std/db/_sqlite#sqlite3_column_count _stmt219555_)))
                  (let _lp219559_ ((_k219561_ '0) (_cols219562_ '()))
                    (if (##fx< _k219561_ _count219557_)
                        (let ((_name219564_
                               (std/db/_sqlite#sqlite3_column_name
                                _stmt219555_
                                _k219561_)))
                          (_lp219559_
                           (##fx+ _k219561_ '1)
                           (cons _name219564_ _cols219562_)))
                        (reverse _cols219562_)))))))
        (if (##structure-direct-instance-of?
             _self219542219548_
             'std/db/sqlite#sqlite-statement::t)
            (let* ((_e219546219569_ (##vector-ref _self219542219548_ '1))
                   (_stmt219572_ _e219546219569_))
              (_K219545219566_ _stmt219572_))
            (_E219544219552_)))))
  (bind-method!
   std/db/sqlite#sqlite-statement::t
   'columns
   std/db/sqlite#sqlite-statement::columns
   '#f))
