"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var commons_1 = require("../../../../../utils/commons");
var axis_type_utils_1 = require("../../../utils/axis_type_utils");
var text_1 = require("../primitives/text");
var debug_1 = require("../utils/debug");
function renderTitle(ctx, props) {
    var _a = props.axisSpec, title = _a.title, position = _a.position;
    if (!title) {
        return null;
    }
    if (axis_type_utils_1.isHorizontalAxis(position)) {
        return renderHorizontalTitle(ctx, props);
    }
    return renderVerticalTitle(ctx, props);
}
exports.renderTitle = renderTitle;
function renderVerticalTitle(ctx, props) {
    var height = props.axisPosition.height, _a = props.axisSpec, title = _a.title, position = _a.position, tickSize = _a.tickSize, tickPadding = _a.tickPadding, maxLabelBboxWidth = props.axisTicksDimensions.maxLabelBboxWidth, axisTitleStyle = props.axisConfig.axisTitleStyle, debug = props.debug;
    if (!title) {
        return null;
    }
    var padding = axisTitleStyle.padding, titleStyle = __rest(axisTitleStyle, ["padding"]);
    var top = height;
    var left = position === commons_1.Position.Left ? 0 : tickSize + tickPadding + maxLabelBboxWidth + padding;
    if (debug) {
        debug_1.renderDebugRect(ctx, { x: left, y: top, width: height, height: titleStyle.fontSize }, undefined, undefined, -90);
    }
    var font = {
        fontFamily: titleStyle.fontFamily,
        fontVariant: 'normal',
        fontStyle: titleStyle.fontStyle ? titleStyle.fontStyle : 'normal',
        fontWeight: 'normal',
        textColor: titleStyle.fill,
        textOpacity: 1,
    };
    text_1.renderText(ctx, {
        x: left + titleStyle.fontSize / 2,
        y: top - height / 2,
    }, title, __assign(__assign({}, font), { fill: titleStyle.fill, align: 'center', baseline: 'middle', fontSize: titleStyle.fontSize }), -90);
}
function renderHorizontalTitle(ctx, props) {
    var width = props.axisPosition.width, _a = props.axisSpec, title = _a.title, position = _a.position, tickSize = _a.tickSize, tickPadding = _a.tickPadding, maxLabelBboxHeight = props.axisTicksDimensions.maxLabelBboxHeight, _b = props.axisConfig.axisTitleStyle, padding = _b.padding, titleStyle = __rest(_b, ["padding"]), debug = props.debug;
    if (!title) {
        return;
    }
    var top = position === commons_1.Position.Top ? 0 : maxLabelBboxHeight + tickPadding + tickSize + padding;
    var left = 0;
    if (debug) {
        debug_1.renderDebugRect(ctx, { x: left, y: top, width: width, height: titleStyle.fontSize });
    }
    var font = {
        fontFamily: titleStyle.fontFamily,
        fontVariant: 'normal',
        fontStyle: titleStyle.fontStyle ? titleStyle.fontStyle : 'normal',
        fontWeight: 'normal',
        textColor: titleStyle.fill,
        textOpacity: 1,
    };
    text_1.renderText(ctx, {
        x: left + width / 2,
        y: top + titleStyle.fontSize / 2,
    }, title, __assign(__assign({}, font), { fill: titleStyle.fill, align: 'center', baseline: 'middle', fontSize: titleStyle.fontSize }));
}
//# sourceMappingURL=title.js.map