"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var text_1 = require("../primitives/text");
var debug_1 = require("../utils/debug");
function renderBarValues(ctx, props) {
    var bars = props.bars, debug = props.debug, chartRotation = props.chartRotation, chartDimensions = props.chartDimensions, theme = props.theme;
    var _a = theme.barSeriesStyle.displayValue, fontFamily = _a.fontFamily, fontStyle = _a.fontStyle, fill = _a.fill, fontSize = _a.fontSize;
    var barsLength = bars.length;
    for (var i = 0; i < barsLength; i++) {
        var displayValue = bars[i].displayValue;
        if (!displayValue) {
            continue;
        }
        var text = displayValue.text;
        var textLines = {
            lines: [text],
            width: displayValue.width,
            height: displayValue.height,
        };
        var font = {
            fontFamily: fontFamily,
            fontStyle: fontStyle ? fontStyle : 'normal',
            fontVariant: 'normal',
            fontWeight: 'normal',
            textColor: 'black',
            textOpacity: 1,
        };
        var _b = positionText(bars[i], displayValue, chartRotation, theme.barSeriesStyle.displayValue), x = _b.x, y = _b.y, align = _b.align, baseline = _b.baseline, rect = _b.rect;
        if (displayValue.isValueContainedInElement) {
            var width_1 = chartRotation === 0 || chartRotation === 180 ? bars[i].width : bars[i].height;
            textLines = text_1.wrapLines(ctx, textLines.lines[0], font, fontSize, width_1, 100);
        }
        if (displayValue.hideClippedValue && isOverflow(rect, chartDimensions, chartRotation)) {
            continue;
        }
        if (debug) {
            debug_1.renderDebugRect(ctx, rect);
        }
        var width = textLines.width, height = textLines.height;
        var linesLength = textLines.lines.length;
        for (var i_1 = 0; i_1 < linesLength; i_1++) {
            var text_2 = textLines.lines[i_1];
            var origin_1 = repositionTextLine({ x: x, y: y }, chartRotation, i_1, linesLength, { height: height, width: width });
            text_1.renderText(ctx, origin_1, text_2, __assign(__assign({}, font), { fill: fill,
                fontSize: fontSize,
                align: align,
                baseline: baseline }), -chartRotation);
        }
    }
}
exports.renderBarValues = renderBarValues;
function repositionTextLine(origin, chartRotation, i, max, box) {
    var x = origin.x, y = origin.y;
    var width = box.width, height = box.height;
    var lineX;
    var lineY;
    switch (chartRotation) {
        case 180:
            lineX = x;
            lineY = y - (i - max + 1) * height;
            break;
        case -90:
            lineX = x;
            lineY = y;
            break;
        case 90:
            lineX = x;
            lineY = y - (i - max + 1) * width;
            break;
        case 0:
        default:
            lineX = x;
            lineY = y + i * height;
    }
    return { x: lineX, y: lineY };
}
function positionText(geom, valueBox, chartRotation, offsets) {
    var offsetX = offsets.offsetX, offsetY = offsets.offsetY;
    var baseline = 'top';
    var align = 'center';
    var x = geom.x + geom.width / 2 - offsetX;
    var y = geom.y - offsetY;
    var rect = {
        x: x - valueBox.width / 2,
        y: y,
        width: valueBox.width,
        height: valueBox.height,
    };
    if (chartRotation === 180) {
        baseline = 'bottom';
        x = geom.x + geom.width / 2 + offsetX;
        y = geom.y + offsetY;
        rect.x = x - valueBox.width / 2;
        rect.y = y;
    }
    if (chartRotation === 90) {
        x = geom.x - offsetY;
        y = geom.y + offsetX;
        align = 'right';
        rect.x = x;
        rect.y = y;
        rect.width = valueBox.height;
        rect.height = valueBox.width;
    }
    if (chartRotation === -90) {
        x = geom.x + geom.width + offsetY;
        y = geom.y - offsetX;
        align = 'left';
        rect.x = x - valueBox.height;
        rect.y = y;
        rect.width = valueBox.height;
        rect.height = valueBox.width;
    }
    return {
        x: x,
        y: y,
        align: align,
        baseline: baseline,
        rect: rect,
    };
}
function isOverflow(rect, chartDimensions, chartRotation) {
    var cWidth = chartDimensions.width;
    var cHeight = chartDimensions.height;
    if (chartRotation === 90 || chartRotation === -90) {
        cWidth = chartDimensions.height;
        cHeight = chartDimensions.width;
    }
    if (rect.x < 0 || rect.x + rect.width > cWidth) {
        return true;
    }
    if (rect.y < 0 || rect.y + rect.height > cHeight) {
        return true;
    }
    return false;
}
//# sourceMappingURL=bar.js.map