"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importStar(require("react"));
var specs_1 = require("../../../../specs");
exports.TooltipContent = function (_a) {
    var annotationType = _a.annotationType, header = _a.header, details = _a.details, CustomTooltip = _a.customTooltip, customTooltipDetails = _a.customTooltipDetails;
    var renderLine = react_1.useCallback(function () { return (react_1.default.createElement("div", { className: "echAnnotation__tooltip" },
        react_1.default.createElement("p", { className: "echAnnotation__header" }, header),
        react_1.default.createElement("div", { className: "echAnnotation__details" }, customTooltipDetails ? customTooltipDetails(details) : details))); }, [header, details, customTooltipDetails]);
    var renderRect = react_1.useCallback(function () {
        var tooltipContent = customTooltipDetails ? customTooltipDetails(details) : details;
        if (!tooltipContent) {
            return null;
        }
        return (react_1.default.createElement("div", { className: "echAnnotation__tooltip" },
            react_1.default.createElement("div", { className: "echAnnotation__details" },
                react_1.default.createElement("div", { className: "echAnnotation__detailsText" }, tooltipContent))));
    }, [details, customTooltipDetails]);
    if (CustomTooltip) {
        return react_1.default.createElement(CustomTooltip, { details: details, header: header });
    }
    switch (annotationType) {
        case specs_1.AnnotationTypes.Line: {
            return renderLine();
        }
        case specs_1.AnnotationTypes.Rectangle: {
            return renderRect();
        }
        default:
            return null;
    }
};
//# sourceMappingURL=tooltip_content.js.map