"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var react_redux_1 = require("react-redux");
var canvas_1 = require("../../../../renderers/canvas");
var get_chart_container_dimensions_1 = require("../../../../state/selectors/get_chart_container_dimensions");
var get_internal_is_intialized_1 = require("../../../../state/selectors/get_internal_is_intialized");
var compute_chart_dimensions_1 = require("../../state/selectors/compute_chart_dimensions");
var get_brush_area_1 = require("../../state/selectors/get_brush_area");
var is_brush_available_1 = require("../../state/selectors/is_brush_available");
var is_brushing_1 = require("../../state/selectors/is_brushing");
var rect_1 = require("../canvas/primitives/rect");
var BrushToolComponent = (function (_super) {
    __extends(BrushToolComponent, _super);
    function BrushToolComponent(props) {
        var _this = _super.call(this, props) || this;
        _this.drawCanvas = function () {
            var _a = _this.props, brushArea = _a.brushArea, chartDimensions = _a.chartDimensions;
            if (!_this.ctx || !brushArea) {
                return;
            }
            var top = brushArea.top, left = brushArea.left, width = brushArea.width, height = brushArea.height;
            canvas_1.withContext(_this.ctx, function (ctx) {
                ctx.scale(_this.devicePixelRatio, _this.devicePixelRatio);
                canvas_1.withClip(ctx, {
                    x: chartDimensions.left,
                    y: chartDimensions.top,
                    width: chartDimensions.width,
                    height: chartDimensions.height,
                }, function (ctx) {
                    canvas_1.clearCanvas(ctx, 200000, 200000);
                    ctx.translate(chartDimensions.left, chartDimensions.top);
                    rect_1.renderRect(ctx, {
                        x: left,
                        y: top,
                        width: width,
                        height: height,
                    }, {
                        color: {
                            r: 128,
                            g: 128,
                            b: 128,
                            opacity: 0.6,
                        },
                    });
                });
            });
        };
        _this.ctx = null;
        _this.devicePixelRatio = window.devicePixelRatio;
        _this.canvasRef = react_1.default.createRef();
        return _this;
    }
    BrushToolComponent.prototype.componentDidMount = function () {
        this.tryCanvasContext();
        this.drawCanvas();
    };
    BrushToolComponent.prototype.componentDidUpdate = function () {
        if (!this.ctx) {
            this.tryCanvasContext();
        }
        if (this.props.initialized) {
            this.drawCanvas();
        }
    };
    BrushToolComponent.prototype.tryCanvasContext = function () {
        var canvas = this.canvasRef.current;
        this.ctx = canvas && canvas.getContext('2d');
    };
    BrushToolComponent.prototype.render = function () {
        var _a = this.props, initialized = _a.initialized, isBrushAvailable = _a.isBrushAvailable, isBrushing = _a.isBrushing, chartContainerDimensions = _a.chartContainerDimensions;
        if (!initialized || !isBrushAvailable || !isBrushing) {
            this.ctx = null;
            return null;
        }
        var width = chartContainerDimensions.width, height = chartContainerDimensions.height;
        return (react_1.default.createElement("canvas", { ref: this.canvasRef, className: "echBrushTool", width: width * this.devicePixelRatio, height: height * this.devicePixelRatio, style: {
                width: width,
                height: height,
            } }));
    };
    BrushToolComponent.displayName = 'BrushToolComponent';
    return BrushToolComponent;
}(react_1.default.Component));
var mapStateToProps = function (state) {
    if (get_internal_is_intialized_1.getInternalIsInitializedSelector(state) !== get_internal_is_intialized_1.InitStatus.Initialized) {
        return {
            initialized: false,
            isBrushing: false,
            isBrushAvailable: false,
            brushArea: null,
            chartContainerDimensions: {
                width: 0,
                height: 0,
                left: 0,
                top: 0,
            },
            chartDimensions: {
                top: 0,
                left: 0,
                width: 0,
                height: 0,
            },
        };
    }
    return {
        initialized: state.specsInitialized,
        chartContainerDimensions: get_chart_container_dimensions_1.getChartContainerDimensionsSelector(state),
        brushArea: get_brush_area_1.getBrushAreaSelector(state),
        isBrushAvailable: is_brush_available_1.isBrushAvailableSelector(state),
        chartDimensions: compute_chart_dimensions_1.computeChartDimensionsSelector(state).chartDimensions,
        isBrushing: is_brushing_1.isBrushingSelector(state),
    };
};
exports.BrushTool = react_redux_1.connect(mapStateToProps)(BrushToolComponent);
//# sourceMappingURL=brush.js.map