function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance"); }

function _iterableToArray(iter) { if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from "prop-types";
import { defaults } from 'lodash';
import classNames from 'classnames';
import { keysOf } from '../common';
import { isColorDark, hexToRgb } from '../../services';
import { EuiIcon } from '../icon';
import { TOKEN_MAP } from './token_map';
var sizeToClassMap = {
  xs: 'euiToken--xsmall',
  s: 'euiToken--small',
  m: 'euiToken--medium',
  l: 'euiToken--large'
};
export var SIZES = keysOf(sizeToClassMap);
var shapeToClassMap = {
  circle: 'euiToken--circle',
  square: 'euiToken--square',
  rectangle: 'euiToken--rectangle'
};
export var SHAPES = keysOf(shapeToClassMap);
var fillToClassMap = {
  none: null,
  light: 'euiToken--light',
  dark: 'euiToken--dark'
};
export var FILLS = keysOf(fillToClassMap);
var colorToClassMap = {
  euiColorVis0: 'euiToken--euiColorVis0',
  euiColorVis1: 'euiToken--euiColorVis1',
  euiColorVis2: 'euiToken--euiColorVis2',
  euiColorVis3: 'euiToken--euiColorVis3',
  euiColorVis4: 'euiToken--euiColorVis4',
  euiColorVis5: 'euiToken--euiColorVis5',
  euiColorVis6: 'euiToken--euiColorVis6',
  euiColorVis7: 'euiToken--euiColorVis7',
  euiColorVis8: 'euiToken--euiColorVis8',
  euiColorVis9: 'euiToken--euiColorVis9',
  gray: 'euiToken--gray'
};
export var COLORS = keysOf(colorToClassMap);
export var EuiToken = function EuiToken(_ref) {
  var iconType = _ref.iconType,
      color = _ref.color,
      fill = _ref.fill,
      shape = _ref.shape,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 's' : _ref$size,
      _ref$style = _ref.style,
      style = _ref$style === void 0 ? {} : _ref$style,
      className = _ref.className,
      title = _ref.title,
      ariaLabel = _ref['aria-label'],
      ariaLabelledby = _ref['aria-labelledby'],
      ariaDescribedby = _ref['aria-describedby'],
      rest = _objectWithoutProperties(_ref, ["iconType", "color", "fill", "shape", "size", "style", "className", "title", "aria-label", "aria-labelledby", "aria-describedby"]);

  // Set the icon size to the same as the passed size
  // unless they passed `xs` which IconSize doesn't support
  var finalSize = size === 'xs' ? 's' : size; // When displaying at the small size, the token specific icons
  // should actually be displayed at medium size

  if (typeof iconType === 'string' && iconType.indexOf('token') === 0 && size === 's') {
    finalSize = 'm';
  }

  var currentDisplay = {
    color: color,
    fill: fill,
    shape: shape
  };
  var finalDisplay; // If the iconType passed is one of the prefab token types,
  // grab its properties

  if (iconType in TOKEN_MAP) {
    var tokenDisplay = TOKEN_MAP[iconType];
    finalDisplay = defaults(currentDisplay, tokenDisplay);
  } else {
    finalDisplay = currentDisplay;
  }

  var finalColor = finalDisplay.color || 'gray';
  var finalShape = finalDisplay.shape || 'circle';
  var finalFill = finalDisplay.fill || 'light'; // Color can be a named space via euiColorVis

  var colorClass;

  if (finalColor in colorToClassMap) {
    colorClass = colorToClassMap[finalColor];
  } // Or it can be a string which adds inline styles for the
  else {
      // text color if fill='none' or
      if (finalFill === 'none') {
        style.color = finalColor;
      } // full background color if fill='dark' and overrides fill='light' with dark
      else {
          finalFill = 'dark';
          style.backgroundColor = finalColor;
          style.color = isColorDark.apply(void 0, _toConsumableArray(hexToRgb(finalColor))) ? '#FFFFFF' : '#000000';
        }
    }

  var classes = classNames('euiToken', colorClass, shapeToClassMap[finalShape], fillToClassMap[finalFill], sizeToClassMap[size], className);
  return React.createElement("span", _extends({
    className: classes,
    style: style
  }, rest), React.createElement(EuiIcon, {
    type: iconType,
    size: finalSize,
    title: title,
    "aria-label": ariaLabel,
    "aria-labelledby": ariaLabelledby,
    "aria-describedby": ariaDescribedby
  }));
};
EuiToken.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,

  /**
     * An EUI icon type
     */
  iconType: PropTypes.oneOfType([PropTypes.oneOf(["accessibility", "addDataApp", "advancedSettingsApp", "aggregate", "alert", "annotation", "apmApp", "apmTrace", "apps", "arrowDown", "arrowLeft", "arrowRight", "arrowUp", "asterisk", "auditbeatApp", "beaker", "bell", "bellSlash", "bolt", "boxesHorizontal", "boxesVertical", "branch", "broom", "brush", "bug", "bullseye", "calendar", "canvasApp", "codeApp", "check", "checkInCircleFilled", "cheer", "clock", "cloudDrizzle", "cloudStormy", "cloudSunny", "compute", "console", "consoleApp", "controlsHorizontal", "controlsVertical", "copy", "copyClipboard", "createAdvancedJob", "createMultiMetricJob", "createPopulationJob", "createSingleMetricJob", "cross", "crossClusterReplicationApp", "crosshairs", "crossInACircleFilled", "currency", "cut", "dashboardApp", "database", "dataVisualizer", "devToolsApp", "discoverApp", "document", "documentEdit", "documents", "dot", "download", "editorAlignCenter", "editorAlignLeft", "editorAlignRight", "editorBold", "editorCodeBlock", "editorComment", "editorDistributeHorizontal", "editorDistributeVertical", "editorHeading", "editorItalic", "editorItemAlignLeft", "editorItemAlignBottom", "editorItemAlignCenter", "editorItemAlignMiddle", "editorItemAlignRight", "editorItemAlignTop", "editorLink", "editorOrderedList", "editorPositionBottomLeft", "editorPositionBottomRight", "editorPositionTopLeft", "editorPositionTopRight", "editorRedo", "editorStrike", "editorTable", "editorUnderline", "editorUndo", "editorUnorderedList", "email", "empty", "emsApp", "exit", "expand", "expandMini", "exportAction", "eye", "eyeClosed", "faceHappy", "faceNeutral", "faceSad", "filebeatApp", "filter", "flag", "folderCheck", "folderClosed", "folderExclamation", "folderOpen", "fullScreen", "gear", "gisApp", "glasses", "globe", "grab", "grabHorizontal", "graphApp", "grid", "grokApp", "heart", "heartbeatApp", "heatmap", "help", "home", "iInCircle", "image", "importAction", "indexClose", "indexEdit", "indexFlush", "indexManagementApp", "indexMapping", "indexOpen", "indexPatternApp", "indexRollupApp", "indexSettings", "inputOutput", "inspect", "invert", "ip", "keyboardShortcut", "kqlField", "kqlFunction", "kqlOperand", "kqlSelector", "kqlValue", "lensApp", "link", "list", "listAdd", "lock", "lockOpen", "logsApp", "logoAerospike", "logoApache", "logoAPM", "logoAppSearch", "logoAWS", "logoAWSMono", "logoAzure", "logoAzureMono", "logoBeats", "logoBusinessAnalytics", "logoCeph", "logoCloud", "logoCloudEnterprise", "logoCode", "logoCodesandbox", "logoCouchbase", "logoDocker", "logoDropwizard", "logoElastic", "logoElasticsearch", "logoElasticStack", "logoEnterpriseSearch", "logoEtcd", "logoGCP", "logoGCPMono", "logoGithub", "logoGmail", "logoGolang", "logoGoogleG", "logoHAproxy", "logoIBM", "logoIBMMono", "logoKafka", "logoKibana", "logoKubernetes", "logoLogging", "logoLogstash", "logoMaps", "logoMemcached", "logoMetrics", "logoMongodb", "logoMySQL", "logoNginx", "logoObservability", "logoOsquery", "logoPhp", "logoPostgres", "logoPrometheus", "logoRabbitmq", "logoRedis", "logoSecurity", "logoSiteSearch", "logoSketch", "logoSlack", "logoUptime", "logoWebhook", "logoWindows", "logoWorkplaceSearch", "logstashFilter", "logstashIf", "logstashInput", "logstashOutput", "logstashQueue", "machineLearningApp", "magnet", "magnifyWithMinus", "magnifyWithPlus", "managementApp", "mapMarker", "memory", "menu", "menuLeft", "menuRight", "merge", "metricbeatApp", "metricsApp", "minimize", "minusInCircle", "minusInCircleFilled", "monitoringApp", "moon", "nested", "node", "notebookApp", "number", "offline", "online", "package", "packetbeatApp", "pageSelect", "pagesSelect", "partial", "paperClip", "pause", "pencil", "pin", "pinFilled", "pipelineApp", "play", "plusInCircle", "plusInCircleFilled", "popout", "push", "questionInCircle", "quote", "recentlyViewedApp", "refresh", "reporter", "reportingApp", "save", "savedObjectsApp", "scale", "search", "searchProfilerApp", "securityAnalyticsApp", "securityApp", "securitySignal", "securitySignalDetected", "securitySignalResolved", "shard", "share", "snowflake", "sortable", "sortDown", "sortLeft", "sortRight", "sortUp", "spacesApp", "sqlApp", "starEmpty", "starEmptySpace", "starFilled", "starFilledSpace", "starMinusEmpty", "starMinusFilled", "starPlusEmpty", "starPlusFilled", "stats", "stop", "stopFilled", "stopSlash", "storage", "string", "submodule", "swatchInput", "symlink", "tableOfContents", "tableDensityExpanded", "tableDensityCompact", "tableDensityNormal", "tag", "tear", "temperature", "timeline", "timelionApp", "training", "trash", "upgradeAssistantApp", "uptimeApp", "user", "users", "usersRolesApp", "vector", "videoPlayer", "visArea", "visAreaStacked", "visBarHorizontal", "visBarHorizontalStacked", "visBarVertical", "visBarVerticalStacked", "visGauge", "visGoal", "visLine", "visMapCoordinate", "visMapRegion", "visMetric", "visPie", "visTable", "visTagCloud", "visText", "visTimelion", "visualizeApp", "visVega", "visVisualBuilder", "watchesApp", "wrench", "tokenClass", "tokenProperty", "tokenEnum", "tokenVariable", "tokenMethod", "tokenAnnotation", "tokenException", "tokenInterface", "tokenParameter", "tokenField", "tokenElement", "tokenFunction", "tokenBoolean", "tokenString", "tokenArray", "tokenNumber", "tokenConstant", "tokenObject", "tokenEvent", "tokenKey", "tokenNull", "tokenStruct", "tokenPackage", "tokenOperator", "tokenEnumMember", "tokenRepo", "tokenSymbol", "tokenFile", "tokenModule", "tokenNamespace", "tokenDate", "tokenIP", "tokenNested", "tokenAlias", "tokenShape", "tokenGeo", "tokenRange", "tokenBinary", "tokenJoin", "tokenPercolator", "tokenFlattened", "tokenRankFeature", "tokenRankFeatures", "tokenKeyword", "tokenCompletionSuggester", "tokenDenseVector", "tokenText", "tokenTokenCount", "tokenSearchType", "tokenHistogram"]).isRequired, PropTypes.string.isRequired, PropTypes.elementType.isRequired]).isRequired,

  /**
     * For best results use one of the vis color names (or 'gray').
     * Or supply your own color (can be used with dark or no fill only).
     * Default: `gray`
     */
  color: PropTypes.oneOfType([PropTypes.oneOf(["euiColorVis0", "euiColorVis1", "euiColorVis2", "euiColorVis3", "euiColorVis4", "euiColorVis5", "euiColorVis6", "euiColorVis7", "euiColorVis8", "euiColorVis9", "gray"]).isRequired, PropTypes.string.isRequired]),

  /**
     * Outer shape surrounding the icon
     * Default: `circle`
     */
  shape: PropTypes.oneOf(["circle", "square", "rectangle"]),

  /**
     * `light` for lightened color with border, `dark` for solid, or `none`
     * Default: `light`
     */
  fill: PropTypes.oneOf(["dark", "light", "none"]),

  /**
     * Size of the token
     */
  size: PropTypes.oneOf(["xs", "s", "m", "l"]),

  /**
     * The icon's title. Required for accessibility
     */
  title: PropTypes.string,
  "aria-labelledby": PropTypes.string,
  "aria-describedby": PropTypes.string
};
EuiToken.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiToken",
  "props": {
    "size": {
      "defaultValue": {
        "value": "'s'",
        "computed": false
      },
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"xs\"",
          "computed": false
        }, {
          "value": "\"s\"",
          "computed": false
        }, {
          "value": "\"m\"",
          "computed": false
        }, {
          "value": "\"l\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Size of the token"
    },
    "style": {
      "defaultValue": {
        "value": "{}",
        "computed": false
      },
      "required": false
    },
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "iconType": {
      "type": {
        "name": "union",
        "value": [{
          "name": "enum",
          "value": [{
            "value": "\"accessibility\"",
            "computed": false
          }, {
            "value": "\"addDataApp\"",
            "computed": false
          }, {
            "value": "\"advancedSettingsApp\"",
            "computed": false
          }, {
            "value": "\"aggregate\"",
            "computed": false
          }, {
            "value": "\"alert\"",
            "computed": false
          }, {
            "value": "\"annotation\"",
            "computed": false
          }, {
            "value": "\"apmApp\"",
            "computed": false
          }, {
            "value": "\"apmTrace\"",
            "computed": false
          }, {
            "value": "\"apps\"",
            "computed": false
          }, {
            "value": "\"arrowDown\"",
            "computed": false
          }, {
            "value": "\"arrowLeft\"",
            "computed": false
          }, {
            "value": "\"arrowRight\"",
            "computed": false
          }, {
            "value": "\"arrowUp\"",
            "computed": false
          }, {
            "value": "\"asterisk\"",
            "computed": false
          }, {
            "value": "\"auditbeatApp\"",
            "computed": false
          }, {
            "value": "\"beaker\"",
            "computed": false
          }, {
            "value": "\"bell\"",
            "computed": false
          }, {
            "value": "\"bellSlash\"",
            "computed": false
          }, {
            "value": "\"bolt\"",
            "computed": false
          }, {
            "value": "\"boxesHorizontal\"",
            "computed": false
          }, {
            "value": "\"boxesVertical\"",
            "computed": false
          }, {
            "value": "\"branch\"",
            "computed": false
          }, {
            "value": "\"broom\"",
            "computed": false
          }, {
            "value": "\"brush\"",
            "computed": false
          }, {
            "value": "\"bug\"",
            "computed": false
          }, {
            "value": "\"bullseye\"",
            "computed": false
          }, {
            "value": "\"calendar\"",
            "computed": false
          }, {
            "value": "\"canvasApp\"",
            "computed": false
          }, {
            "value": "\"codeApp\"",
            "computed": false
          }, {
            "value": "\"check\"",
            "computed": false
          }, {
            "value": "\"checkInCircleFilled\"",
            "computed": false
          }, {
            "value": "\"cheer\"",
            "computed": false
          }, {
            "value": "\"clock\"",
            "computed": false
          }, {
            "value": "\"cloudDrizzle\"",
            "computed": false
          }, {
            "value": "\"cloudStormy\"",
            "computed": false
          }, {
            "value": "\"cloudSunny\"",
            "computed": false
          }, {
            "value": "\"compute\"",
            "computed": false
          }, {
            "value": "\"console\"",
            "computed": false
          }, {
            "value": "\"consoleApp\"",
            "computed": false
          }, {
            "value": "\"controlsHorizontal\"",
            "computed": false
          }, {
            "value": "\"controlsVertical\"",
            "computed": false
          }, {
            "value": "\"copy\"",
            "computed": false
          }, {
            "value": "\"copyClipboard\"",
            "computed": false
          }, {
            "value": "\"createAdvancedJob\"",
            "computed": false
          }, {
            "value": "\"createMultiMetricJob\"",
            "computed": false
          }, {
            "value": "\"createPopulationJob\"",
            "computed": false
          }, {
            "value": "\"createSingleMetricJob\"",
            "computed": false
          }, {
            "value": "\"cross\"",
            "computed": false
          }, {
            "value": "\"crossClusterReplicationApp\"",
            "computed": false
          }, {
            "value": "\"crosshairs\"",
            "computed": false
          }, {
            "value": "\"crossInACircleFilled\"",
            "computed": false
          }, {
            "value": "\"currency\"",
            "computed": false
          }, {
            "value": "\"cut\"",
            "computed": false
          }, {
            "value": "\"dashboardApp\"",
            "computed": false
          }, {
            "value": "\"database\"",
            "computed": false
          }, {
            "value": "\"dataVisualizer\"",
            "computed": false
          }, {
            "value": "\"devToolsApp\"",
            "computed": false
          }, {
            "value": "\"discoverApp\"",
            "computed": false
          }, {
            "value": "\"document\"",
            "computed": false
          }, {
            "value": "\"documentEdit\"",
            "computed": false
          }, {
            "value": "\"documents\"",
            "computed": false
          }, {
            "value": "\"dot\"",
            "computed": false
          }, {
            "value": "\"download\"",
            "computed": false
          }, {
            "value": "\"editorAlignCenter\"",
            "computed": false
          }, {
            "value": "\"editorAlignLeft\"",
            "computed": false
          }, {
            "value": "\"editorAlignRight\"",
            "computed": false
          }, {
            "value": "\"editorBold\"",
            "computed": false
          }, {
            "value": "\"editorCodeBlock\"",
            "computed": false
          }, {
            "value": "\"editorComment\"",
            "computed": false
          }, {
            "value": "\"editorDistributeHorizontal\"",
            "computed": false
          }, {
            "value": "\"editorDistributeVertical\"",
            "computed": false
          }, {
            "value": "\"editorHeading\"",
            "computed": false
          }, {
            "value": "\"editorItalic\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignLeft\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignBottom\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignCenter\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignMiddle\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignRight\"",
            "computed": false
          }, {
            "value": "\"editorItemAlignTop\"",
            "computed": false
          }, {
            "value": "\"editorLink\"",
            "computed": false
          }, {
            "value": "\"editorOrderedList\"",
            "computed": false
          }, {
            "value": "\"editorPositionBottomLeft\"",
            "computed": false
          }, {
            "value": "\"editorPositionBottomRight\"",
            "computed": false
          }, {
            "value": "\"editorPositionTopLeft\"",
            "computed": false
          }, {
            "value": "\"editorPositionTopRight\"",
            "computed": false
          }, {
            "value": "\"editorRedo\"",
            "computed": false
          }, {
            "value": "\"editorStrike\"",
            "computed": false
          }, {
            "value": "\"editorTable\"",
            "computed": false
          }, {
            "value": "\"editorUnderline\"",
            "computed": false
          }, {
            "value": "\"editorUndo\"",
            "computed": false
          }, {
            "value": "\"editorUnorderedList\"",
            "computed": false
          }, {
            "value": "\"email\"",
            "computed": false
          }, {
            "value": "\"empty\"",
            "computed": false
          }, {
            "value": "\"emsApp\"",
            "computed": false
          }, {
            "value": "\"exit\"",
            "computed": false
          }, {
            "value": "\"expand\"",
            "computed": false
          }, {
            "value": "\"expandMini\"",
            "computed": false
          }, {
            "value": "\"exportAction\"",
            "computed": false
          }, {
            "value": "\"eye\"",
            "computed": false
          }, {
            "value": "\"eyeClosed\"",
            "computed": false
          }, {
            "value": "\"faceHappy\"",
            "computed": false
          }, {
            "value": "\"faceNeutral\"",
            "computed": false
          }, {
            "value": "\"faceSad\"",
            "computed": false
          }, {
            "value": "\"filebeatApp\"",
            "computed": false
          }, {
            "value": "\"filter\"",
            "computed": false
          }, {
            "value": "\"flag\"",
            "computed": false
          }, {
            "value": "\"folderCheck\"",
            "computed": false
          }, {
            "value": "\"folderClosed\"",
            "computed": false
          }, {
            "value": "\"folderExclamation\"",
            "computed": false
          }, {
            "value": "\"folderOpen\"",
            "computed": false
          }, {
            "value": "\"fullScreen\"",
            "computed": false
          }, {
            "value": "\"gear\"",
            "computed": false
          }, {
            "value": "\"gisApp\"",
            "computed": false
          }, {
            "value": "\"glasses\"",
            "computed": false
          }, {
            "value": "\"globe\"",
            "computed": false
          }, {
            "value": "\"grab\"",
            "computed": false
          }, {
            "value": "\"grabHorizontal\"",
            "computed": false
          }, {
            "value": "\"graphApp\"",
            "computed": false
          }, {
            "value": "\"grid\"",
            "computed": false
          }, {
            "value": "\"grokApp\"",
            "computed": false
          }, {
            "value": "\"heart\"",
            "computed": false
          }, {
            "value": "\"heartbeatApp\"",
            "computed": false
          }, {
            "value": "\"heatmap\"",
            "computed": false
          }, {
            "value": "\"help\"",
            "computed": false
          }, {
            "value": "\"home\"",
            "computed": false
          }, {
            "value": "\"iInCircle\"",
            "computed": false
          }, {
            "value": "\"image\"",
            "computed": false
          }, {
            "value": "\"importAction\"",
            "computed": false
          }, {
            "value": "\"indexClose\"",
            "computed": false
          }, {
            "value": "\"indexEdit\"",
            "computed": false
          }, {
            "value": "\"indexFlush\"",
            "computed": false
          }, {
            "value": "\"indexManagementApp\"",
            "computed": false
          }, {
            "value": "\"indexMapping\"",
            "computed": false
          }, {
            "value": "\"indexOpen\"",
            "computed": false
          }, {
            "value": "\"indexPatternApp\"",
            "computed": false
          }, {
            "value": "\"indexRollupApp\"",
            "computed": false
          }, {
            "value": "\"indexSettings\"",
            "computed": false
          }, {
            "value": "\"inputOutput\"",
            "computed": false
          }, {
            "value": "\"inspect\"",
            "computed": false
          }, {
            "value": "\"invert\"",
            "computed": false
          }, {
            "value": "\"ip\"",
            "computed": false
          }, {
            "value": "\"keyboardShortcut\"",
            "computed": false
          }, {
            "value": "\"kqlField\"",
            "computed": false
          }, {
            "value": "\"kqlFunction\"",
            "computed": false
          }, {
            "value": "\"kqlOperand\"",
            "computed": false
          }, {
            "value": "\"kqlSelector\"",
            "computed": false
          }, {
            "value": "\"kqlValue\"",
            "computed": false
          }, {
            "value": "\"lensApp\"",
            "computed": false
          }, {
            "value": "\"link\"",
            "computed": false
          }, {
            "value": "\"list\"",
            "computed": false
          }, {
            "value": "\"listAdd\"",
            "computed": false
          }, {
            "value": "\"lock\"",
            "computed": false
          }, {
            "value": "\"lockOpen\"",
            "computed": false
          }, {
            "value": "\"logsApp\"",
            "computed": false
          }, {
            "value": "\"logoAerospike\"",
            "computed": false
          }, {
            "value": "\"logoApache\"",
            "computed": false
          }, {
            "value": "\"logoAPM\"",
            "computed": false
          }, {
            "value": "\"logoAppSearch\"",
            "computed": false
          }, {
            "value": "\"logoAWS\"",
            "computed": false
          }, {
            "value": "\"logoAWSMono\"",
            "computed": false
          }, {
            "value": "\"logoAzure\"",
            "computed": false
          }, {
            "value": "\"logoAzureMono\"",
            "computed": false
          }, {
            "value": "\"logoBeats\"",
            "computed": false
          }, {
            "value": "\"logoBusinessAnalytics\"",
            "computed": false
          }, {
            "value": "\"logoCeph\"",
            "computed": false
          }, {
            "value": "\"logoCloud\"",
            "computed": false
          }, {
            "value": "\"logoCloudEnterprise\"",
            "computed": false
          }, {
            "value": "\"logoCode\"",
            "computed": false
          }, {
            "value": "\"logoCodesandbox\"",
            "computed": false
          }, {
            "value": "\"logoCouchbase\"",
            "computed": false
          }, {
            "value": "\"logoDocker\"",
            "computed": false
          }, {
            "value": "\"logoDropwizard\"",
            "computed": false
          }, {
            "value": "\"logoElastic\"",
            "computed": false
          }, {
            "value": "\"logoElasticsearch\"",
            "computed": false
          }, {
            "value": "\"logoElasticStack\"",
            "computed": false
          }, {
            "value": "\"logoEnterpriseSearch\"",
            "computed": false
          }, {
            "value": "\"logoEtcd\"",
            "computed": false
          }, {
            "value": "\"logoGCP\"",
            "computed": false
          }, {
            "value": "\"logoGCPMono\"",
            "computed": false
          }, {
            "value": "\"logoGithub\"",
            "computed": false
          }, {
            "value": "\"logoGmail\"",
            "computed": false
          }, {
            "value": "\"logoGolang\"",
            "computed": false
          }, {
            "value": "\"logoGoogleG\"",
            "computed": false
          }, {
            "value": "\"logoHAproxy\"",
            "computed": false
          }, {
            "value": "\"logoIBM\"",
            "computed": false
          }, {
            "value": "\"logoIBMMono\"",
            "computed": false
          }, {
            "value": "\"logoKafka\"",
            "computed": false
          }, {
            "value": "\"logoKibana\"",
            "computed": false
          }, {
            "value": "\"logoKubernetes\"",
            "computed": false
          }, {
            "value": "\"logoLogging\"",
            "computed": false
          }, {
            "value": "\"logoLogstash\"",
            "computed": false
          }, {
            "value": "\"logoMaps\"",
            "computed": false
          }, {
            "value": "\"logoMemcached\"",
            "computed": false
          }, {
            "value": "\"logoMetrics\"",
            "computed": false
          }, {
            "value": "\"logoMongodb\"",
            "computed": false
          }, {
            "value": "\"logoMySQL\"",
            "computed": false
          }, {
            "value": "\"logoNginx\"",
            "computed": false
          }, {
            "value": "\"logoObservability\"",
            "computed": false
          }, {
            "value": "\"logoOsquery\"",
            "computed": false
          }, {
            "value": "\"logoPhp\"",
            "computed": false
          }, {
            "value": "\"logoPostgres\"",
            "computed": false
          }, {
            "value": "\"logoPrometheus\"",
            "computed": false
          }, {
            "value": "\"logoRabbitmq\"",
            "computed": false
          }, {
            "value": "\"logoRedis\"",
            "computed": false
          }, {
            "value": "\"logoSecurity\"",
            "computed": false
          }, {
            "value": "\"logoSiteSearch\"",
            "computed": false
          }, {
            "value": "\"logoSketch\"",
            "computed": false
          }, {
            "value": "\"logoSlack\"",
            "computed": false
          }, {
            "value": "\"logoUptime\"",
            "computed": false
          }, {
            "value": "\"logoWebhook\"",
            "computed": false
          }, {
            "value": "\"logoWindows\"",
            "computed": false
          }, {
            "value": "\"logoWorkplaceSearch\"",
            "computed": false
          }, {
            "value": "\"logstashFilter\"",
            "computed": false
          }, {
            "value": "\"logstashIf\"",
            "computed": false
          }, {
            "value": "\"logstashInput\"",
            "computed": false
          }, {
            "value": "\"logstashOutput\"",
            "computed": false
          }, {
            "value": "\"logstashQueue\"",
            "computed": false
          }, {
            "value": "\"machineLearningApp\"",
            "computed": false
          }, {
            "value": "\"magnet\"",
            "computed": false
          }, {
            "value": "\"magnifyWithMinus\"",
            "computed": false
          }, {
            "value": "\"magnifyWithPlus\"",
            "computed": false
          }, {
            "value": "\"managementApp\"",
            "computed": false
          }, {
            "value": "\"mapMarker\"",
            "computed": false
          }, {
            "value": "\"memory\"",
            "computed": false
          }, {
            "value": "\"menu\"",
            "computed": false
          }, {
            "value": "\"menuLeft\"",
            "computed": false
          }, {
            "value": "\"menuRight\"",
            "computed": false
          }, {
            "value": "\"merge\"",
            "computed": false
          }, {
            "value": "\"metricbeatApp\"",
            "computed": false
          }, {
            "value": "\"metricsApp\"",
            "computed": false
          }, {
            "value": "\"minimize\"",
            "computed": false
          }, {
            "value": "\"minusInCircle\"",
            "computed": false
          }, {
            "value": "\"minusInCircleFilled\"",
            "computed": false
          }, {
            "value": "\"monitoringApp\"",
            "computed": false
          }, {
            "value": "\"moon\"",
            "computed": false
          }, {
            "value": "\"nested\"",
            "computed": false
          }, {
            "value": "\"node\"",
            "computed": false
          }, {
            "value": "\"notebookApp\"",
            "computed": false
          }, {
            "value": "\"number\"",
            "computed": false
          }, {
            "value": "\"offline\"",
            "computed": false
          }, {
            "value": "\"online\"",
            "computed": false
          }, {
            "value": "\"package\"",
            "computed": false
          }, {
            "value": "\"packetbeatApp\"",
            "computed": false
          }, {
            "value": "\"pageSelect\"",
            "computed": false
          }, {
            "value": "\"pagesSelect\"",
            "computed": false
          }, {
            "value": "\"partial\"",
            "computed": false
          }, {
            "value": "\"paperClip\"",
            "computed": false
          }, {
            "value": "\"pause\"",
            "computed": false
          }, {
            "value": "\"pencil\"",
            "computed": false
          }, {
            "value": "\"pin\"",
            "computed": false
          }, {
            "value": "\"pinFilled\"",
            "computed": false
          }, {
            "value": "\"pipelineApp\"",
            "computed": false
          }, {
            "value": "\"play\"",
            "computed": false
          }, {
            "value": "\"plusInCircle\"",
            "computed": false
          }, {
            "value": "\"plusInCircleFilled\"",
            "computed": false
          }, {
            "value": "\"popout\"",
            "computed": false
          }, {
            "value": "\"push\"",
            "computed": false
          }, {
            "value": "\"questionInCircle\"",
            "computed": false
          }, {
            "value": "\"quote\"",
            "computed": false
          }, {
            "value": "\"recentlyViewedApp\"",
            "computed": false
          }, {
            "value": "\"refresh\"",
            "computed": false
          }, {
            "value": "\"reporter\"",
            "computed": false
          }, {
            "value": "\"reportingApp\"",
            "computed": false
          }, {
            "value": "\"save\"",
            "computed": false
          }, {
            "value": "\"savedObjectsApp\"",
            "computed": false
          }, {
            "value": "\"scale\"",
            "computed": false
          }, {
            "value": "\"search\"",
            "computed": false
          }, {
            "value": "\"searchProfilerApp\"",
            "computed": false
          }, {
            "value": "\"securityAnalyticsApp\"",
            "computed": false
          }, {
            "value": "\"securityApp\"",
            "computed": false
          }, {
            "value": "\"securitySignal\"",
            "computed": false
          }, {
            "value": "\"securitySignalDetected\"",
            "computed": false
          }, {
            "value": "\"securitySignalResolved\"",
            "computed": false
          }, {
            "value": "\"shard\"",
            "computed": false
          }, {
            "value": "\"share\"",
            "computed": false
          }, {
            "value": "\"snowflake\"",
            "computed": false
          }, {
            "value": "\"sortable\"",
            "computed": false
          }, {
            "value": "\"sortDown\"",
            "computed": false
          }, {
            "value": "\"sortLeft\"",
            "computed": false
          }, {
            "value": "\"sortRight\"",
            "computed": false
          }, {
            "value": "\"sortUp\"",
            "computed": false
          }, {
            "value": "\"spacesApp\"",
            "computed": false
          }, {
            "value": "\"sqlApp\"",
            "computed": false
          }, {
            "value": "\"starEmpty\"",
            "computed": false
          }, {
            "value": "\"starEmptySpace\"",
            "computed": false
          }, {
            "value": "\"starFilled\"",
            "computed": false
          }, {
            "value": "\"starFilledSpace\"",
            "computed": false
          }, {
            "value": "\"starMinusEmpty\"",
            "computed": false
          }, {
            "value": "\"starMinusFilled\"",
            "computed": false
          }, {
            "value": "\"starPlusEmpty\"",
            "computed": false
          }, {
            "value": "\"starPlusFilled\"",
            "computed": false
          }, {
            "value": "\"stats\"",
            "computed": false
          }, {
            "value": "\"stop\"",
            "computed": false
          }, {
            "value": "\"stopFilled\"",
            "computed": false
          }, {
            "value": "\"stopSlash\"",
            "computed": false
          }, {
            "value": "\"storage\"",
            "computed": false
          }, {
            "value": "\"string\"",
            "computed": false
          }, {
            "value": "\"submodule\"",
            "computed": false
          }, {
            "value": "\"swatchInput\"",
            "computed": false
          }, {
            "value": "\"symlink\"",
            "computed": false
          }, {
            "value": "\"tableOfContents\"",
            "computed": false
          }, {
            "value": "\"tableDensityExpanded\"",
            "computed": false
          }, {
            "value": "\"tableDensityCompact\"",
            "computed": false
          }, {
            "value": "\"tableDensityNormal\"",
            "computed": false
          }, {
            "value": "\"tag\"",
            "computed": false
          }, {
            "value": "\"tear\"",
            "computed": false
          }, {
            "value": "\"temperature\"",
            "computed": false
          }, {
            "value": "\"timeline\"",
            "computed": false
          }, {
            "value": "\"timelionApp\"",
            "computed": false
          }, {
            "value": "\"training\"",
            "computed": false
          }, {
            "value": "\"trash\"",
            "computed": false
          }, {
            "value": "\"upgradeAssistantApp\"",
            "computed": false
          }, {
            "value": "\"uptimeApp\"",
            "computed": false
          }, {
            "value": "\"user\"",
            "computed": false
          }, {
            "value": "\"users\"",
            "computed": false
          }, {
            "value": "\"usersRolesApp\"",
            "computed": false
          }, {
            "value": "\"vector\"",
            "computed": false
          }, {
            "value": "\"videoPlayer\"",
            "computed": false
          }, {
            "value": "\"visArea\"",
            "computed": false
          }, {
            "value": "\"visAreaStacked\"",
            "computed": false
          }, {
            "value": "\"visBarHorizontal\"",
            "computed": false
          }, {
            "value": "\"visBarHorizontalStacked\"",
            "computed": false
          }, {
            "value": "\"visBarVertical\"",
            "computed": false
          }, {
            "value": "\"visBarVerticalStacked\"",
            "computed": false
          }, {
            "value": "\"visGauge\"",
            "computed": false
          }, {
            "value": "\"visGoal\"",
            "computed": false
          }, {
            "value": "\"visLine\"",
            "computed": false
          }, {
            "value": "\"visMapCoordinate\"",
            "computed": false
          }, {
            "value": "\"visMapRegion\"",
            "computed": false
          }, {
            "value": "\"visMetric\"",
            "computed": false
          }, {
            "value": "\"visPie\"",
            "computed": false
          }, {
            "value": "\"visTable\"",
            "computed": false
          }, {
            "value": "\"visTagCloud\"",
            "computed": false
          }, {
            "value": "\"visText\"",
            "computed": false
          }, {
            "value": "\"visTimelion\"",
            "computed": false
          }, {
            "value": "\"visualizeApp\"",
            "computed": false
          }, {
            "value": "\"visVega\"",
            "computed": false
          }, {
            "value": "\"visVisualBuilder\"",
            "computed": false
          }, {
            "value": "\"watchesApp\"",
            "computed": false
          }, {
            "value": "\"wrench\"",
            "computed": false
          }, {
            "value": "\"tokenClass\"",
            "computed": false
          }, {
            "value": "\"tokenProperty\"",
            "computed": false
          }, {
            "value": "\"tokenEnum\"",
            "computed": false
          }, {
            "value": "\"tokenVariable\"",
            "computed": false
          }, {
            "value": "\"tokenMethod\"",
            "computed": false
          }, {
            "value": "\"tokenAnnotation\"",
            "computed": false
          }, {
            "value": "\"tokenException\"",
            "computed": false
          }, {
            "value": "\"tokenInterface\"",
            "computed": false
          }, {
            "value": "\"tokenParameter\"",
            "computed": false
          }, {
            "value": "\"tokenField\"",
            "computed": false
          }, {
            "value": "\"tokenElement\"",
            "computed": false
          }, {
            "value": "\"tokenFunction\"",
            "computed": false
          }, {
            "value": "\"tokenBoolean\"",
            "computed": false
          }, {
            "value": "\"tokenString\"",
            "computed": false
          }, {
            "value": "\"tokenArray\"",
            "computed": false
          }, {
            "value": "\"tokenNumber\"",
            "computed": false
          }, {
            "value": "\"tokenConstant\"",
            "computed": false
          }, {
            "value": "\"tokenObject\"",
            "computed": false
          }, {
            "value": "\"tokenEvent\"",
            "computed": false
          }, {
            "value": "\"tokenKey\"",
            "computed": false
          }, {
            "value": "\"tokenNull\"",
            "computed": false
          }, {
            "value": "\"tokenStruct\"",
            "computed": false
          }, {
            "value": "\"tokenPackage\"",
            "computed": false
          }, {
            "value": "\"tokenOperator\"",
            "computed": false
          }, {
            "value": "\"tokenEnumMember\"",
            "computed": false
          }, {
            "value": "\"tokenRepo\"",
            "computed": false
          }, {
            "value": "\"tokenSymbol\"",
            "computed": false
          }, {
            "value": "\"tokenFile\"",
            "computed": false
          }, {
            "value": "\"tokenModule\"",
            "computed": false
          }, {
            "value": "\"tokenNamespace\"",
            "computed": false
          }, {
            "value": "\"tokenDate\"",
            "computed": false
          }, {
            "value": "\"tokenIP\"",
            "computed": false
          }, {
            "value": "\"tokenNested\"",
            "computed": false
          }, {
            "value": "\"tokenAlias\"",
            "computed": false
          }, {
            "value": "\"tokenShape\"",
            "computed": false
          }, {
            "value": "\"tokenGeo\"",
            "computed": false
          }, {
            "value": "\"tokenRange\"",
            "computed": false
          }, {
            "value": "\"tokenBinary\"",
            "computed": false
          }, {
            "value": "\"tokenJoin\"",
            "computed": false
          }, {
            "value": "\"tokenPercolator\"",
            "computed": false
          }, {
            "value": "\"tokenFlattened\"",
            "computed": false
          }, {
            "value": "\"tokenRankFeature\"",
            "computed": false
          }, {
            "value": "\"tokenRankFeatures\"",
            "computed": false
          }, {
            "value": "\"tokenKeyword\"",
            "computed": false
          }, {
            "value": "\"tokenCompletionSuggester\"",
            "computed": false
          }, {
            "value": "\"tokenDenseVector\"",
            "computed": false
          }, {
            "value": "\"tokenText\"",
            "computed": false
          }, {
            "value": "\"tokenTokenCount\"",
            "computed": false
          }, {
            "value": "\"tokenSearchType\"",
            "computed": false
          }, {
            "value": "\"tokenHistogram\"",
            "computed": false
          }]
        }, {
          "name": "string"
        }, {
          "name": "elementType"
        }]
      },
      "required": true,
      "description": "An EUI icon type"
    },
    "color": {
      "type": {
        "name": "union",
        "value": [{
          "name": "enum",
          "value": [{
            "value": "\"euiColorVis0\"",
            "computed": false
          }, {
            "value": "\"euiColorVis1\"",
            "computed": false
          }, {
            "value": "\"euiColorVis2\"",
            "computed": false
          }, {
            "value": "\"euiColorVis3\"",
            "computed": false
          }, {
            "value": "\"euiColorVis4\"",
            "computed": false
          }, {
            "value": "\"euiColorVis5\"",
            "computed": false
          }, {
            "value": "\"euiColorVis6\"",
            "computed": false
          }, {
            "value": "\"euiColorVis7\"",
            "computed": false
          }, {
            "value": "\"euiColorVis8\"",
            "computed": false
          }, {
            "value": "\"euiColorVis9\"",
            "computed": false
          }, {
            "value": "\"gray\"",
            "computed": false
          }]
        }, {
          "name": "string"
        }]
      },
      "required": false,
      "description": "For best results use one of the vis color names (or 'gray').\nOr supply your own color (can be used with dark or no fill only).\nDefault: `gray`"
    },
    "shape": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"circle\"",
          "computed": false
        }, {
          "value": "\"square\"",
          "computed": false
        }, {
          "value": "\"rectangle\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "Outer shape surrounding the icon\nDefault: `circle`"
    },
    "fill": {
      "type": {
        "name": "enum",
        "value": [{
          "value": "\"dark\"",
          "computed": false
        }, {
          "value": "\"light\"",
          "computed": false
        }, {
          "value": "\"none\"",
          "computed": false
        }]
      },
      "required": false,
      "description": "`light` for lightened color with border, `dark` for solid, or `none`\nDefault: `light`"
    },
    "title": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": "The icon's title. Required for accessibility"
    },
    "aria-labelledby": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-describedby": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};