"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAspectRatio = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiAspectRatio = function EuiAspectRatio(_ref) {
  var children = _ref.children,
      className = _ref.className,
      height = _ref.height,
      width = _ref.width,
      maxWidth = _ref.maxWidth,
      rest = (0, _objectWithoutProperties2.default)(_ref, ["children", "className", "height", "width", "maxWidth"]);
  var classes = (0, _classnames.default)('euiAspectRatio', className);
  var paddingBottom = "".concat(height / width * 100, "%");

  var content = _react.default.createElement("div", (0, _extends2.default)({
    className: classes
  }, rest, {
    style: {
      paddingBottom: paddingBottom,
      maxWidth: maxWidth ? maxWidth : 'auto'
    }
  }), children);

  var contentwithoptionalwrap = content;

  if (maxWidth) {
    contentwithoptionalwrap = _react.default.createElement("div", {
      style: {
        maxWidth: maxWidth
      }
    }, content);
  }

  return contentwithoptionalwrap;
};

exports.EuiAspectRatio = EuiAspectRatio;
EuiAspectRatio.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string,

  /**
       * Aspect ratio height. For example 9 would be widescreen video.
       */
  height: _propTypes.default.number.isRequired,

  /**
       * Aspect ratio width. For example 16 would be widescreen video.
       */
  width: _propTypes.default.number.isRequired,

  /**
       * The maximum width you want the child to stretch to.
       */
  maxWidth: _propTypes.default.number
};
EuiAspectRatio.__docgenInfo = {
  "description": "",
  "methods": [],
  "displayName": "EuiAspectRatio",
  "props": {
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "height": {
      "type": {
        "name": "number"
      },
      "required": true,
      "description": "Aspect ratio height. For example 9 would be widescreen video."
    },
    "width": {
      "type": {
        "name": "number"
      },
      "required": true,
      "description": "Aspect ratio width. For example 16 would be widescreen video."
    },
    "maxWidth": {
      "type": {
        "name": "number"
      },
      "required": false,
      "description": "The maximum width you want the child to stretch to."
    }
  }
};