"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHeaderLinks = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf3 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _icon = require("../../icon");

var _popover = require("../../popover");

var _i18n = require("../../i18n");

var _header_section = require("../header_section");

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
var EuiHeaderLinks =
/*#__PURE__*/
function (_Component) {
  (0, _inherits2.default)(EuiHeaderLinks, _Component);

  function EuiHeaderLinks() {
    var _getPrototypeOf2;

    var _this;

    (0, _classCallCheck2.default)(this, EuiHeaderLinks);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = (0, _possibleConstructorReturn2.default)(this, (_getPrototypeOf2 = (0, _getPrototypeOf3.default)(EuiHeaderLinks)).call.apply(_getPrototypeOf2, [this].concat(args)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      isOpen: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "onMenuButtonClick", function () {
      _this.setState({
        isOpen: !_this.state.isOpen
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "closeMenu", function () {
      _this.setState({
        isOpen: false
      });
    });
    return _this;
  }

  (0, _createClass2.default)(EuiHeaderLinks, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      window.addEventListener('resize', this.closeMenu);
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      window.removeEventListener('resize', this.closeMenu);
    }
  }, {
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          rest = (0, _objectWithoutProperties2.default)(_this$props, ["children", "className"]);
      var classes = (0, _classnames.default)('euiHeaderLinks', className);

      var button = _react.default.createElement(_i18n.EuiI18n, {
        token: "euiHeaderLinks.openNavigationMenu",
        default: "Open navigation menu"
      }, function (openNavigationMenu) {
        return _react.default.createElement(_header_section.EuiHeaderSectionItemButton, {
          "aria-label": openNavigationMenu,
          onClick: _this2.onMenuButtonClick
        }, _react.default.createElement(_icon.EuiIcon, {
          type: "apps",
          size: "m"
        }));
      });

      return _react.default.createElement(_i18n.EuiI18n, {
        token: "euiHeaderLinks.appNavigation",
        default: "App navigation"
      }, function (appNavigation) {
        return _react.default.createElement("nav", (0, _extends2.default)({
          className: classes,
          "aria-label": appNavigation
        }, rest), _react.default.createElement("div", {
          className: "euiHeaderLinks__list"
        }, children), _react.default.createElement(_popover.EuiPopover, {
          className: "euiHeaderLinks__mobile",
          ownFocus: true,
          button: button,
          isOpen: _this2.state.isOpen,
          anchorPosition: "downRight",
          closePopover: _this2.closeMenu,
          panelClassName: "euiHeaderLinks__mobileList",
          panelPaddingSize: "none"
        }, children));
      });
    }
  }]);
  return EuiHeaderLinks;
}(_react.Component);

exports.EuiHeaderLinks = EuiHeaderLinks;
EuiHeaderLinks.propTypes = {
  className: _propTypes.default.string,
  "aria-label": _propTypes.default.string,
  "data-test-subj": _propTypes.default.string
};
EuiHeaderLinks.__docgenInfo = {
  "description": "",
  "methods": [{
    "name": "onMenuButtonClick",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }, {
    "name": "closeMenu",
    "docblock": null,
    "modifiers": [],
    "params": [],
    "returns": null
  }],
  "displayName": "EuiHeaderLinks",
  "props": {
    "className": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "aria-label": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    },
    "data-test-subj": {
      "type": {
        "name": "string"
      },
      "required": false,
      "description": ""
    }
  }
};