"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.readRcFile = readRcFile;
exports.parseTelemetryRC = parseTelemetryRC;

var path = _interopRequireWildcard(require("path"));

var _utils = require("./utils");

var _constants = require("./constants");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
async function readRcFile(rcRoot) {
  if (!path.isAbsolute(rcRoot)) {
    throw Error(`config root (${rcRoot}) must be an absolute path.`);
  }

  const rcFile = path.resolve(rcRoot, _constants.TELEMETRY_RC);
  const configString = await (0, _utils.readFileAsync)(rcFile, 'utf8');
  return JSON.parse(configString);
}

async function parseTelemetryRC(rcRoot) {
  const parsedRc = await readRcFile(rcRoot);
  const configs = Array.isArray(parsedRc) ? parsedRc : [parsedRc];
  return configs.map(({
    root,
    output,
    exclude = []
  }) => {
    if (typeof root !== 'string') {
      throw Error('config.root must be a string.');
    }

    if (typeof output !== 'string') {
      throw Error('config.output must be a string.');
    }

    if (!Array.isArray(exclude)) {
      throw Error('config.exclude must be an array of strings.');
    }

    return {
      root: path.join(rcRoot, root),
      output: path.join(rcRoot, output),
      exclude: exclude.map(excludedPath => path.resolve(rcRoot, excludedPath))
    };
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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