"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getProgramPaths = getProgramPaths;
exports.extractCollectors = extractCollectors;

var ts = _interopRequireWildcard(require("typescript"));

var path = _interopRequireWildcard(require("path"));

var _ts_parser = require("./ts_parser");

var _utils = require("./utils");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
async function getProgramPaths({
  root,
  exclude
}) {
  const filePaths = await (0, _utils.globAsync)('**/*.ts', {
    cwd: root,
    ignore: ['**/node_modules/**', '**/*.test.*', '**/*.mock.*', '**/mocks.*', '**/__fixture__/**', '**/__tests__/**', '**/public/**', '**/dist/**', '**/target/**', '**/*.d.ts']
  });

  if (filePaths.length === 0) {
    throw Error(`No files found in ${root}`);
  }

  const fullPaths = filePaths.map(filePath => path.join(root, filePath)).filter(fullPath => !exclude.some(excludedPath => fullPath.startsWith(excludedPath)));

  if (fullPaths.length === 0) {
    throw Error(`No paths covered from ${root} by the .telemetryrc.json`);
  }

  return fullPaths;
}

function* extractCollectors(fullPaths, tsConfig) {
  const program = ts.createProgram(fullPaths, tsConfig);
  program.getTypeChecker();
  const sourceFiles = fullPaths.map(fullPath => {
    const sourceFile = program.getSourceFile(fullPath);

    if (!sourceFile) {
      throw Error(`Unable to get sourceFile ${fullPath}.`);
    }

    return sourceFile;
  });

  for (const sourceFile of sourceFiles) {
    yield* (0, _ts_parser.parseUsageCollection)(sourceFile, program);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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