function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
import { KuiButtonIcon } from './button_icon/button_icon';

var accessibleIconButton = function accessibleIconButton(props, propName, componentName) {
  if (props.children) {
    return;
  }

  if (props['aria-label']) {
    return;
  }

  if (props['aria-labelledby']) {
    return;
  }

  throw new Error("".concat(componentName, " requires aria-label or aria-labelledby to be specified if it does not have children. ") + "This is because we're assuming you're creating an icon-only button, which is screen-reader-inaccessible.");
};

var BUTTON_TYPES = ['basic', 'hollow', 'danger', 'warning', 'primary', 'secondary'];
var ICON_POSITIONS = ['left', 'right'];
var DEFAULT_ICON_POSITION = 'left';
var buttonTypeToClassNameMap = {
  basic: 'kuiButton--basic',
  hollow: 'kuiButton--hollow',
  danger: 'kuiButton--danger',
  warning: 'kuiButton--warning',
  primary: 'kuiButton--primary',
  secondary: 'kuiButton--secondary'
};

var getClassName = function getClassName(_ref) {
  var className = _ref.className,
      buttonType = _ref.buttonType,
      _ref$hasIcon = _ref.hasIcon,
      hasIcon = _ref$hasIcon === void 0 ? false : _ref$hasIcon;
  return classNames('kuiButton', className, buttonTypeToClassNameMap[buttonType], {
    'kuiButton--iconText': hasIcon
  });
};

var ContentWithIcon = function ContentWithIcon(_ref2) {
  var children = _ref2.children,
      icon = _ref2.icon,
      iconPosition = _ref2.iconPosition,
      isLoading = _ref2.isLoading;
  var iconOrLoading = isLoading ? /*#__PURE__*/React.createElement(KuiButtonIcon, {
    type: "loading"
  }) : icon; // We need to wrap the children so that the icon's :first-child etc. pseudo-selectors get applied
  // correctly.

  var wrappedChildren = children ? /*#__PURE__*/React.createElement("span", null, children) : undefined;

  switch (iconPosition) {
    case 'left':
      return /*#__PURE__*/React.createElement("span", {
        className: "kuiButton__inner"
      }, iconOrLoading, wrappedChildren);

    case 'right':
      return /*#__PURE__*/React.createElement("span", {
        className: "kuiButton__inner"
      }, wrappedChildren, iconOrLoading);
  }
};

var KuiButton = function KuiButton(_ref3) {
  var isLoading = _ref3.isLoading,
      _ref3$iconPosition = _ref3.iconPosition,
      iconPosition = _ref3$iconPosition === void 0 ? DEFAULT_ICON_POSITION : _ref3$iconPosition,
      className = _ref3.className,
      buttonType = _ref3.buttonType,
      icon = _ref3.icon,
      children = _ref3.children,
      rest = _objectWithoutProperties(_ref3, ["isLoading", "iconPosition", "className", "buttonType", "icon", "children"]);

  return /*#__PURE__*/React.createElement("button", _extends({
    className: getClassName({
      className: className,
      buttonType: buttonType,
      hasIcon: icon || isLoading
    })
  }, rest), /*#__PURE__*/React.createElement(ContentWithIcon, {
    icon: icon,
    iconPosition: iconPosition,
    isLoading: isLoading
  }, children));
};

KuiButton.propTypes = {
  icon: PropTypes.node,
  iconPosition: PropTypes.oneOf(ICON_POSITIONS),
  children: PropTypes.node,
  isLoading: PropTypes.bool,
  buttonType: PropTypes.oneOf(BUTTON_TYPES),
  className: PropTypes.string,
  'aria-label': accessibleIconButton
};

var KuiLinkButton = function KuiLinkButton(_ref4) {
  var isLoading = _ref4.isLoading,
      icon = _ref4.icon,
      _ref4$iconPosition = _ref4.iconPosition,
      iconPosition = _ref4$iconPosition === void 0 ? DEFAULT_ICON_POSITION : _ref4$iconPosition,
      className = _ref4.className,
      disabled = _ref4.disabled,
      buttonType = _ref4.buttonType,
      children = _ref4.children,
      rest = _objectWithoutProperties(_ref4, ["isLoading", "icon", "iconPosition", "className", "disabled", "buttonType", "children"]);

  var onClick = function onClick(e) {
    if (disabled) {
      e.preventDefault();
    }
  };

  var classes = classNames(getClassName({
    className: className,
    buttonType: buttonType,
    hasIcon: icon || isLoading
  }), {
    'kuiButton-isDisabled': disabled
  });
  return /*#__PURE__*/React.createElement("a", _extends({
    className: classes,
    onClick: onClick
  }, rest), /*#__PURE__*/React.createElement(ContentWithIcon, {
    icon: icon,
    iconPosition: iconPosition,
    isLoading: isLoading
  }, children));
};

KuiLinkButton.propTypes = {
  icon: PropTypes.node,
  iconPosition: PropTypes.oneOf(ICON_POSITIONS),
  isLoading: PropTypes.bool,
  buttonType: PropTypes.oneOf(BUTTON_TYPES),
  className: PropTypes.string,
  children: PropTypes.node,
  'aria-label': accessibleIconButton
};

var KuiSubmitButton = function KuiSubmitButton(_ref5) {
  var className = _ref5.className,
      buttonType = _ref5.buttonType,
      children = _ref5.children,
      rest = _objectWithoutProperties(_ref5, ["className", "buttonType", "children"]);

  // NOTE: The `input` element is a void element and can't contain children.
  return /*#__PURE__*/React.createElement("input", _extends({
    type: "submit",
    value: children,
    className: getClassName({
      className: className,
      buttonType: buttonType
    })
  }, rest));
};

KuiSubmitButton.propTypes = {
  children: PropTypes.string,
  buttonType: PropTypes.oneOf(BUTTON_TYPES),
  className: PropTypes.string
};
export { BUTTON_TYPES, KuiButton, KuiLinkButton, KuiSubmitButton };
