"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _postcss = require("postcss");

var _postcss2 = _interopRequireDefault(_postcss);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const createImports = imports => {
  return Object.keys(imports).map(path => {
    const aliases = imports[path];
    const declarations = Object.keys(aliases).map(key => _postcss2.default.decl({
      prop: key,
      value: aliases[key],
      raws: { before: "\n  " }
    }));
    return _postcss2.default.rule({
      selector: `:import('${path}')`,
      raws: { after: "\n" }
    }).append(declarations);
  });
};

const createExports = exports => {
  const declarations = Object.keys(exports).map(key => _postcss2.default.decl({
    prop: key,
    value: exports[key],
    raws: { before: "\n  " }
  }));
  if (declarations.length === 0) {
    return [];
  }
  const rule = _postcss2.default.rule({
    selector: `:export`,
    raws: { after: "\n" }
  }).append(declarations);
  return [rule];
};

const createICSSRules = (imports, exports) => [...createImports(imports), ...createExports(exports)];

exports.default = createICSSRules;