function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { BehaviorSubject, Subject } from 'rxjs';
import { map, shareReplay, takeUntil, distinctUntilChanged, filter } from 'rxjs/operators';
import { createBrowserHistory } from 'history';
import { AppRouter } from './ui';
import { CapabilitiesService } from './capabilities';
import { AppNavLinkStatus, AppStatus } from './types';
import { getLeaveAction, isConfirmAction } from './application_leave';
import { appendAppPath, parseAppUrl, relativeToAbsolute, getAppInfo } from './utils';

// Mount functions with two arguments are assumed to expect deprecated `context` object.
var isAppMountDeprecated = function isAppMountDeprecated(mount) {
  return mount.length === 2;
};

function filterAvailable(m, capabilities) {
  return new Map(_toConsumableArray(m).filter(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
        id = _ref2[0];

    return capabilities.navLinks[id] === undefined || capabilities.navLinks[id] === true;
  }));
}

var findMounter = function findMounter(mounters, appRoute) {
  return _toConsumableArray(mounters).find(function (_ref3) {
    var _ref4 = _slicedToArray(_ref3, 2),
        mounter = _ref4[1];

    return mounter.appRoute === appRoute;
  });
};

var getAppUrl = function getAppUrl(mounters, appId) {
  var _mounters$get;

  var path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '';
  var appBasePath = ((_mounters$get = mounters.get(appId)) === null || _mounters$get === void 0 ? void 0 : _mounters$get.appRoute) ? "/".concat(mounters.get(appId).appRoute) : "/app/".concat(appId);
  return appendAppPath(appBasePath, path);
};

var allApplicationsFilter = '__ALL__';

/**
 * Service that is responsible for registering new applications.
 * @internal
 */
export var ApplicationService = /*#__PURE__*/function () {
  function ApplicationService() {
    var _this = this;

    _classCallCheck(this, ApplicationService);

    _defineProperty(this, "apps", new Map());

    _defineProperty(this, "mounters", new Map());

    _defineProperty(this, "capabilities", new CapabilitiesService());

    _defineProperty(this, "appLeaveHandlers", new Map());

    _defineProperty(this, "currentAppId$", new BehaviorSubject(undefined));

    _defineProperty(this, "statusUpdaters$", new BehaviorSubject(new Map()));

    _defineProperty(this, "subscriptions", []);

    _defineProperty(this, "stop$", new Subject());

    _defineProperty(this, "registrationClosed", false);

    _defineProperty(this, "history", void 0);

    _defineProperty(this, "mountContext", void 0);

    _defineProperty(this, "navigate", void 0);

    _defineProperty(this, "redirectTo", void 0);

    _defineProperty(this, "setAppLeaveHandler", function (appId, handler) {
      _this.appLeaveHandlers.set(appId, handler);
    });

    _defineProperty(this, "onBeforeUnload", function (event) {
      var currentAppId = _this.currentAppId$.value;

      if (currentAppId === undefined) {
        return;
      }

      var action = getLeaveAction(_this.appLeaveHandlers.get(currentAppId));

      if (isConfirmAction(action)) {
        event.preventDefault(); // some browsers accept a string return value being the message displayed

        event.returnValue = action.text;
      }
    });
  }

  _createClass(ApplicationService, [{
    key: "setup",
    value: function setup(_ref5) {
      var _this2 = this;

      var context = _ref5.context,
          basePath = _ref5.http.basePath,
          injectedMetadata = _ref5.injectedMetadata,
          _ref5$redirectTo = _ref5.redirectTo,
          redirectTo = _ref5$redirectTo === void 0 ? function (path) {
        window.location.assign(path);
      } : _ref5$redirectTo,
          history = _ref5.history;
      var basename = basePath.get();

      if (injectedMetadata.getLegacyMode()) {
        this.currentAppId$.next(injectedMetadata.getLegacyMetadata().app.id);
      } else {
        // Only setup history if we're not in legacy mode
        this.history = history || createBrowserHistory({
          basename: basename
        });
      }

      this.navigate = function (url, state, replace) {
        if (_this2.history) {
          // basePath not needed here because `history` is configured with basename
          return replace ? _this2.history.replace(url, state) : _this2.history.push(url, state);
        } else {
          // If we do not have history available (legacy mode), use redirectTo to do a full page refresh.
          return redirectTo(basePath.prepend(url));
        }
      };

      this.redirectTo = redirectTo;
      this.mountContext = context.createContextContainer();

      var registerStatusUpdater = function registerStatusUpdater(application, updater$) {
        var updaterId = Symbol();
        var subscription = updater$.subscribe(function (updater) {
          var nextValue = new Map(_this2.statusUpdaters$.getValue());
          nextValue.set(updaterId, {
            application: application,
            updater: updater
          });

          _this2.statusUpdaters$.next(nextValue);
        });

        _this2.subscriptions.push(subscription);
      };

      var wrapMount = function wrapMount(plugin, app) {
        var handler;

        if (isAppMountDeprecated(app.mount)) {
          handler = _this2.mountContext.createHandler(plugin, app.mount);

          if (process.env.NODE_ENV === 'development') {
            // eslint-disable-next-line no-console
            console.warn("App [".concat(app.id, "] is using deprecated mount context. Use core.getStartServices() instead."));
          }
        } else {
          handler = app.mount;
        }

        return /*#__PURE__*/function () {
          var _ref6 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(params) {
            return regeneratorRuntime.wrap(function _callee$(_context) {
              while (1) {
                switch (_context.prev = _context.next) {
                  case 0:
                    _this2.currentAppId$.next(app.id);

                    return _context.abrupt("return", handler(params));

                  case 2:
                  case "end":
                    return _context.stop();
                }
              }
            }, _callee);
          }));

          return function (_x) {
            return _ref6.apply(this, arguments);
          };
        }();
      };

      return {
        registerMountContext: this.mountContext.registerContext,
        register: function register(plugin, app) {
          var _app$status, _app$navLinkStatus, _app$exactRoute;

          app = _objectSpread({
            appRoute: "/app/".concat(app.id)
          }, app);

          if (_this2.registrationClosed) {
            throw new Error("Applications cannot be registered after \"setup\"");
          } else if (_this2.apps.has(app.id)) {
            throw new Error("An application is already registered with the id \"".concat(app.id, "\""));
          } else if (findMounter(_this2.mounters, app.appRoute)) {
            throw new Error("An application is already registered with the appRoute \"".concat(app.appRoute, "\""));
          } else if (basename && app.appRoute.startsWith("".concat(basename, "/"))) {
            throw new Error('Cannot register an application route that includes HTTP base path');
          }

          var _app = app,
              updater$ = _app.updater$,
              appProps = _objectWithoutProperties(_app, ["updater$"]);

          _this2.apps.set(app.id, _objectSpread(_objectSpread({}, appProps), {}, {
            status: (_app$status = app.status) !== null && _app$status !== void 0 ? _app$status : AppStatus.accessible,
            navLinkStatus: (_app$navLinkStatus = app.navLinkStatus) !== null && _app$navLinkStatus !== void 0 ? _app$navLinkStatus : AppNavLinkStatus.default,
            legacy: false
          }));

          if (updater$) {
            registerStatusUpdater(app.id, updater$);
          }

          _this2.mounters.set(app.id, {
            appRoute: app.appRoute,
            appBasePath: basePath.prepend(app.appRoute),
            exactRoute: (_app$exactRoute = app.exactRoute) !== null && _app$exactRoute !== void 0 ? _app$exactRoute : false,
            mount: wrapMount(plugin, app),
            unmountBeforeMounting: false,
            legacy: false
          });
        },
        registerLegacyApp: function registerLegacyApp(app) {
          var _app$status2, _app$navLinkStatus2;

          var appRoute = "/app/".concat(app.id.split(':')[0]);

          if (_this2.registrationClosed) {
            throw new Error('Applications cannot be registered after "setup"');
          } else if (_this2.apps.has(app.id)) {
            throw new Error("An application is already registered with the id \"".concat(app.id, "\""));
          } else if (basename && appRoute.startsWith("".concat(basename, "/"))) {
            throw new Error('Cannot register an application route that includes HTTP base path');
          }

          var appBasePath = basePath.prepend(appRoute);

          var mount = function mount(_ref7) {
            var appHistory = _ref7.history;
            redirectTo(appHistory.createHref(appHistory.location));
            window.location.reload();
          };

          var updater$ = app.updater$,
              appProps = _objectWithoutProperties(app, ["updater$"]);

          _this2.apps.set(app.id, _objectSpread(_objectSpread({}, appProps), {}, {
            status: (_app$status2 = app.status) !== null && _app$status2 !== void 0 ? _app$status2 : AppStatus.accessible,
            navLinkStatus: (_app$navLinkStatus2 = app.navLinkStatus) !== null && _app$navLinkStatus2 !== void 0 ? _app$navLinkStatus2 : AppNavLinkStatus.default,
            legacy: true
          }));

          if (updater$) {
            registerStatusUpdater(app.id, updater$);
          }

          _this2.mounters.set(app.id, {
            appRoute: appRoute,
            appBasePath: appBasePath,
            exactRoute: false,
            mount: mount,
            unmountBeforeMounting: true,
            legacy: true
          });
        },
        registerAppUpdater: function registerAppUpdater(appUpdater$) {
          return registerStatusUpdater(allApplicationsFilter, appUpdater$);
        }
      };
    }
  }, {
    key: "start",
    value: function () {
      var _start = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee4(_ref8) {
        var _this3 = this;

        var http, overlays, httpLoadingCount$, _yield$this$capabilit, capabilities, availableMounters, availableApps, applications$, applicationStatuses$, navigateToApp;

        return regeneratorRuntime.wrap(function _callee4$(_context4) {
          while (1) {
            switch (_context4.prev = _context4.next) {
              case 0:
                http = _ref8.http, overlays = _ref8.overlays;

                if (this.mountContext) {
                  _context4.next = 3;
                  break;
                }

                throw new Error('ApplicationService#setup() must be invoked before start.');

              case 3:
                httpLoadingCount$ = new BehaviorSubject(0);
                http.addLoadingCountSource(httpLoadingCount$);
                this.registrationClosed = true;
                window.addEventListener('beforeunload', this.onBeforeUnload);
                _context4.next = 9;
                return this.capabilities.start({
                  appIds: _toConsumableArray(this.mounters.keys()),
                  http: http
                });

              case 9:
                _yield$this$capabilit = _context4.sent;
                capabilities = _yield$this$capabilit.capabilities;
                availableMounters = filterAvailable(this.mounters, capabilities);
                availableApps = filterAvailable(this.apps, capabilities);
                applications$ = new BehaviorSubject(availableApps);
                this.statusUpdaters$.pipe(map(function (statusUpdaters) {
                  return new Map(_toConsumableArray(availableApps).map(function (_ref9) {
                    var _ref10 = _slicedToArray(_ref9, 2),
                        id = _ref10[0],
                        app = _ref10[1];

                    return [id, updateStatus(app, _toConsumableArray(statusUpdaters.values()))];
                  }));
                })).subscribe(function (apps) {
                  return applications$.next(apps);
                });
                applicationStatuses$ = applications$.pipe(map(function (apps) {
                  return new Map(_toConsumableArray(apps.entries()).map(function (_ref11) {
                    var _ref12 = _slicedToArray(_ref11, 2),
                        id = _ref12[0],
                        app = _ref12[1];

                    return [id, app.status];
                  }));
                }), shareReplay(1));

                navigateToApp = /*#__PURE__*/function () {
                  var _ref13 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(appId) {
                    var _ref14,
                        path,
                        state,
                        _ref14$replace,
                        replace,
                        _applications$$value$,
                        _args2 = arguments;

                    return regeneratorRuntime.wrap(function _callee2$(_context2) {
                      while (1) {
                        switch (_context2.prev = _context2.next) {
                          case 0:
                            _ref14 = _args2.length > 1 && _args2[1] !== undefined ? _args2[1] : {}, path = _ref14.path, state = _ref14.state, _ref14$replace = _ref14.replace, replace = _ref14$replace === void 0 ? false : _ref14$replace;
                            _context2.next = 3;
                            return _this3.shouldNavigate(overlays);

                          case 3:
                            if (!_context2.sent) {
                              _context2.next = 8;
                              break;
                            }

                            if (path === undefined) {
                              path = (_applications$$value$ = applications$.value.get(appId)) === null || _applications$$value$ === void 0 ? void 0 : _applications$$value$.defaultPath;
                            }

                            _this3.appLeaveHandlers.delete(_this3.currentAppId$.value);

                            _this3.navigate(getAppUrl(availableMounters, appId, path), state, replace);

                            _this3.currentAppId$.next(appId);

                          case 8:
                          case "end":
                            return _context2.stop();
                        }
                      }
                    }, _callee2);
                  }));

                  return function navigateToApp(_x3) {
                    return _ref13.apply(this, arguments);
                  };
                }();

                return _context4.abrupt("return", {
                  applications$: applications$.pipe(map(function (apps) {
                    return new Map(_toConsumableArray(apps.entries()).map(function (_ref15) {
                      var _ref16 = _slicedToArray(_ref15, 2),
                          id = _ref16[0],
                          app = _ref16[1];

                      return [id, getAppInfo(app)];
                    }));
                  }), shareReplay(1)),
                  capabilities: capabilities,
                  currentAppId$: this.currentAppId$.pipe(filter(function (appId) {
                    return appId !== undefined;
                  }), distinctUntilChanged(), takeUntil(this.stop$)),
                  history: this.history,
                  registerMountContext: this.mountContext.registerContext,
                  getUrlForApp: function getUrlForApp(appId) {
                    var _ref17 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
                        path = _ref17.path,
                        _ref17$absolute = _ref17.absolute,
                        absolute = _ref17$absolute === void 0 ? false : _ref17$absolute;

                    var relUrl = http.basePath.prepend(getAppUrl(availableMounters, appId, path));
                    return absolute ? relativeToAbsolute(relUrl) : relUrl;
                  },
                  navigateToApp: navigateToApp,
                  navigateToUrl: function () {
                    var _navigateToUrl = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3(url) {
                      var appInfo;
                      return regeneratorRuntime.wrap(function _callee3$(_context3) {
                        while (1) {
                          switch (_context3.prev = _context3.next) {
                            case 0:
                              appInfo = parseAppUrl(url, http.basePath, _this3.apps);

                              if (!appInfo) {
                                _context3.next = 5;
                                break;
                              }

                              return _context3.abrupt("return", navigateToApp(appInfo.app, {
                                path: appInfo.path
                              }));

                            case 5:
                              return _context3.abrupt("return", _this3.redirectTo(url));

                            case 6:
                            case "end":
                              return _context3.stop();
                          }
                        }
                      }, _callee3);
                    }));

                    function navigateToUrl(_x4) {
                      return _navigateToUrl.apply(this, arguments);
                    }

                    return navigateToUrl;
                  }(),
                  getComponent: function getComponent() {
                    if (!_this3.history) {
                      return null;
                    }

                    return /*#__PURE__*/React.createElement(AppRouter, {
                      history: _this3.history,
                      mounters: availableMounters,
                      appStatuses$: applicationStatuses$,
                      setAppLeaveHandler: _this3.setAppLeaveHandler,
                      setIsMounting: function setIsMounting(isMounting) {
                        return httpLoadingCount$.next(isMounting ? 1 : 0);
                      }
                    });
                  }
                });

              case 18:
              case "end":
                return _context4.stop();
            }
          }
        }, _callee4, this);
      }));

      function start(_x2) {
        return _start.apply(this, arguments);
      }

      return start;
    }()
  }, {
    key: "shouldNavigate",
    value: function () {
      var _shouldNavigate = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee5(overlays) {
        var currentAppId, action, confirmed;
        return regeneratorRuntime.wrap(function _callee5$(_context5) {
          while (1) {
            switch (_context5.prev = _context5.next) {
              case 0:
                currentAppId = this.currentAppId$.value;

                if (!(currentAppId === undefined)) {
                  _context5.next = 3;
                  break;
                }

                return _context5.abrupt("return", true);

              case 3:
                action = getLeaveAction(this.appLeaveHandlers.get(currentAppId));

                if (!isConfirmAction(action)) {
                  _context5.next = 10;
                  break;
                }

                _context5.next = 7;
                return overlays.openConfirm(action.text, {
                  title: action.title,
                  'data-test-subj': 'appLeaveConfirmModal'
                });

              case 7:
                confirmed = _context5.sent;

                if (confirmed) {
                  _context5.next = 10;
                  break;
                }

                return _context5.abrupt("return", false);

              case 10:
                return _context5.abrupt("return", true);

              case 11:
              case "end":
                return _context5.stop();
            }
          }
        }, _callee5, this);
      }));

      function shouldNavigate(_x5) {
        return _shouldNavigate.apply(this, arguments);
      }

      return shouldNavigate;
    }()
  }, {
    key: "stop",
    value: function stop() {
      this.stop$.next();
      this.currentAppId$.complete();
      this.statusUpdaters$.complete();
      this.subscriptions.forEach(function (sub) {
        return sub.unsubscribe();
      });
      window.removeEventListener('beforeunload', this.onBeforeUnload);
    }
  }]);

  return ApplicationService;
}();

var updateStatus = function updateStatus(app, statusUpdaters) {
  var changes = {};
  statusUpdaters.forEach(function (wrapper) {
    if (wrapper.application !== allApplicationsFilter && wrapper.application !== app.id) {
      return;
    }

    var fields = wrapper.updater(app);

    if (fields) {
      var _changes$status, _fields$status, _changes$navLinkStatu, _fields$navLinkStatus;

      changes = _objectSpread(_objectSpread(_objectSpread({}, changes), fields), {}, {
        // status and navLinkStatus enums are ordered by reversed priority
        // if multiple updaters wants to change these fields, we will always follow the priority order.
        status: Math.max((_changes$status = changes.status) !== null && _changes$status !== void 0 ? _changes$status : 0, (_fields$status = fields.status) !== null && _fields$status !== void 0 ? _fields$status : 0),
        navLinkStatus: Math.max((_changes$navLinkStatu = changes.navLinkStatus) !== null && _changes$navLinkStatu !== void 0 ? _changes$navLinkStatu : 0, (_fields$navLinkStatus = fields.navLinkStatus) !== null && _fields$navLinkStatus !== void 0 ? _fields$navLinkStatus : 0)
      });
    }
  });
  return _objectSpread(_objectSpread({}, app), changes);
};