/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import ReactDOM from 'react-dom';
import { EuiButton, EuiCallOut, EuiCodeBlock, EuiModalBody, EuiModalFooter, EuiModalHeader, EuiModalHeaderTitle } from '@elastic/eui';
import { EuiSpacer } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';

var isRequestError = function isRequestError(e) {
  if ('body' in e) {
    var _e$body, _e$body$attributes, _e$body$attributes$er;

    return ((_e$body = e.body) === null || _e$body === void 0 ? void 0 : (_e$body$attributes = _e$body.attributes) === null || _e$body$attributes === void 0 ? void 0 : (_e$body$attributes$er = _e$body$attributes.error) === null || _e$body$attributes$er === void 0 ? void 0 : _e$body$attributes$er.caused_by) !== undefined;
  }

  return false;
};
/**
 * This should instead be replaced by the overlay service once it's available.
 * This does not use React portals so that if the parent toast times out, this modal
 * does not disappear. NOTE: this should use a global modal in the overlay service
 * in the future.
 */


function showErrorDialog(_ref) {
  var title = _ref.title,
      error = _ref.error,
      openModal = _ref.openModal,
      i18nContext = _ref.i18nContext;
  var I18nContext = i18nContext();
  var text = '';

  if (isRequestError(error)) {
    var _error$body, _error$body$attribute, _error$body$attribute2, _error$body2, _error$body2$attribut, _error$body2$attribut2;

    text += "".concat(error === null || error === void 0 ? void 0 : (_error$body = error.body) === null || _error$body === void 0 ? void 0 : (_error$body$attribute = _error$body.attributes) === null || _error$body$attribute === void 0 ? void 0 : (_error$body$attribute2 = _error$body$attribute.error) === null || _error$body$attribute2 === void 0 ? void 0 : _error$body$attribute2.caused_by.type, "\n");
    text += "".concat(error === null || error === void 0 ? void 0 : (_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : (_error$body2$attribut = _error$body2.attributes) === null || _error$body2$attribut === void 0 ? void 0 : (_error$body2$attribut2 = _error$body2$attribut.error) === null || _error$body2$attribut2 === void 0 ? void 0 : _error$body2$attribut2.caused_by.reason, "\n\n");
  }

  if (error.stack) {
    text += error.stack;
  }

  var modal = openModal(mount( /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(I18nContext, null, /*#__PURE__*/React.createElement(EuiModalHeader, null, /*#__PURE__*/React.createElement(EuiModalHeaderTitle, null, title)), /*#__PURE__*/React.createElement(EuiModalBody, null, /*#__PURE__*/React.createElement(EuiCallOut, {
    size: "s",
    color: "danger",
    iconType: "alert",
    title: error.message
  }), text && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(EuiCodeBlock, {
    isCopyable: true,
    paddingSize: "s"
  }, text))), /*#__PURE__*/React.createElement(EuiModalFooter, null, /*#__PURE__*/React.createElement(EuiButton, {
    onClick: function onClick() {
      return modal.close();
    },
    fill: true
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "core.notifications.errorToast.closeModal",
    defaultMessage: "Close"
  })))))));
}

export function ErrorToast(_ref2) {
  var title = _ref2.title,
      error = _ref2.error,
      toastMessage = _ref2.toastMessage,
      openModal = _ref2.openModal,
      i18nContext = _ref2.i18nContext;
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("p", {
    "data-test-subj": "errorToastMessage"
  }, toastMessage), /*#__PURE__*/React.createElement("div", {
    className: "eui-textRight"
  }, /*#__PURE__*/React.createElement(EuiButton, {
    size: "s",
    color: "danger",
    onClick: function onClick() {
      return showErrorDialog({
        title: title,
        error: error,
        openModal: openModal,
        i18nContext: i18nContext
      });
    }
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "core.toasts.errorToast.seeFullError",
    defaultMessage: "See the full error"
  }))));
}

var mount = function mount(component) {
  return function (container) {
    ReactDOM.render(component, container);
    return function () {
      return ReactDOM.unmountComponentAtNode(container);
    };
  };
};