function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e2) { throw _e2; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e3) { didErr = true; err = _e3; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { PluginWrapper } from './plugin';
import { createPluginInitializerContext, createPluginSetupContext, createPluginStartContext } from './plugin_context';
import { withTimeout } from '../../utils';
var Sec = 1000;
/** @internal */

/**
 * Service responsible for loading plugin bundles, initializing plugins, and managing the lifecycle
 * of all plugins.
 *
 * @internal
 */
export var PluginsService = /*#__PURE__*/function () {
  /** Plugin wrappers in topological order. */
  function PluginsService(coreContext, plugins) {
    var _this = this;

    _classCallCheck(this, PluginsService);

    this.coreContext = coreContext;

    _defineProperty(this, "plugins", new Map());

    _defineProperty(this, "pluginDependencies", new Map());

    _defineProperty(this, "satupPlugins", []);

    // Generate opaque ids
    var opaqueIds = new Map(plugins.map(function (p) {
      return [p.id, Symbol(p.id)];
    })); // Setup dependency map and plugin wrappers

    plugins.forEach(function (_ref) {
      var id = _ref.id,
          plugin = _ref.plugin,
          _ref$config = _ref.config,
          config = _ref$config === void 0 ? {} : _ref$config;

      // Setup map of dependencies
      _this.pluginDependencies.set(id, [].concat(_toConsumableArray(plugin.requiredPlugins), _toConsumableArray(plugin.optionalPlugins.filter(function (optPlugin) {
        return opaqueIds.has(optPlugin);
      })))); // Construct plugin wrappers, depending on the topological order set by the server.


      _this.plugins.set(id, new PluginWrapper(plugin, opaqueIds.get(id), createPluginInitializerContext(_this.coreContext, opaqueIds.get(id), plugin, config)));
    });
  }

  _createClass(PluginsService, [{
    key: "getOpaqueIds",
    value: function getOpaqueIds() {
      var _this2 = this;

      // Return dependency map of opaque ids
      return new Map(_toConsumableArray(this.pluginDependencies).map(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
            id = _ref3[0],
            deps = _ref3[1];

        return [_this2.plugins.get(id).opaqueId, deps.map(function (depId) {
          return _this2.plugins.get(depId).opaqueId;
        })];
      }));
    }
  }, {
    key: "setup",
    value: function () {
      var _setup = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(deps) {
        var contracts, _iterator, _step, _step$value, pluginName, plugin, pluginDepContracts, contract;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                // Setup each plugin with required and optional plugin contracts
                contracts = new Map();
                _iterator = _createForOfIteratorHelper(this.plugins.entries());
                _context.prev = 2;

                _iterator.s();

              case 4:
                if ((_step = _iterator.n()).done) {
                  _context.next = 14;
                  break;
                }

                _step$value = _slicedToArray(_step.value, 2), pluginName = _step$value[0], plugin = _step$value[1];
                pluginDepContracts = _toConsumableArray(this.pluginDependencies.get(pluginName)).reduce(function (depContracts, dependencyName) {
                  // Only set if present. Could be absent if plugin does not have client-side code or is a
                  // missing optional plugin.
                  if (contracts.has(dependencyName)) {
                    depContracts[dependencyName] = contracts.get(dependencyName);
                  }

                  return depContracts;
                }, {});
                _context.next = 9;
                return withTimeout({
                  promise: plugin.setup(createPluginSetupContext(this.coreContext, deps, plugin), pluginDepContracts),
                  timeout: 30 * Sec,
                  errorMessage: "Setup lifecycle of \"".concat(pluginName, "\" plugin wasn't completed in 30sec. Consider disabling the plugin and re-start.")
                });

              case 9:
                contract = _context.sent;
                contracts.set(pluginName, contract);
                this.satupPlugins.push(pluginName);

              case 12:
                _context.next = 4;
                break;

              case 14:
                _context.next = 19;
                break;

              case 16:
                _context.prev = 16;
                _context.t0 = _context["catch"](2);

                _iterator.e(_context.t0);

              case 19:
                _context.prev = 19;

                _iterator.f();

                return _context.finish(19);

              case 22:
                return _context.abrupt("return", {
                  contracts: contracts
                });

              case 23:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this, [[2, 16, 19, 22]]);
      }));

      function setup(_x) {
        return _setup.apply(this, arguments);
      }

      return setup;
    }()
  }, {
    key: "start",
    value: function () {
      var _start = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(deps) {
        var contracts, _iterator2, _step2, _step2$value, pluginName, plugin, pluginDepContracts, contract;

        return regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                // Setup each plugin with required and optional plugin contracts
                contracts = new Map();
                _iterator2 = _createForOfIteratorHelper(this.plugins.entries());
                _context2.prev = 2;

                _iterator2.s();

              case 4:
                if ((_step2 = _iterator2.n()).done) {
                  _context2.next = 13;
                  break;
                }

                _step2$value = _slicedToArray(_step2.value, 2), pluginName = _step2$value[0], plugin = _step2$value[1];
                pluginDepContracts = _toConsumableArray(this.pluginDependencies.get(pluginName)).reduce(function (depContracts, dependencyName) {
                  // Only set if present. Could be absent if plugin does not have client-side code or is a
                  // missing optional plugin.
                  if (contracts.has(dependencyName)) {
                    depContracts[dependencyName] = contracts.get(dependencyName);
                  }

                  return depContracts;
                }, {});
                _context2.next = 9;
                return withTimeout({
                  promise: plugin.start(createPluginStartContext(this.coreContext, deps, plugin), pluginDepContracts),
                  timeout: 30 * Sec,
                  errorMessage: "Start lifecycle of \"".concat(pluginName, "\" plugin wasn't completed in 30sec. Consider disabling the plugin and re-start.")
                });

              case 9:
                contract = _context2.sent;
                contracts.set(pluginName, contract);

              case 11:
                _context2.next = 4;
                break;

              case 13:
                _context2.next = 18;
                break;

              case 15:
                _context2.prev = 15;
                _context2.t0 = _context2["catch"](2);

                _iterator2.e(_context2.t0);

              case 18:
                _context2.prev = 18;

                _iterator2.f();

                return _context2.finish(18);

              case 21:
                return _context2.abrupt("return", {
                  contracts: contracts
                });

              case 22:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2, this, [[2, 15, 18, 21]]);
      }));

      function start(_x2) {
        return _start.apply(this, arguments);
      }

      return start;
    }()
  }, {
    key: "stop",
    value: function () {
      var _stop = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee3() {
        var _iterator3, _step3, pluginName;

        return regeneratorRuntime.wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                // Stop plugins in reverse topological order.
                _iterator3 = _createForOfIteratorHelper(this.satupPlugins.reverse());

                try {
                  for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
                    pluginName = _step3.value;
                    this.plugins.get(pluginName).stop();
                  }
                } catch (err) {
                  _iterator3.e(err);
                } finally {
                  _iterator3.f();
                }

              case 2:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3, this);
      }));

      function stop() {
        return _stop.apply(this, arguments);
      }

      return stop;
    }()
  }]);

  return PluginsService;
}();