function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { memoize } from 'lodash';
import { UI_SETTINGS } from '../../../common';

function resolver(title, field, query, boolFilter) {
  // Only cache results for a minute
  var ttl = Math.floor(Date.now() / 1000 / 60);
  return [ttl, query, title, field.name, JSON.stringify(boolFilter)].join('|');
}

export var getEmptyValueSuggestions = function getEmptyValueSuggestions() {
  return Promise.resolve([]);
};
export var setupValueSuggestionProvider = function setupValueSuggestionProvider(core) {
  var requestSuggestions = memoize(function (index, field, query) {
    var boolFilter = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : [];
    var signal = arguments.length > 4 ? arguments[4] : undefined;
    return core.http.fetch("/api/kibana/suggestions/values/".concat(index), {
      method: 'POST',
      body: JSON.stringify({
        query: query,
        field: field.name,
        boolFilter: boolFilter
      }),
      signal: signal
    });
  }, resolver);
  return /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(_ref) {
      var indexPattern, field, query, boolFilter, signal, shouldSuggestValues, title;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              indexPattern = _ref.indexPattern, field = _ref.field, query = _ref.query, boolFilter = _ref.boolFilter, signal = _ref.signal;
              shouldSuggestValues = core.uiSettings.get(UI_SETTINGS.FILTERS_EDITOR_SUGGEST_VALUES);
              title = indexPattern.title;

              if (!(field.type === 'boolean')) {
                _context.next = 7;
                break;
              }

              return _context.abrupt("return", [true, false]);

            case 7:
              if (!(!shouldSuggestValues || !field.aggregatable || field.type !== 'string')) {
                _context.next = 9;
                break;
              }

              return _context.abrupt("return", []);

            case 9:
              _context.next = 11;
              return requestSuggestions(title, field, query, boolFilter, signal);

            case 11:
              return _context.abrupt("return", _context.sent);

            case 12:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function (_x) {
      return _ref2.apply(this, arguments);
    };
  }();
};