function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { i18n } from '@kbn/i18n';
import { writeParams } from './agg_params';
export var AggConfig = /*#__PURE__*/function () {
  _createClass(AggConfig, null, [{
    key: "ensureIds",

    /**
     * Ensure that all of the objects in the list have ids, the objects
     * and list are modified by reference.
     *
     * @param  {array[object]} list - a list of objects, objects can be anything really
     * @return {array} - the list that was passed in
     */
    value: function ensureIds(list) {
      var have = [];
      var haveNot = [];
      list.forEach(function (obj) {
        (obj.id ? have : haveNot).push(obj);
      });
      var nextId = AggConfig.nextId(have);
      haveNot.forEach(function (obj) {
        obj.id = String(nextId++);
      });
      return list;
    }
    /**
     * Calculate the next id based on the ids in this list
     *
     * @return {array} list - a list of objects with id properties
     */

  }, {
    key: "nextId",
    value: function nextId(list) {
      return 1 + list.reduce(function (max, obj) {
        return Math.max(max, +obj.id || 0);
      }, 0);
    }
  }]);

  function AggConfig(aggConfigs, opts) {
    _classCallCheck(this, AggConfig);

    _defineProperty(this, "aggConfigs", void 0);

    _defineProperty(this, "id", void 0);

    _defineProperty(this, "enabled", void 0);

    _defineProperty(this, "params", void 0);

    _defineProperty(this, "parent", void 0);

    _defineProperty(this, "brandNew", void 0);

    _defineProperty(this, "schema", void 0);

    _defineProperty(this, "__type", void 0);

    _defineProperty(this, "__typeDecorations", void 0);

    _defineProperty(this, "subAggs", []);

    this.aggConfigs = aggConfigs;
    this.id = String(opts.id || AggConfig.nextId(aggConfigs.aggs));
    this.enabled = typeof opts.enabled === 'boolean' ? opts.enabled : true; // start with empty params so that checks in type/schema setters don't freak
    // because this.params is undefined

    this.params = {}; // setters

    this.setType(opts.type);

    if (opts.schema) {
      this.schema = opts.schema;
    } // set the params to the values from opts, or just to the defaults


    this.setParams(opts.params || {}); // @ts-ignore

    this.__type = this.__type;
  }
  /**
   * Write the current values to this.params, filling in the defaults as we go
   *
   * @param  {object} [from] - optional object to read values from,
   *                         used when initializing
   * @return {undefined}
   */


  _createClass(AggConfig, [{
    key: "setParams",
    value: function setParams(from) {
      var _this = this;

      from = from || this.params || {};
      var to = this.params = {};
      this.getAggParams().forEach(function (aggParam) {
        var val = from[aggParam.name];

        if (val == null) {
          if (aggParam.default == null) return;

          if (!_.isFunction(aggParam.default)) {
            val = aggParam.default;
          } else {
            val = aggParam.default(_this);
            if (val == null) return;
          }
        }

        if (aggParam.deserialize) {
          var isTyped = _.isFunction(aggParam.valueType);

          var isType = isTyped && val instanceof aggParam.valueType;

          var isObject = !isTyped && _.isObject(val);

          var isDeserialized = isType || isObject;

          if (!isDeserialized) {
            val = aggParam.deserialize(val, _this);
          }

          to[aggParam.name] = val;
          return;
        }

        to[aggParam.name] = _.cloneDeep(val);
      });
    }
  }, {
    key: "getParam",
    value: function getParam(key) {
      return _.get(this.params, key);
    }
  }, {
    key: "write",
    value: function write(aggs) {
      return writeParams(this.type.params, this, aggs);
    }
  }, {
    key: "isFilterable",
    value: function isFilterable() {
      return _.isFunction(this.type.createFilter);
    }
  }, {
    key: "createFilter",
    value: function createFilter(key) {
      var params = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var createFilter = this.type.createFilter;

      if (!createFilter) {
        throw new TypeError("The \"".concat(this.type.title, "\" aggregation does not support filtering."));
      }

      var field = this.getField();
      var label = this.getFieldDisplayName();

      if (field && !field.filterable) {
        var message = "The \"".concat(label, "\" field can not be used for filtering.");

        if (field.scripted) {
          message = "The \"".concat(label, "\" field is scripted and can not be used for filtering.");
        }

        throw new TypeError(message);
      }

      return createFilter(this, key, params);
    }
    /**
     *  Hook for pre-flight logic, see AggType#onSearchRequestStart
     *  @param {Courier.SearchSource} searchSource
     *  @param {Courier.FetchOptions} options
     *  @return {Promise<undefined>}
     */

  }, {
    key: "onSearchRequestStart",
    value: function onSearchRequestStart(searchSource, options) {
      var _this2 = this;

      if (!this.type) {
        return Promise.resolve();
      }

      return Promise.all(this.type.params.map(function (param) {
        return param.modifyAggConfigOnSearchRequestStart(_this2, searchSource, options);
      }));
    }
    /**
     * Convert this aggConfig to its dsl syntax.
     *
     * Adds params and adhoc subaggs to a pojo, then returns it
     *
     * @param  {AggConfigs} aggConfigs - the config object to convert
     * @return {void|Object} - if the config has a dsl representation, it is
     *                         returned, else undefined is returned
     */

  }, {
    key: "toDsl",
    value: function toDsl(aggConfigs) {
      if (this.type.hasNoDsl) return;
      var output = this.write(aggConfigs);
      var configDsl = {};
      configDsl[this.type.dslName || this.type.name] = output.params; // if the config requires subAggs, write them to the dsl as well

      if (this.subAggs.length && !output.subAggs) output.subAggs = this.subAggs;

      if (output.subAggs) {
        var subDslLvl = configDsl.aggs || (configDsl.aggs = {});
        output.subAggs.forEach(function nestAdhocSubAggs(subAggConfig) {
          subDslLvl[subAggConfig.id] = subAggConfig.toDsl(aggConfigs);
        });
      }

      if (output.parentAggs) {
        var _subDslLvl = configDsl.parentAggs || (configDsl.parentAggs = {});

        output.parentAggs.forEach(function nestAdhocSubAggs(subAggConfig) {
          _subDslLvl[subAggConfig.id] = subAggConfig.toDsl(aggConfigs);
        });
      }

      return configDsl;
    }
    /**
     * @returns Returns a serialized representation of an AggConfig.
     */

  }, {
    key: "serialize",
    value: function serialize() {
      var _this3 = this;

      var params = this.params;

      var outParams = _.transform(this.getAggParams(), function (out, aggParam) {
        var val = params[aggParam.name]; // don't serialize undefined/null values

        if (val == null) return;
        if (aggParam.serialize) val = aggParam.serialize(val, _this3);
        if (val == null) return; // to prevent accidental leaking, we will clone all complex values

        out[aggParam.name] = _.cloneDeep(val);
      }, {});

      return _objectSpread({
        id: this.id,
        enabled: this.enabled,
        type: this.type && this.type.name,
        params: outParams
      }, this.schema && {
        schema: this.schema
      });
    }
    /**
     * @deprecated - Use serialize() instead.
     */

  }, {
    key: "toJSON",
    value: function toJSON() {
      return this.serialize();
    }
    /**
     * Returns a serialized field format for the field used in this agg.
     * This can be passed to fieldFormats.deserialize to get the field
     * format instance.
     *
     * @public
     */

  }, {
    key: "toSerializedFieldFormat",
    value: function toSerializedFieldFormat() {
      return this.type ? this.type.getSerializedFormat(this) : {};
    }
    /**
     * @returns Returns an ExpressionAst representing the function for this agg type.
     */

  }, {
    key: "toExpressionAst",
    value: function toExpressionAst() {
      var _this4 = this;

      var functionName = this.type && this.type.expressionName;

      var _this$serialize = this.serialize(),
          type = _this$serialize.type,
          rest = _objectWithoutProperties(_this$serialize, ["type"]);

      if (!functionName || !rest.params) {
        // Return undefined - there is no matching expression function for this agg
        return;
      } // Go through each of the params and convert to an array of expression args.


      var params = Object.entries(rest.params).reduce(function (acc, _ref) {
        var _ref2 = _slicedToArray(_ref, 2),
            key = _ref2[0],
            value = _ref2[1];

        var deserializedParam = _this4.getAggParams().find(function (p) {
          return p.name === key;
        });

        if (deserializedParam && deserializedParam.toExpressionAst) {
          // If the param provides `toExpressionAst`, we call it with the value
          var paramExpressionAst = deserializedParam.toExpressionAst(_this4.getParam(key));

          if (paramExpressionAst) {
            acc[key] = [{
              type: 'expression',
              chain: [paramExpressionAst]
            }];
          }
        } else if (_typeof(value) === 'object') {
          // For object params which don't provide `toExpressionAst`, we stringify
          acc[key] = [JSON.stringify(value)];
        } else if (typeof value !== 'undefined') {
          // Everything else just gets stored in an array if it is defined
          acc[key] = [value];
        }

        return acc;
      }, {});
      return {
        type: 'function',
        function: functionName,
        arguments: _objectSpread(_objectSpread({}, params), {}, {
          // Expression args which are provided to all functions
          id: [this.id],
          enabled: [this.enabled]
        }, this.schema ? {
          schema: [this.schema]
        } : {})
      };
    }
  }, {
    key: "getAggParams",
    value: function getAggParams() {
      return _toConsumableArray(_.hasIn(this, 'type.params') ? this.type.params : []);
    }
  }, {
    key: "getRequestAggs",
    value: function getRequestAggs() {
      return this.type && this.type.getRequestAggs(this) || [this];
    }
  }, {
    key: "getResponseAggs",
    value: function getResponseAggs() {
      return this.type && this.type.getResponseAggs(this) || [this];
    }
  }, {
    key: "getValue",
    value: function getValue(bucket) {
      return this.type.getValue(this, bucket);
    }
  }, {
    key: "getKey",
    value: function getKey(bucket, key) {
      if (this.type.getKey) {
        return this.type.getKey(bucket, key, this);
      } else {
        return '';
      }
    }
  }, {
    key: "getFieldDisplayName",
    value: function getFieldDisplayName() {
      var field = this.getField();
      return field ? field.displayName || this.fieldName() : '';
    }
  }, {
    key: "getField",
    value: function getField() {
      return this.params.field;
    }
  }, {
    key: "makeLabel",
    value: function makeLabel() {
      var percentageMode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

      if (this.params.customLabel) {
        return this.params.customLabel;
      }

      if (!this.type) return '';
      return percentageMode ? i18n.translate('data.search.aggs.percentageOfLabel', {
        defaultMessage: 'Percentage of {label}',
        values: {
          label: this.type.makeLabel(this)
        }
      }) : "".concat(this.type.makeLabel(this));
    }
  }, {
    key: "getIndexPattern",
    value: function getIndexPattern() {
      return this.aggConfigs.indexPattern;
    }
  }, {
    key: "getTimeRange",
    value: function getTimeRange() {
      return this.aggConfigs.timeRange;
    }
  }, {
    key: "fieldName",
    value: function fieldName() {
      var field = this.getField();
      return field ? field.name : '';
    }
  }, {
    key: "fieldIsTimeField",
    value: function fieldIsTimeField() {
      var indexPattern = this.getIndexPattern();
      if (!indexPattern) return false;
      var timeFieldName = indexPattern.timeFieldName;
      return timeFieldName && this.fieldName() === timeFieldName;
    }
  }, {
    key: "setType",
    value: function setType(type) {
      this.type = type;
    }
  }, {
    key: "type",
    get: function get() {
      return this.__type;
    },
    set: function set(type) {
      var _this5 = this;

      if (this.__typeDecorations) {
        _.forOwn(this.__typeDecorations, function (prop, name) {
          // @ts-ignore
          delete _this5[name];
        });
      }

      if (type && _.isFunction(type.decorateAggConfig)) {
        this.__typeDecorations = type.decorateAggConfig();
        Object.defineProperties(this, this.__typeDecorations);
      }

      this.__type = type;
      var availableFields = [];
      var fieldParam = this.type && this.type.params.find(function (p) {
        return p.type === 'field';
      });

      if (fieldParam) {
        // @ts-ignore
        availableFields = fieldParam.getAvailableFields(this);
      } // clear out the previous params except for a few special ones


      this.setParams({
        // almost every agg has fields, so we try to persist that when type changes
        field: availableFields.find(function (field) {
          return field.name === _this5.getField();
        })
      });
    }
  }]);

  return AggConfig;
}();