function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { noop } from 'lodash';
import { i18n } from '@kbn/i18n';
import { BucketAggType } from './bucket_agg_type';
import { BUCKET_TYPES } from './bucket_agg_types';
import { createFilterTerms } from './create_filter/terms';
import { isStringOrNumberType, migrateIncludeExcludeFormat } from './migrate_include_exclude_format';
import { KBN_FIELD_TYPES } from '../../../../common';
import { getRequestInspectorStats, getResponseInspectorStats } from '../../expressions';
import { buildOtherBucketAgg, mergeOtherBucketAggResponse, updateMissingBucket } from './_terms_other_bucket_helper';
export var termsAggFilter = ['!top_hits', '!percentiles', '!median', '!std_dev', '!derivative', '!moving_avg', '!serial_diff', '!cumulative_sum', '!avg_bucket', '!max_bucket', '!min_bucket', '!sum_bucket'];
var termsTitle = i18n.translate('data.search.aggs.buckets.termsTitle', {
  defaultMessage: 'Terms'
});
export var getTermsBucketAgg = function getTermsBucketAgg() {
  return new BucketAggType({
    name: BUCKET_TYPES.TERMS,
    expressionName: 'aggTerms',
    title: termsTitle,
    makeLabel: function makeLabel(agg) {
      var params = agg.params;
      return agg.getFieldDisplayName() + ': ' + params.order.text;
    },
    getSerializedFormat: function getSerializedFormat(agg) {
      var format = agg.params.field ? agg.params.field.format.toJSON() : {};
      return {
        id: 'terms',
        params: _objectSpread({
          id: format.id,
          otherBucketLabel: agg.params.otherBucketLabel,
          missingBucketLabel: agg.params.missingBucketLabel
        }, format.params)
      };
    },
    createFilter: createFilterTerms,
    postFlightRequest: function () {
      var _postFlightRequest = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(resp, aggConfigs, aggConfig, searchSource, inspectorRequestAdapter, abortSignal) {
        var nestedSearchSource, filterAgg, request, response;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                if (resp.aggregations) {
                  _context.next = 2;
                  break;
                }

                return _context.abrupt("return", resp);

              case 2:
                nestedSearchSource = searchSource.createChild();

                if (!aggConfig.params.otherBucket) {
                  _context.next = 16;
                  break;
                }

                filterAgg = buildOtherBucketAgg(aggConfigs, aggConfig, resp);

                if (filterAgg) {
                  _context.next = 7;
                  break;
                }

                return _context.abrupt("return", resp);

              case 7:
                nestedSearchSource.setField('aggs', filterAgg);
                request = inspectorRequestAdapter.start(i18n.translate('data.search.aggs.buckets.terms.otherBucketTitle', {
                  defaultMessage: 'Other bucket'
                }), {
                  description: i18n.translate('data.search.aggs.buckets.terms.otherBucketDescription', {
                    defaultMessage: 'This request counts the number of documents that fall ' + 'outside the criterion of the data buckets.'
                  })
                });
                nestedSearchSource.getSearchRequestBody().then(function (body) {
                  request.json(body);
                });
                request.stats(getRequestInspectorStats(nestedSearchSource));
                _context.next = 13;
                return nestedSearchSource.fetch({
                  abortSignal: abortSignal
                });

              case 13:
                response = _context.sent;
                request.stats(getResponseInspectorStats(nestedSearchSource, response)).ok({
                  json: response
                });
                resp = mergeOtherBucketAggResponse(aggConfigs, resp, response, aggConfig, filterAgg());

              case 16:
                if (aggConfig.params.missingBucket) {
                  resp = updateMissingBucket(resp, aggConfigs, aggConfig);
                }

                return _context.abrupt("return", resp);

              case 18:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      function postFlightRequest(_x, _x2, _x3, _x4, _x5, _x6) {
        return _postFlightRequest.apply(this, arguments);
      }

      return postFlightRequest;
    }(),
    params: [{
      name: 'field',
      type: 'field',
      filterFieldTypes: [KBN_FIELD_TYPES.NUMBER, KBN_FIELD_TYPES.BOOLEAN, KBN_FIELD_TYPES.DATE, KBN_FIELD_TYPES.IP, KBN_FIELD_TYPES.STRING]
    }, {
      name: 'orderBy',
      write: noop // prevent default write, it's handled by orderAgg

    }, {
      name: 'orderAgg',
      type: 'agg',
      allowedAggs: termsAggFilter,
      default: null,
      makeAgg: function makeAgg(termsAgg) {
        var state = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {
          type: 'count'
        };
        state.schema = 'orderAgg';
        var orderAgg = termsAgg.aggConfigs.createAggConfig(state, {
          addToAggConfigs: false
        });
        orderAgg.id = termsAgg.id + '-orderAgg';
        return orderAgg;
      },
      write: function write(agg, output, aggs) {
        var dir = agg.params.order.value;
        var order = output.params.order = {};
        var orderAgg = agg.params.orderAgg || aggs.getResponseAggById(agg.params.orderBy); // TODO: This works around an Elasticsearch bug the always casts terms agg scripts to strings
        // thus causing issues with filtering. This probably causes other issues since float might not
        // be able to contain the number on the elasticsearch side

        if (output.params.script) {
          output.params.value_type = agg.getField().type === 'number' ? 'float' : agg.getField().type;
        }

        if (agg.params.missingBucket && agg.params.field.type === 'string') {
          output.params.missing = '__missing__';
        }

        if (!orderAgg) {
          order[agg.params.orderBy || '_count'] = dir;
          return;
        }

        if (orderAgg.type.name === 'count') {
          order._count = dir;
          return;
        }

        var orderAggId = orderAgg.id;

        if (orderAgg.parentId && aggs) {
          orderAgg = aggs.byId(orderAgg.parentId);
        }

        output.subAggs = (output.subAggs || []).concat(orderAgg);
        order[orderAggId] = dir;
      }
    }, {
      name: 'order',
      type: 'optioned',
      default: 'desc',
      options: [{
        text: i18n.translate('data.search.aggs.buckets.terms.orderDescendingTitle', {
          defaultMessage: 'Descending'
        }),
        value: 'desc'
      }, {
        text: i18n.translate('data.search.aggs.buckets.terms.orderAscendingTitle', {
          defaultMessage: 'Ascending'
        }),
        value: 'asc'
      }],
      write: noop // prevent default write, it's handled by orderAgg

    }, {
      name: 'size',
      default: 5
    }, {
      name: 'otherBucket',
      default: false,
      write: noop
    }, {
      name: 'otherBucketLabel',
      type: 'string',
      default: i18n.translate('data.search.aggs.buckets.terms.otherBucketLabel', {
        defaultMessage: 'Other'
      }),
      displayName: i18n.translate('data.search.aggs.otherBucket.labelForOtherBucketLabel', {
        defaultMessage: 'Label for other bucket'
      }),
      shouldShow: function shouldShow(agg) {
        return agg.getParam('otherBucket');
      },
      write: noop
    }, {
      name: 'missingBucket',
      default: false,
      write: noop
    }, {
      name: 'missingBucketLabel',
      default: i18n.translate('data.search.aggs.buckets.terms.missingBucketLabel', {
        defaultMessage: 'Missing',
        description: "Default label used in charts when documents are missing a field.\n          Visible when you create a chart with a terms aggregation and enable \"Show missing values\""
      }),
      type: 'string',
      displayName: i18n.translate('data.search.aggs.otherBucket.labelForMissingValuesLabel', {
        defaultMessage: 'Label for missing values'
      }),
      shouldShow: function shouldShow(agg) {
        return agg.getParam('missingBucket');
      },
      write: noop
    }, _objectSpread({
      name: 'exclude',
      displayName: i18n.translate('data.search.aggs.buckets.terms.excludeLabel', {
        defaultMessage: 'Exclude'
      }),
      type: 'string',
      advanced: true,
      shouldShow: isStringOrNumberType
    }, migrateIncludeExcludeFormat), _objectSpread({
      name: 'include',
      displayName: i18n.translate('data.search.aggs.buckets.terms.includeLabel', {
        defaultMessage: 'Include'
      }),
      type: 'string',
      advanced: true,
      shouldShow: isStringOrNumberType
    }, migrateIncludeExcludeFormat)]
  });
};