function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { handleResponse } from '../fetch';
import { defaultSearchStrategy } from './default_search_strategy';
export function callClient(searchRequests) {
  var requestsOptions = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  var fetchHandlers = arguments.length > 2 ? arguments[2] : undefined;
  // Correlate the options with the request that they're associated with
  var requestOptionEntries = searchRequests.map(function (request, i) {
    return [request, requestsOptions[i]];
  });
  var requestOptionsMap = new Map(requestOptionEntries);
  var requestResponseMap = new Map();

  var _defaultSearchStrateg = defaultSearchStrategy.search(_objectSpread({
    searchRequests: searchRequests
  }, fetchHandlers)),
      searching = _defaultSearchStrateg.searching,
      abort = _defaultSearchStrateg.abort;

  searchRequests.forEach(function (request, i) {
    var response = searching.then(function (results) {
      return handleResponse(request, results[i]);
    });

    var _ref = requestOptionsMap.get(request) || {},
        _ref$abortSignal = _ref.abortSignal,
        abortSignal = _ref$abortSignal === void 0 ? null : _ref$abortSignal;

    if (abortSignal) abortSignal.addEventListener('abort', abort);
    requestResponseMap.set(request, response);
  });
  return searchRequests.map(function (request) {
    return requestResponseMap.get(request);
  });
}