/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiStepsHorizontal, EuiSpacer } from '@elastic/eui';
import { FormWizardProvider, FormWizardConsumer } from './form_wizard_context';
import { FormWizardNav } from './form_wizard_nav';
export function FormWizard(_ref) {
  var texts = _ref.texts,
      defaultActiveStep = _ref.defaultActiveStep,
      defaultValue = _ref.defaultValue,
      apiError = _ref.apiError,
      isEditing = _ref.isEditing,
      isSaving = _ref.isSaving,
      onSave = _ref.onSave,
      onChange = _ref.onChange,
      children = _ref.children;
  return /*#__PURE__*/React.createElement(FormWizardProvider, {
    defaultValue: defaultValue,
    isEditing: isEditing,
    onSave: onSave,
    onChange: onChange,
    defaultActiveStep: defaultActiveStep
  }, /*#__PURE__*/React.createElement(FormWizardConsumer, null, function (_ref2) {
    var activeStepIndex = _ref2.activeStepIndex,
        lastStep = _ref2.lastStep,
        steps = _ref2.steps,
        isCurrentStepValid = _ref2.isCurrentStepValid,
        navigateToStep = _ref2.navigateToStep;
    var stepsRequiredArray = Object.values(steps).map(function (step) {
      return Boolean(step.isRequired) && step.isComplete === false;
    });

    var getIsStepDisabled = function getIsStepDisabled(stepIndex) {
      // Disable all steps when the current step is invalid
      if (stepIndex !== activeStepIndex && isCurrentStepValid === false) {
        return true;
      }

      var isDisabled = false;

      if (stepIndex > activeStepIndex + 1) {
        /**
         * Rule explained:
         * - all the previous steps are always enabled (we can go back anytime)
         * - the next step is also always enabled (it acts as the "Next" button)
         * - for the rest, the step is disabled if any of the previous step (_greater_ than the current
         * active step), is marked as isRequired **AND** has not been completed.
         */
        isDisabled = stepsRequiredArray.reduce(function (acc, isRequired, i) {
          if (acc === true || i <= activeStepIndex || i >= stepIndex) {
            return acc;
          }

          return Boolean(isRequired);
        }, false);
      }

      return isDisabled;
    };

    var euiSteps = Object.values(steps).map(function (_ref3) {
      var index = _ref3.index,
          label = _ref3.label;
      return {
        title: label,
        isComplete: activeStepIndex > index,
        isSelected: activeStepIndex === index,
        disabled: getIsStepDisabled(index),
        onClick: function onClick() {
          return navigateToStep(index);
        }
      };
    });

    var onBack = function onBack() {
      var prevStep = activeStepIndex - 1;
      navigateToStep(prevStep);
    };

    var onNext = function onNext() {
      var nextStep = activeStepIndex + 1;
      navigateToStep(nextStep);
    };

    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiStepsHorizontal, {
      steps: euiSteps
    }), /*#__PURE__*/React.createElement(EuiSpacer, {
      size: "l"
    }), apiError, children, /*#__PURE__*/React.createElement(EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/React.createElement(FormWizardNav, {
      activeStepIndex: activeStepIndex,
      lastStep: lastStep,
      isStepValid: isCurrentStepValid,
      isSaving: isSaving,
      onBack: onBack,
      onNext: onNext,
      texts: texts
    }));
  }));
}