function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { EuiFlexGroup, EuiFlexItem, EuiFlyoutHeader, EuiTitle, EuiFlyoutBody } from '@elastic/eui';
import { InspectorViewChooser } from './inspector_view_chooser';

function hasAdaptersChanged(oldAdapters, newAdapters) {
  return Object.keys(oldAdapters).length !== Object.keys(newAdapters).length || Object.keys(oldAdapters).some(function (key) {
    return oldAdapters[key] !== newAdapters[key];
  });
}

var inspectorTitle = i18n.translate('inspector.title', {
  defaultMessage: 'Inspector'
});
export var InspectorPanel = /*#__PURE__*/function (_Component) {
  _inherits(InspectorPanel, _Component);

  var _super = _createSuper(InspectorPanel);

  function InspectorPanel() {
    var _this;

    _classCallCheck(this, InspectorPanel);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      selectedView: _this.props.views[0],
      views: _this.props.views,
      // Clone adapters array so we can validate that this prop never change
      adapters: _objectSpread({}, _this.props.adapters)
    });

    _defineProperty(_assertThisInitialized(_this), "onViewSelected", function (view) {
      if (view !== _this.state.selectedView) {
        _this.setState({
          selectedView: view
        });
      }
    });

    return _this;
  }

  _createClass(InspectorPanel, [{
    key: "renderSelectedPanel",
    value: function renderSelectedPanel() {
      return /*#__PURE__*/React.createElement(this.state.selectedView.component, {
        adapters: this.props.adapters,
        title: this.props.title || ''
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this$props = this.props,
          views = _this$props.views,
          title = _this$props.title;
      var selectedView = this.state.selectedView;
      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiFlyoutHeader, {
        hasBorder: true
      }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
        justifyContent: "spaceBetween",
        alignItems: "center"
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: true
      }, /*#__PURE__*/React.createElement(EuiTitle, {
        size: "s"
      }, /*#__PURE__*/React.createElement("h1", null, title))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(InspectorViewChooser, {
        views: views,
        onViewSelected: this.onViewSelected,
        selectedView: selectedView
      })))), /*#__PURE__*/React.createElement(EuiFlyoutBody, null, this.renderSelectedPanel()));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      if (hasAdaptersChanged(prevState.adapters, nextProps.adapters)) {
        throw new Error('Adapters are not allowed to be changed on an open InspectorPanel.');
      }

      var selectedViewMustChange = nextProps.views !== prevState.views && !nextProps.views.includes(prevState.selectedView);
      return {
        views: nextProps.views,
        selectedView: selectedViewMustChange ? nextProps.views[0] : prevState.selectedView
      };
    }
  }]);

  return InspectorPanel;
}(Component);

_defineProperty(InspectorPanel, "defaultProps", {
  title: inspectorTitle
});

_defineProperty(InspectorPanel, "propTypes", {
  adapters: PropTypes.object.isRequired,
  views: function views(props, propName, componentName) {
    if (!Array.isArray(props.views) || props.views.length < 1) {
      throw new Error("".concat(propName, " prop must be an array of at least one element in ").concat(componentName, "."));
    }
  },
  title: PropTypes.string
});