function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiFlexGroup, EuiFlexItem } from '@elastic/eui';
import classNames from 'classnames';
import { TopNavMenuItem } from './top_nav_menu_item';

/*
 * Top Nav Menu is a convenience wrapper component for:
 * - Top navigation menu - configured by an array of `TopNavMenuData` objects
 * - Search Bar - which includes Filter Bar \ Query Input \ Timepicker.
 *
 * See SearchBar documentation to learn more about its properties.
 *
 **/
export function TopNavMenu(props) {
  var config = props.config,
      showSearchBar = props.showSearchBar,
      searchBarProps = _objectWithoutProperties(props, ["config", "showSearchBar"]);

  if ((!config || config.length === 0) && (!showSearchBar || !props.data)) {
    return null;
  }

  function renderItems() {
    if (!config || config.length === 0) return null;
    return config.map(function (menuItem, i) {
      return /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false,
        key: "nav-menu-".concat(i),
        className: menuItem.emphasize ? 'kbnTopNavItemEmphasized' : ''
      }, /*#__PURE__*/React.createElement(TopNavMenuItem, menuItem));
    });
  }

  function renderMenu(className) {
    if (!config || config.length === 0) return null;
    return /*#__PURE__*/React.createElement(EuiFlexGroup, {
      "data-test-subj": "top-nav",
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "none",
      className: className,
      responsive: false
    }, renderItems());
  }

  function renderSearchBar() {
    // Validate presense of all required fields
    if (!showSearchBar || !props.data) return null;
    var SearchBar = props.data.ui.SearchBar;
    return /*#__PURE__*/React.createElement(SearchBar, searchBarProps);
  }

  function renderLayout() {
    var className = classNames('kbnTopNavMenu', props.className);
    return /*#__PURE__*/React.createElement("span", {
      className: "kbnTopNavMenu__wrapper"
    }, renderMenu(className), renderSearchBar());
  }

  return renderLayout();
}
TopNavMenu.defaultProps = {
  showSearchBar: false,
  showQueryBar: true,
  showQueryInput: true,
  showDatePicker: true,
  showFilterBar: true,
  screenTitle: ''
};