/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { EuiButtonGroup, EuiSpacer } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
var IpRangeTypes;

(function (IpRangeTypes) {
  IpRangeTypes["MASK"] = "mask";
  IpRangeTypes["FROM_TO"] = "fromTo";
})(IpRangeTypes || (IpRangeTypes = {}));

function IpRangeTypeParamEditor(_ref) {
  var agg = _ref.agg,
      value = _ref.value,
      setValue = _ref.setValue;
  var options = [{
    id: "visEditorIpRangeFromToLabel".concat(agg.id),
    label: i18n.translate('visDefaultEditor.controls.ipRanges.fromToButtonLabel', {
      defaultMessage: 'From/to'
    })
  }, {
    id: "visEditorIpRangeCidrLabel".concat(agg.id),
    label: i18n.translate('visDefaultEditor.controls.ipRanges.cidrMasksButtonLabel', {
      defaultMessage: 'CIDR masks'
    })
  }];

  var onClick = function onClick(optionId) {
    setValue(optionId === options[0].id ? IpRangeTypes.FROM_TO : IpRangeTypes.MASK);
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/React.createElement(EuiButtonGroup, {
    isFullWidth: true,
    onChange: onClick,
    idSelected: value === IpRangeTypes.FROM_TO ? options[0].id : options[1].id,
    options: options,
    legend: i18n.translate('visDefaultEditor.controls.ipRangesAriaLabel', {
      defaultMessage: 'IP ranges'
    })
  }), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }));
}

export { IpRangeTypeParamEditor, IpRangeTypes };