function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useRef } from 'react';
import { EuiFormRow, EuiIconTip, EuiSelect } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
export function getCompatibleAggs(agg) {
  var _ref = agg.getAggParams().find(function (_ref2) {
    var name = _ref2.name;
    return name === 'aggregate';
  }),
      _ref$options = _ref.options,
      options = _ref$options === void 0 ? [] : _ref$options;

  return options.filter(function (option) {
    return option.isCompatible(agg);
  });
}
export function TopAggregateParamEditor(_ref3) {
  var agg = _ref3.agg,
      aggParam = _ref3.aggParam,
      value = _ref3.value,
      showValidation = _ref3.showValidation,
      setValue = _ref3.setValue,
      setValidity = _ref3.setValidity,
      setTouched = _ref3.setTouched;
  var isFirstRun = useRef(true);
  var fieldType = agg.params.field && agg.params.field.type;
  var emptyValue = {
    text: '',
    value: 'EMPTY_VALUE',
    disabled: true,
    hidden: true
  };
  var filteredOptions = getCompatibleAggs(agg).map(function (_ref4) {
    var text = _ref4.text,
        val = _ref4.value;
    return {
      text: text,
      value: val
    };
  }).sort(function (a, b) {
    return a.text.toLowerCase().localeCompare(b.text.toLowerCase());
  });
  var options = [emptyValue].concat(_toConsumableArray(filteredOptions));
  var disabled = fieldType && !filteredOptions.length;
  var isValid = disabled || !!value;
  var label = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.controls.aggregateWithLabel",
    defaultMessage: "Aggregate with"
  }), ' ', /*#__PURE__*/React.createElement(EuiIconTip, {
    position: "right",
    type: "questionInCircle",
    content: i18n.translate('visDefaultEditor.controls.aggregateWithTooltip', {
      defaultMessage: 'Choose a strategy for combining multiple hits or a multi-valued field into a single metric.'
    })
  }));
  useEffect(function () {
    setValidity(isValid);
  }, [isValid, setValidity]);
  useEffect(function () {
    if (isFirstRun.current) {
      isFirstRun.current = false;
      return;
    }

    if (value) {
      if (aggParam.options.find(function (opt) {
        return opt.value === value.value;
      })) {
        return;
      }

      setValue();
    }

    if (filteredOptions.length === 1) {
      setValue(aggParam.options.find(function (opt) {
        return opt.value === filteredOptions[0].value;
      }));
    }
  }, [aggParam.options, fieldType, filteredOptions, setValue, value]);

  var handleChange = function handleChange(event) {
    if (event.target.value === emptyValue.value) {
      setValue();
    } else {
      setValue(aggParam.options.find(function (opt) {
        return opt.value === event.target.value;
      }));
    }
  };

  return /*#__PURE__*/React.createElement(EuiFormRow, {
    label: label,
    fullWidth: true,
    isInvalid: showValidation ? !isValid : false,
    compressed: true
  }, /*#__PURE__*/React.createElement(EuiSelect, {
    options: options,
    value: value ? value.value : emptyValue.value,
    onChange: handleChange,
    fullWidth: true,
    compressed: true,
    isInvalid: showValidation ? !isValid : false,
    disabled: disabled,
    onBlur: setTouched,
    "data-test-subj": "visDefaultEditorAggregateWith"
  }));
}