function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useCallback, useRef, useMemo } from 'react';
import { EuiFormLabel } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { monaco } from '@kbn/monaco';
import { CodeEditor, useKibana } from '../../../kibana_react/public';
import { suggest, getSuggestion } from './timelion_expression_input_helpers';
import { getArgValueSuggestions } from '../helpers/arg_value_suggestions';
var LANGUAGE_ID = 'timelion_expression';
monaco.languages.register({
  id: LANGUAGE_ID
});

function TimelionExpressionInput(_ref) {
  var value = _ref.value,
      setValue = _ref.setValue;
  var functionList = useRef([]);
  var kibana = useKibana();
  var argValueSuggestions = useMemo(getArgValueSuggestions, []);
  var provideCompletionItems = useCallback( /*#__PURE__*/function () {
    var _ref2 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(model, position) {
      var text, wordUntil, wordRange, suggestions;
      return regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              text = model.getValue();
              wordUntil = model.getWordUntilPosition(position);
              wordRange = new monaco.Range(position.lineNumber, wordUntil.startColumn, position.lineNumber, wordUntil.endColumn);
              _context.next = 5;
              return suggest(text, functionList.current, // it's important to offset the cursor position on 1 point left
              // because of PEG parser starts the line with 0, but monaco with 1
              position.column - 1, argValueSuggestions);

            case 5:
              suggestions = _context.sent;
              return _context.abrupt("return", {
                suggestions: suggestions ? suggestions.list.map(function (s) {
                  return getSuggestion(s, suggestions.type, wordRange);
                }) : []
              });

            case 7:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function (_x, _x2) {
      return _ref2.apply(this, arguments);
    };
  }(), [argValueSuggestions]);
  var provideHover = useCallback( /*#__PURE__*/function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee2(model, position) {
      var suggestions;
      return regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return suggest(model.getValue(), functionList.current, // it's important to offset the cursor position on 1 point left
              // because of PEG parser starts the line with 0, but monaco with 1
              position.column - 1, argValueSuggestions);

            case 2:
              suggestions = _context2.sent;
              return _context2.abrupt("return", {
                contents: suggestions ? suggestions.list.map(function (s) {
                  return {
                    value: s.help
                  };
                }) : []
              });

            case 4:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    }));

    return function (_x3, _x4) {
      return _ref3.apply(this, arguments);
    };
  }(), [argValueSuggestions]);
  useEffect(function () {
    if (kibana.services.http) {
      kibana.services.http.get('../api/timelion/functions').then(function (data) {
        functionList.current = data;
      });
    }
  }, [kibana.services.http]);
  return /*#__PURE__*/React.createElement("div", {
    className: "timExpressionInput"
  }, /*#__PURE__*/React.createElement(EuiFormLabel, null, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "timelion.vis.expressionLabel",
    defaultMessage: "Timelion expression"
  })), /*#__PURE__*/React.createElement("div", {
    className: "timExpressionInput__editor"
  }, /*#__PURE__*/React.createElement("div", {
    className: "timExpressionInput__absolute"
  }, /*#__PURE__*/React.createElement(CodeEditor, {
    languageId: LANGUAGE_ID,
    value: value,
    onChange: setValue,
    suggestionProvider: {
      triggerCharacters: ['.', ',', '(', '=', ':'],
      provideCompletionItems: provideCompletionItems
    },
    hoverProvider: {
      provideHover: provideHover
    },
    options: {
      fixedOverflowWidgets: true,
      fontSize: 14,
      folding: false,
      lineNumbers: 'off',
      scrollBeyondLastLine: false,
      minimap: {
        enabled: false
      },
      wordBasedSuggestions: false,
      wordWrap: 'on',
      wrappingIndent: 'indent'
    },
    languageConfiguration: {
      autoClosingPairs: [{
        open: '(',
        close: ')'
      }]
    }
  }))));
}

export { TimelionExpressionInput };