function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { get } from 'lodash';
import { FormattedMessage } from '@kbn/i18n/react';
import { htmlIdGenerator, EuiFieldNumber, EuiFlexGroup, EuiFlexItem, EuiFormLabel, EuiSpacer } from '@elastic/eui';
import { AddDeleteButtons } from '../../add_delete_buttons';
export var MultiValueRow = function MultiValueRow(_ref) {
  var model = _ref.model,
      onChange = _ref.onChange,
      _onDelete = _ref.onDelete,
      onAdd = _ref.onAdd,
      disableAdd = _ref.disableAdd,
      disableDelete = _ref.disableDelete;
  var htmlId = htmlIdGenerator();

  var onFieldNumberChange = function onFieldNumberChange(event) {
    return onChange(_objectSpread(_objectSpread({}, model), {}, {
      value: get(event, 'target.value')
    }));
  };

  return /*#__PURE__*/React.createElement("div", {
    className: "tvbAggRow__multiValueRow"
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiFormLabel, {
    htmlFor: htmlId('value')
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeTimeseries.multivalueRow.valueLabel",
    defaultMessage: "Value:"
  }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(EuiFieldNumber, {
    value: model.value === '' ? '' : Number(model.value),
    placeholder: "0",
    onChange: onFieldNumberChange
  })), /*#__PURE__*/React.createElement(EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/React.createElement(AddDeleteButtons, {
    onAdd: onAdd,
    onDelete: function onDelete() {
      return _onDelete(model);
    },
    disableDelete: disableDelete,
    disableAdd: disableAdd
  }))), /*#__PURE__*/React.createElement(EuiSpacer, null));
};
MultiValueRow.defaultProps = {
  model: {
    id: null,
    value: ''
  }
};