function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { htmlIdGenerator, EuiFlexGroup, EuiFlexItem, EuiFormLabel, EuiFormRow, EuiSpacer } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { AggSelect } from '../agg_select'; // @ts-ignore

import { FieldSelect } from '../field_select'; // @ts-ignore

import { createChangeHandler } from '../../lib/create_change_handler'; // @ts-ignore

import { createSelectHandler } from '../../lib/create_select_handler';
import { AggRow } from '../agg_row';
import { PercentileRankValues } from './percentile_rank_values';
import { KBN_FIELD_TYPES } from '../../../../../../../plugins/data/public';
var RESTRICT_FIELDS = [KBN_FIELD_TYPES.NUMBER, KBN_FIELD_TYPES.HISTOGRAM];
export var PercentileRankAgg = function PercentileRankAgg(props) {
  var series = props.series,
      panel = props.panel,
      fields = props.fields;
  var defaults = {
    values: ['']
  };

  var model = _objectSpread(_objectSpread({}, defaults), props.model);

  var indexPattern = series.override_index_pattern && series.series_index_pattern || panel.index_pattern;
  var htmlId = htmlIdGenerator();
  var isTablePanel = panel.type === 'table';
  var handleChange = createChangeHandler(props.onChange, model);
  var handleSelectChange = createSelectHandler(handleChange);

  var handlePercentileRankValuesChange = function handlePercentileRankValuesChange(values) {
    handleChange(_objectSpread(_objectSpread({}, model), {}, {
      values: values
    }));
  };

  return /*#__PURE__*/React.createElement(AggRow, {
    disableDelete: props.disableDelete,
    model: props.model,
    onAdd: props.onAdd,
    onDelete: props.onDelete,
    siblings: props.siblings,
    dragHandleProps: props.dragHandleProps
  }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFormLabel, {
    htmlFor: htmlId('aggregation')
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visTypeTimeseries.percentileRank.aggregationLabel",
    defaultMessage: "Aggregation"
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/React.createElement(AggSelect, {
    id: htmlId('aggregation'),
    panelType: props.panel.type,
    siblings: props.siblings,
    value: model.type,
    onChange: handleSelectChange('type')
  })), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFormRow, {
    id: htmlId('field'),
    label: /*#__PURE__*/React.createElement(FormattedMessage, {
      id: "visTypeTimeseries.percentileRank.fieldLabel",
      defaultMessage: "Field"
    })
  }, /*#__PURE__*/React.createElement(FieldSelect, {
    fields: fields,
    type: model.type,
    restrict: RESTRICT_FIELDS,
    indexPattern: indexPattern,
    value: model.field,
    onChange: handleSelectChange('field')
  })))), /*#__PURE__*/React.createElement(EuiSpacer, null), model.values && /*#__PURE__*/React.createElement(PercentileRankValues, {
    disableAdd: isTablePanel,
    disableDelete: isTablePanel,
    showOnlyLastRow: isTablePanel,
    model: model.values,
    onChange: handlePercentileRankValuesChange
  }));
};