function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { toArray } from 'lodash';
import { getFormatService } from '../../../services';
export var buildHierarchicalData = function buildHierarchicalData(table, _ref) {
  var metric = _ref.metric,
      _ref$buckets = _ref.buckets,
      buckets = _ref$buckets === void 0 ? [] : _ref$buckets;
  var slices;
  var names = {};
  var metricColumn = table.columns[metric.accessor];
  var metricFieldFormatter = metric.format;

  if (!buckets.length) {
    slices = [{
      name: metricColumn.name,
      size: table.rows[0][metricColumn.id]
    }];
    names[metricColumn.name] = metricColumn.name;
  } else {
    slices = [];
    table.rows.forEach(function (row, rowIndex) {
      var parent;
      var dataLevel = slices;
      buckets.forEach(function (bucket) {
        var bucketColumn = table.columns[bucket.accessor];
        var bucketValueColumn = table.columns[bucket.accessor + 1];
        var bucketFormatter = getFormatService().deserialize(bucket.format);
        var name = bucketFormatter.convert(row[bucketColumn.id]);
        var size = row[bucketValueColumn.id];
        names[name] = name;
        var slice = dataLevel.find(function (dataLevelSlice) {
          return dataLevelSlice.name === name;
        });

        if (!slice) {
          slice = {
            name: name,
            size: size,
            parent: parent,
            children: [],
            rawData: {
              table: table,
              row: rowIndex,
              column: bucket.accessor,
              value: row[bucketColumn.id]
            }
          };
          dataLevel.push(slice);
        }

        parent = slice;
        dataLevel = slice.children;
      });
    });
  }

  return {
    hits: table.rows.length,
    raw: table,
    names: toArray(names),
    tooltipFormatter: metricFieldFormatter,
    slices: {
      children: _toConsumableArray(slices)
    }
  };
};