/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { getSeries } from './_get_series';
import { getAspects } from './_get_aspects';
import { initYAxis } from './_init_y_axis';
import { initXAxis } from './_init_x_axis';
import { orderedDateAxis } from './_ordered_date_axis';
export var buildPointSeriesData = function buildPointSeriesData(table, dimensions) {
  var chart = {
    aspects: getAspects(table, dimensions)
  };
  initXAxis(chart, table);
  initYAxis(chart);

  if ('date' in chart.aspects.x[0].params) {
    // initXAxis will turn `chart` into an `OrderedChart if it is a date axis`
    orderedDateAxis(chart);
  }

  chart.series = getSeries(table, chart);
  delete chart.aspects;
  return chart;
};