function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useState } from 'react';
import { cloneDeep, isEqual } from 'lodash';
import { map } from 'rxjs/operators';
import { i18n } from '@kbn/i18n';
import { MarkdownSimple, toMountPoint } from '../../../../../kibana_react/public';
import { esFilters, connectToQueryState } from '../../../../../data/public';
import { visStateToEditorState } from '../utils';
import { createVisualizeAppState } from '../create_visualize_app_state';
import { VisualizeConstants } from '../../visualize_constants';
/**
 * This effect is responsible for instantiating the visualize app state container,
 * which is in sync with "_a" url param
 */

export var useVisualizeAppState = function useVisualizeAppState(services, eventEmitter, instance) {
  var _useState = useState(false),
      _useState2 = _slicedToArray(_useState, 2),
      hasUnappliedChanges = _useState2[0],
      setHasUnappliedChanges = _useState2[1];

  var _useState3 = useState(null),
      _useState4 = _slicedToArray(_useState3, 2),
      appState = _useState4[0],
      setAppState = _useState4[1];

  useEffect(function () {
    if (instance) {
      var stateDefaults = visStateToEditorState(instance, services);

      var _createVisualizeAppSt = createVisualizeAppState({
        stateDefaults: stateDefaults,
        kbnUrlStateStorage: services.kbnUrlStateStorage
      }),
          stateContainer = _createVisualizeAppSt.stateContainer,
          stopStateSync = _createVisualizeAppSt.stopStateSync;

      var onDirtyStateChange = function onDirtyStateChange(_ref) {
        var isDirty = _ref.isDirty;

        if (!isDirty) {
          // it is important to update vis state with fresh data
          stateContainer.transitions.updateVisState(visStateToEditorState(instance, services).vis);
        }

        setHasUnappliedChanges(isDirty);
      };

      eventEmitter.on('dirtyStateChange', onDirtyStateChange);
      var filterManager = services.data.query.filterManager; // sync initial app filters from state to filterManager

      filterManager.setAppFilters(cloneDeep(stateContainer.getState().filters)); // setup syncing of app filters between appState and filterManager

      var stopSyncingAppFilters = connectToQueryState(services.data.query, {
        set: function set(_ref2) {
          var filters = _ref2.filters;
          return stateContainer.transitions.set('filters', filters);
        },
        get: function get() {
          return {
            filters: stateContainer.getState().filters
          };
        },
        state$: stateContainer.state$.pipe(map(function (state) {
          return {
            filters: state.filters
          };
        }))
      }, {
        filters: esFilters.FilterStateStore.APP_STATE
      }); // The savedVis is pulled from elasticsearch, but the appState is pulled from the url, with the
      // defaults applied. If the url was from a previous session which included modifications to the
      // appState then they won't be equal.

      if (!isEqual(stateContainer.getState().vis, stateDefaults.vis)) {
        var _stateContainer$getSt = stateContainer.getState().vis,
            aggs = _stateContainer$getSt.aggs,
            visState = _objectWithoutProperties(_stateContainer$getSt, ["aggs"]);

        instance.vis.setState(_objectSpread(_objectSpread({}, visState), {}, {
          data: {
            aggs: aggs
          }
        })).then(function () {
          // setting up the stateContainer after setState is successful will prevent loading the editor with failures
          // otherwise the catch will take presedence
          setAppState(stateContainer);
        }).catch(function (error) {
          // if setting new vis state was failed for any reason,
          // redirect to the listing page with error message
          services.toastNotifications.addWarning({
            title: i18n.translate('visualize.visualizationLoadingFailedErrorMessage', {
              defaultMessage: 'Failed to load the visualization'
            }),
            text: toMountPoint( /*#__PURE__*/React.createElement(MarkdownSimple, null, error.message))
          });
          services.history.replace("".concat(VisualizeConstants.LANDING_PAGE_PATH, "?notFound=visualization"));
        });
      } else {
        setAppState(stateContainer);
      } // don't forget to clean up


      return function () {
        eventEmitter.off('dirtyStateChange', onDirtyStateChange);
        stopStateSync();
        stopSyncingAppFilters();
      };
    }
  }, [eventEmitter, instance, services]);
  return {
    appState: appState,
    hasUnappliedChanges: hasUnappliedChanges
  };
};