/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.dxf.reader;

import de.escape.quincunx.dxf.reader.DxfException;
import de.escape.quincunx.dxf.reader.DxfFile;
import de.escape.quincunx.dxf.reader.DxfGroups;
import de.escape.quincunx.dxf.reader.DxfLAYER;
import de.escape.quincunx.dxf.reader.DxfLTYPE;
import de.escape.quincunx.dxf.reader.DxfReporter;
import de.escape.quincunx.dxf.reader.DxfSTYLE;
import de.escape.quincunx.dxf.reader.DxfSection;
import de.escape.quincunx.dxf.reader.DxfTable;
import de.escape.quincunx.dxf.reader.DxfTableCollector;
import java.util.Enumeration;
import java.util.Hashtable;

public class DxfTables
extends DxfSection
implements DxfTableCollector {
    static final byte NOT_ACTIVE = -1;
    static final byte LAYER = 0;
    static final byte LTYPE = 1;
    static final byte STYLE = 2;
    static final byte MAX_TABLES = 3;
    protected byte activeTable = (byte)-1;
    protected Hashtable[] table = new Hashtable[3];

    public void read(DxfGroups grp, DxfReporter reporter) throws DxfException {
        while (true) {
            int tableLen;
            block5: {
                grp.read();
                String code = grp.valToString();
                if (grp.number != 0 || !"TABLE".equals(code)) {
                    if ("ENDSEC".equals(code)) break;
                    throw new DxfException("err!GrpInTables", new String[]{String.valueOf(grp.getLineNr())});
                }
                grp.read();
                code = grp.valToString();
                if (grp.number != 2) {
                    throw new DxfException("err!GrpInTables", new String[]{String.valueOf(grp.getLineNr())});
                }
                this.activeTable = "LAYER".equals(code) ? (byte)0 : ("LTYPE".equals(code) ? (byte)1 : ("STYLE".equals(code) ? (byte)2 : (byte)-1));
                tableLen = -1;
                do {
                    grp.read();
                    if (grp.number == 70 && (tableLen = grp.valToInt()) <= 0) break block5;
                } while (grp.number != 0);
                grp.unread();
            }
            if (this.activeTable != -1) {
                tableLen = tableLen > 1 ? (int)(1.5 * (double)tableLen) : 5;
                this.table[this.activeTable] = new Hashtable(tableLen);
            }
            grp.readTables(this);
        }
    }

    void createLayer0(DxfFile file) {
        if (this.table[0] == null) {
            this.table[0] = new Hashtable(1);
        }
        DxfLAYER layer0 = new DxfLAYER("0");
        layer0.finishRead(file);
        this.activeTable = 0;
        try {
            this.addTable(layer0);
        }
        catch (DxfException dxfException) {}
    }

    void createLtypeContinuous(DxfFile file) {
        if (this.table[1] == null) {
            this.table[1] = new Hashtable(1);
        }
        DxfLTYPE conti = new DxfLTYPE();
        conti.finishRead(file);
        this.activeTable = 1;
        try {
            this.addTable(conti);
        }
        catch (DxfException dxfException) {}
    }

    void createStyleStd(DxfFile file) {
        if (this.table[2] == null) {
            this.table[2] = new Hashtable(1);
        }
        DxfSTYLE std = new DxfSTYLE();
        std.finishRead(file);
        this.activeTable = (byte)2;
        try {
            this.addTable(std);
        }
        catch (DxfException dxfException) {}
    }

    public boolean addTable(DxfTable tab) throws DxfException {
        if (this.activeTable == -1) {
            throw new DxfException("err!Internal");
        }
        this.table[this.activeTable].put(tab.name, tab);
        return true;
    }

    public DxfLAYER getLayer(String name, boolean refer) {
        if (this.table[0] == null) {
            this.table[0] = new Hashtable(1);
        }
        if (name != null) {
            DxfLAYER l = (DxfLAYER)this.table[0].get(name = name.toUpperCase());
            if (l == null && refer) {
                l = new DxfLAYER(name);
                this.table[0].put(name, l);
            }
            if (refer && l != null) {
                l.setReferenced();
            }
            return l;
        }
        return null;
    }

    public DxfLAYER getLayer(String name) {
        return this.getLayer(name, false);
    }

    public DxfLTYPE getLtype(String name) {
        name = name == null ? "CONTINUOUS" : name.toUpperCase();
        if (this.table[1] != null) {
            DxfLTYPE s = (DxfLTYPE)this.table[1].get(name);
            if (s != null) {
                s.setReferenced();
                return s;
            }
            if (name.equals("CONTINUOUS")) {
                return null;
            }
            return this.getLtype("CONTINUOUS");
        }
        return null;
    }

    public DxfLTYPE[] getLtypes() {
        if (this.table[1] != null) {
            DxfLTYPE[] ret = new DxfLTYPE[this.table[1].size()];
            int l = 0;
            Enumeration e = this.table[1].elements();
            while (e.hasMoreElements()) {
                ret[l++] = (DxfLTYPE)e.nextElement();
            }
            return ret;
        }
        return null;
    }

    public DxfSTYLE getStyle(String name) {
        name = name == null ? "STANDARD" : name.toUpperCase();
        if (this.table[2] != null) {
            DxfSTYLE s = (DxfSTYLE)this.table[2].get(name);
            if (s != null) {
                s.setReferenced();
                return s;
            }
            if (name.equals("STANDARD")) {
                return null;
            }
            return this.getStyle("STANDARD");
        }
        return null;
    }

    Hashtable getLayerTable() {
        return this.table[0] != null ? this.table[0] : null;
    }

    int getLayerTableLength() {
        return this.table[0] != null ? this.table[0].size() : 0;
    }
}

