/*
 * Decompiled with CFR 0.152.
 */
package git4idea.status;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vcs.impl.projectlevelman.RecursiveFilePathSet;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import git4idea.index.GitFileStatus;
import git4idea.index.GitIndexStatusUtilKt;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitStagingAreaHolder {
    private static final Logger LOG = Logger.getInstance(GitStagingAreaHolder.class);
    public static final Topic<StagingAreaListener> TOPIC = Topic.create((String)"GitStagingAreaHolder change", StagingAreaListener.class);
    private final Project myProject;
    private final GitRepository myRepository;
    private final Object LOCK;
    private final List<GitFileStatus> myRecords;

    public GitStagingAreaHolder(@NotNull GitRepository repository) {
        if (repository == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myRecords = new ArrayList<GitFileStatus>();
        this.myProject = repository.getProject();
        this.myRepository = repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<GitFileStatus> getAllRecords() {
        Object object = this.LOCK;
        // MONITORENTER : object
        ArrayList<GitFileStatus> arrayList = new ArrayList<GitFileStatus>(this.myRecords);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        GitStagingAreaHolder.$$$reportNull$$$0(1);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public GitFileStatus findRecord(@NotNull FilePath path) {
        if (path == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            return (GitFileStatus)ContainerUtil.find(this.myRecords, it -> it.getPath().equals(path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public List<GitConflict> getAllConflicts() {
        Object object = this.LOCK;
        // MONITORENTER : object
        List list = ContainerUtil.mapNotNull(this.myRecords, this::createConflict);
        // MONITOREXIT : object
        if (list != null) return list;
        GitStagingAreaHolder.$$$reportNull$$$0(3);
        return list;
    }

    @Nullable
    public GitConflict findConflict(@NotNull FilePath path) {
        if (path == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(4);
        }
        return this.createConflict(this.findRecord(path));
    }

    @Nullable
    private GitConflict createConflict(@Nullable GitFileStatus record) {
        if (record == null) {
            return null;
        }
        if (!GitIndexStatusUtilKt.isConflicted(record.getIndex(), record.getWorkTree())) {
            return null;
        }
        return new GitConflict(this.myRepository.getRoot(), record.getPath(), GitStagingAreaHolder.getConflictStatus(record.getIndex()), GitStagingAreaHolder.getConflictStatus(record.getWorkTree()));
    }

    @NotNull
    private static GitConflict.Status getConflictStatus(char status) {
        if (status == 'A') {
            GitConflict.Status status2 = GitConflict.Status.ADDED;
            if (status2 == null) {
                GitStagingAreaHolder.$$$reportNull$$$0(5);
            }
            return status2;
        }
        if (status == 'D') {
            GitConflict.Status status3 = GitConflict.Status.DELETED;
            if (status3 == null) {
                GitStagingAreaHolder.$$$reportNull$$$0(6);
            }
            return status3;
        }
        GitConflict.Status status4 = GitConflict.Status.MODIFIED;
        if (status4 == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(7);
        }
        return status4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @ApiStatus.Internal
    public List<GitFileStatus> refresh(@NotNull List<FilePath> dirtyPaths) throws VcsException {
        if (dirtyPaths == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(8);
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        VirtualFile root = this.myRepository.getRoot();
        RecursiveFilePathSet dirtyScope = new RecursiveFilePathSet(true);
        for (FilePath path : dirtyPaths) {
            dirtyScope.add(path);
        }
        List<GitFileStatus> rootRecords = GitIndexStatusUtilKt.getStatus(this.myProject, root, dirtyPaths, true, false, false);
        rootRecords.removeIf(record -> {
            boolean isUnderOurRoot;
            boolean isUnderDirtyScope = GitStagingAreaHolder.isUnder(record, dirtyScope);
            if (!isUnderDirtyScope) {
                return true;
            }
            VirtualFile recordRoot = vcsManager.getVcsRootFor(record.getPath());
            boolean bl = isUnderOurRoot = root.equals(recordRoot) || GitStagingAreaHolder.isSubmoduleStatus(record, recordRoot);
            if (!isUnderOurRoot) {
                LOG.warn(String.format("Ignoring change under another root: %s; root: %s; mapped root: %s", record, root, recordRoot));
                return true;
            }
            return false;
        });
        Object object = this.LOCK;
        synchronized (object) {
            this.myRecords.removeIf(record -> GitStagingAreaHolder.isUnder(record, dirtyScope));
            this.myRecords.addAll(rootRecords);
        }
        ((StagingAreaListener)BackgroundTaskUtil.syncPublisher((Project)this.myProject, TOPIC)).stagingAreaChanged(this.myRepository);
        List<GitFileStatus> list = rootRecords;
        if (list == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean isUnder(@NotNull GitFileStatus record, @NotNull RecursiveFilePathSet dirtyScope) {
        if (record == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(10);
        }
        if (dirtyScope == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(11);
        }
        return dirtyScope.hasAncestor(record.getPath()) || record.getOrigPath() != null && dirtyScope.hasAncestor(record.getOrigPath());
    }

    private static boolean isSubmoduleStatus(@NotNull GitFileStatus record, @Nullable VirtualFile candidateRoot) {
        if (record == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(12);
        }
        if (candidateRoot == null) {
            return false;
        }
        String recordPath = record.getPath().getPath();
        String rootPath = candidateRoot.getPath();
        return recordPath.equals(rootPath);
    }

    @NotNull
    @ApiStatus.Internal
    public static Map<VirtualFile, List<FilePath>> collectDirtyPaths(@NotNull VcsDirtyScope dirtyScope) {
        if (dirtyScope == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(13);
        }
        Project project = dirtyScope.getProject();
        AbstractVcs vcs = dirtyScope.getVcs();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        HashMap<VirtualFile, List<FilePath>> result2 = new HashMap<VirtualFile, List<FilePath>>();
        for (FilePath p : dirtyScope.getRecursivelyDirtyDirectories()) {
            GitStagingAreaHolder.addToPaths(p, result2, vcs, vcsManager);
        }
        for (FilePath p : dirtyScope.getDirtyFilesNoExpand()) {
            GitStagingAreaHolder.addToPaths(p, result2, vcs, vcsManager);
        }
        for (Change c : ChangeListManager.getInstance((Project)project).getAllChanges()) {
            switch (c.getType()) {
                case NEW: 
                case DELETED: 
                case MOVED: {
                    FilePath beforePath;
                    FilePath afterPath = ChangesUtil.getAfterPath((Change)c);
                    if (afterPath != null) {
                        GitStagingAreaHolder.addToPaths(afterPath, result2, vcs, vcsManager);
                    }
                    if ((beforePath = ChangesUtil.getBeforePath((Change)c)) == null) break;
                    GitStagingAreaHolder.addToPaths(beforePath, result2, vcs, vcsManager);
                }
            }
        }
        for (VirtualFile root : result2.keySet()) {
            List paths = (List)result2.get(root);
            GitStagingAreaHolder.removeCommonParents(paths);
        }
        HashMap<VirtualFile, List<FilePath>> hashMap = result2;
        if (hashMap == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(14);
        }
        return hashMap;
    }

    private static void addToPaths(@NotNull FilePath filePath, @NotNull Map<VirtualFile, List<FilePath>> result2, @NotNull AbstractVcs vcs, @NotNull ProjectLevelVcsManager vcsManager) {
        VcsRoot vcsRoot;
        if (filePath == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(15);
        }
        if (result2 == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(16);
        }
        if (vcs == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(17);
        }
        if (vcsManager == null) {
            GitStagingAreaHolder.$$$reportNull$$$0(18);
        }
        if ((vcsRoot = vcsManager.getVcsRootObjectFor(filePath)) != null && vcs.equals((Object)vcsRoot.getVcs())) {
            VirtualFile root = vcsRoot.getPath();
            List paths = result2.computeIfAbsent(root, key -> new ArrayList());
            paths.add(filePath);
        }
    }

    private static void removeCommonParents(List<FilePath> paths) {
        paths.sort(Comparator.comparing(FilePath::getPath));
        FilePath prevPath = null;
        Iterator<FilePath> it = paths.iterator();
        while (it.hasNext()) {
            FilePath path = it.next();
            if (prevPath != null && FileUtil.startsWith((String)path.getPath(), (String)prevPath.getPath(), (boolean)true)) {
                it.remove();
                continue;
            }
            prevPath = path;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/status/GitStagingAreaHolder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyPaths";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/status/GitStagingAreaHolder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRecords";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllConflicts";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictStatus";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "refresh";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "collectDirtyPaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findRecord";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findConflict";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isSubmoduleStatus";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectDirtyPaths";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addToPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface StagingAreaListener {
        public void stagingAreaChanged(@NotNull GitRepository var1);
    }
}

