/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import git4idea.DialogManager;
import java.awt.Component;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHAccountAuthData;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.authentication.ui.BaseLoginDialog;
import org.jetbrains.plugins.github.authentication.ui.GHOAuthLoginDialog;
import org.jetbrains.plugins.github.authentication.ui.GHPasswordTokenLoginDialog;
import org.jetbrains.plugins.github.authentication.ui.GHTokenLoginDialog;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u000fH\u0002\u001a\"\u0010\u0012\u001a\u0004\u0018\u00010\u0011*\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u001a\"\u0010\u0017\u001a\u0004\u0018\u00010\u0011*\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u001a\"\u0010\u0018\u001a\u0004\u0018\u00010\u0011*\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u001a\"\u0010\u0019\u001a\u0004\u0018\u00010\u0011*\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0000\u001a\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a \u0010\u001a\u001a\u00020\u001b*\u00020\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u001a\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"L\u0010\u0000\u001a6\u0012\u0013\u0012\u00110\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0001j\u0002`\t*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u000b\u00a8\u0006\u001c"}, d2={"isLoginUniqueChecker", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "login", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "server", "", "Lorg/jetbrains/plugins/github/authentication/ui/UniqueLoginPredicate;", "Lorg/jetbrains/plugins/github/authentication/GHLoginRequest;", "(Lorg/jetbrains/plugins/github/authentication/GHLoginRequest;)Lkotlin/jvm/functions/Function2;", "configure", "", "dialog", "Lorg/jetbrains/plugins/github/authentication/ui/BaseLoginDialog;", "getAuthData", "Lorg/jetbrains/plugins/github/authentication/GHAccountAuthData;", "loginWithOAuth", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "loginWithOAuthOrToken", "loginWithPasswordOrToken", "loginWithToken", "promptOAuthLogin", "", "intellij.vcs.github"})
public final class GHLoginRequestKt {
    @Nullable
    public static final GHAccountAuthData loginWithPasswordOrToken(@NotNull GHLoginRequest $this$loginWithPasswordOrToken, @Nullable Project project, @Nullable Component parentComponent) {
        GHPasswordTokenLoginDialog dialog2;
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)$this$loginWithPasswordOrToken, (String)"$this$loginWithPasswordOrToken");
            dialog2 = new GHPasswordTokenLoginDialog(project, parentComponent, GHLoginRequestKt.isLoginUniqueChecker($this$loginWithPasswordOrToken), $this$loginWithPasswordOrToken.getText());
            GHLoginRequestKt.configure($this$loginWithPasswordOrToken, dialog2);
            String string = $this$loginWithPasswordOrToken.getPassword();
            if (string == null) break block0;
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            dialog2.setPassword(it);
        }
        return GHLoginRequestKt.getAuthData(dialog2);
    }

    @Nullable
    public static final GHAccountAuthData loginWithToken(@NotNull GHLoginRequest $this$loginWithToken, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkParameterIsNotNull((Object)$this$loginWithToken, (String)"$this$loginWithToken");
        GHTokenLoginDialog dialog2 = new GHTokenLoginDialog(project, parentComponent, GHLoginRequestKt.isLoginUniqueChecker($this$loginWithToken));
        GHLoginRequestKt.configure($this$loginWithToken, dialog2);
        return GHLoginRequestKt.getAuthData(dialog2);
    }

    @Nullable
    public static final GHAccountAuthData loginWithOAuth(@NotNull GHLoginRequest $this$loginWithOAuth, @Nullable Project project, @Nullable Component parentComponent) {
        Intrinsics.checkParameterIsNotNull((Object)$this$loginWithOAuth, (String)"$this$loginWithOAuth");
        GHOAuthLoginDialog dialog2 = new GHOAuthLoginDialog(project, parentComponent, GHLoginRequestKt.isLoginUniqueChecker($this$loginWithOAuth));
        GHLoginRequestKt.configure($this$loginWithOAuth, dialog2);
        return GHLoginRequestKt.getAuthData(dialog2);
    }

    @Nullable
    public static final GHAccountAuthData loginWithOAuthOrToken(@NotNull GHLoginRequest $this$loginWithOAuthOrToken, @Nullable Project project, @Nullable Component parentComponent) {
        GHAccountAuthData gHAccountAuthData;
        Intrinsics.checkParameterIsNotNull((Object)$this$loginWithOAuthOrToken, (String)"$this$loginWithOAuthOrToken");
        switch (GHLoginRequestKt.promptOAuthLogin($this$loginWithOAuthOrToken, project, parentComponent)) {
            case 0: {
                gHAccountAuthData = GHLoginRequestKt.loginWithOAuth($this$loginWithOAuthOrToken, project, parentComponent);
                break;
            }
            case 1: {
                gHAccountAuthData = GHLoginRequestKt.loginWithToken($this$loginWithOAuthOrToken, project, parentComponent);
                break;
            }
            default: {
                gHAccountAuthData = null;
            }
        }
        return gHAccountAuthData;
    }

    private static final Function2<String, GithubServerPath, Boolean> isLoginUniqueChecker(@NotNull GHLoginRequest $this$isLoginUniqueChecker) {
        return (Function2)new Function2<String, GithubServerPath, Boolean>($this$isLoginUniqueChecker){
            final /* synthetic */ GHLoginRequest $this_isLoginUniqueChecker;

            public final boolean invoke(@NotNull String login2, @NotNull GithubServerPath server) {
                Intrinsics.checkParameterIsNotNull((Object)login2, (String)"login");
                Intrinsics.checkParameterIsNotNull((Object)server, (String)"server");
                return !this.$this_isLoginUniqueChecker.isCheckLoginUnique() || GithubAuthenticationManager.Companion.getInstance().isAccountUnique$intellij_vcs_github(login2, server);
            }
            {
                this.$this_isLoginUniqueChecker = gHLoginRequest;
                super(2);
            }
        };
    }

    private static final void configure(@NotNull GHLoginRequest $this$configure, BaseLoginDialog dialog2) {
        block3: {
            Object it;
            boolean bl;
            boolean bl2;
            Object object;
            Throwable throwable = $this$configure.getError();
            if (throwable != null) {
                object = throwable;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl3 = false;
                dialog2.setError((Throwable)it);
            }
            GithubServerPath githubServerPath = $this$configure.getServer();
            if (githubServerPath != null) {
                object = githubServerPath;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl4 = false;
                String string = ((GithubServerPath)it).toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
                dialog2.setServer(string, $this$configure.isServerEditable());
            }
            String string = $this$configure.getLogin();
            if (string != null) {
                object = string;
                bl2 = false;
                bl = false;
                it = object;
                boolean bl5 = false;
                dialog2.setLogin((String)it, $this$configure.isLoginEditable());
            }
            String string2 = $this$configure.getToken();
            if (string2 == null) break block3;
            object = string2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl6 = false;
            dialog2.setToken((String)it);
        }
    }

    private static final GHAccountAuthData getAuthData(@NotNull BaseLoginDialog $this$getAuthData) {
        DialogManager.show((DialogWrapper)$this$getAuthData);
        return $this$getAuthData.isOK() ? new GHAccountAuthData(GithubAccountManager.Companion.createAccount($this$getAuthData.getLogin(), $this$getAuthData.getServer()), $this$getAuthData.getLogin(), $this$getAuthData.getToken()) : null;
    }

    private static final int promptOAuthLogin(@NotNull GHLoginRequest $this$promptOAuthLogin, Project project, Component parentComponent) {
        int n;
        if (parentComponent != null) {
            n = GHLoginRequestKt.promptOAuthLogin($this$promptOAuthLogin, parentComponent);
        } else {
            Project project2 = project;
            if (project2 == null) {
                Intrinsics.throwNpe();
            }
            n = GHLoginRequestKt.promptOAuthLogin($this$promptOAuthLogin, project2);
        }
        return n;
    }

    private static final int promptOAuthLogin(@NotNull GHLoginRequest $this$promptOAuthLogin, Project project) {
        String string = $this$promptOAuthLogin.getText();
        if (string == null) {
            string = GithubBundle.message("dialog.message.login.to.continue", new Object[0]);
        }
        return Messages.showYesNoCancelDialog((Project)project, (String)string, (String)GithubBundle.message("login.to.github", new Object[0]), (String)GithubBundle.message("login.via.github.action", new Object[0]), (String)GithubBundle.message("button.use.token", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon());
    }

    private static final int promptOAuthLogin(@NotNull GHLoginRequest $this$promptOAuthLogin, Component parentComponent) {
        String string = $this$promptOAuthLogin.getText();
        if (string == null) {
            string = GithubBundle.message("dialog.message.login.to.continue", new Object[0]);
        }
        return Messages.showYesNoCancelDialog((Component)parentComponent, (String)string, (String)GithubBundle.message("login.to.github", new Object[0]), (String)GithubBundle.message("login.via.github.action", new Object[0]), (String)GithubBundle.message("button.use.token", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getWarningIcon());
    }
}

