/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.issueLinks.TreeLinkMouseListener;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangesBrowserChangeNode
extends ChangesBrowserNode<Change>
implements TreeLinkMouseListener.HaveTooltip {
    @Nullable
    private final Project myProject;
    @Nullable
    private final ChangeNodeDecorator myDecorator;

    protected ChangesBrowserChangeNode(@Nullable Project project, @NotNull Change userObject, @Nullable ChangeNodeDecorator decorator) {
        if (userObject == null) {
            ChangesBrowserChangeNode.$$$reportNull$$$0(0);
        }
        super(userObject);
        this.myProject = project;
        this.myDecorator = decorator;
    }

    @Override
    protected boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    protected boolean isDirectory() {
        return ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).isDirectory();
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        if (renderer == null) {
            ChangesBrowserChangeNode.$$$reportNull$$$0(1);
        }
        Change change = (Change)this.getUserObject();
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        VirtualFile file = filePath.getVirtualFile();
        if (this.myDecorator != null) {
            this.myDecorator.preDecorate(change, renderer, renderer.isShowFlatten());
        }
        renderer.appendFileName(file, filePath.getName(), change.getFileStatus().getColor());
        String originText = change.getOriginText(this.myProject);
        if (originText != null) {
            renderer.append(FontUtil.spaceAndThinSpace() + originText, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (renderer.isShowFlatten()) {
            this.appendParentPath(renderer, filePath.getParentPath());
        }
        this.appendSwitched(renderer, file);
        if (!renderer.isShowFlatten() && this.getFileCount() != 1 || this.getDirectoryCount() != 0) {
            this.appendCount(renderer);
        }
        this.setIcon(change, filePath, renderer);
        if (this.myDecorator != null) {
            this.myDecorator.decorate(change, (SimpleColoredComponent)renderer, renderer.isShowFlatten());
        }
    }

    private void setIcon(@NotNull Change change, @NotNull FilePath filePath, @NotNull ChangesBrowserNodeRenderer renderer) {
        Icon additionalIcon;
        if (change == null) {
            ChangesBrowserChangeNode.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            ChangesBrowserChangeNode.$$$reportNull$$$0(3);
        }
        if (renderer == null) {
            ChangesBrowserChangeNode.$$$reportNull$$$0(4);
        }
        if ((additionalIcon = change.getAdditionalIcon()) != null) {
            renderer.setIcon(additionalIcon);
            return;
        }
        renderer.setIcon(filePath, filePath.isDirectory() || !this.isLeaf());
    }

    private void appendSwitched(@NotNull ChangesBrowserNodeRenderer renderer, @Nullable VirtualFile file) {
        String branch;
        if (renderer == null) {
            ChangesBrowserChangeNode.$$$reportNull$$$0(5);
        }
        if (file != null && this.myProject != null && !this.myProject.isDefault() && !this.myProject.isDisposed() && (branch = ChangeListManager.getInstance((Project)this.myProject).getSwitchedBranch(file)) != null) {
            renderer.append(FontUtil.spaceAndThinSpace() + "[switched to " + branch + "]", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    public String getTooltip() {
        return ((Change)this.getUserObject()).getDescription();
    }

    @Override
    public String getTextPresentation() {
        return ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).getName();
    }

    @Override
    public String toString() {
        return FileUtil.toSystemDependentName((String)ChangesUtil.getFilePath((Change)((Change)this.getUserObject())).getPath());
    }

    @Override
    public int getSortWeight() {
        return 7;
    }

    @Override
    public int compareUserObjects(Change o2) {
        return ChangesComparator.getInstance(true).compare((Change)this.getUserObject(), o2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userObject";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/ui/ChangesBrowserChangeNode";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "render";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setIcon";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "appendSwitched";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

