/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.roots.VcsRootScanner;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsRootDetectorImpl
implements VcsRootDetector {
    private static final Logger LOG = Logger.getInstance(VcsRootDetectorImpl.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myVcsManager;
    @Nullable
    private Collection<DetectedVcsRoot> myDetectedRoots;
    @NotNull
    private final Object LOCK;

    public VcsRootDetectorImpl(@NotNull Project project) {
        if (project == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<VcsRoot> detect() {
        Object object = this.LOCK;
        // MONITORENTER : object
        Collection<VcsRoot> roots = this.scanForRootsInContentRoots();
        this.myDetectedRoots = ContainerUtil.map(roots, x$0 -> new DetectedVcsRoot((VcsRoot)x$0));
        Collection<VcsRoot> collection = roots;
        // MONITOREXIT : object
        if (collection != null) return collection;
        VcsRootDetectorImpl.$$$reportNull$$$0(1);
        return collection;
    }

    @NotNull
    public Collection<VcsRoot> detect(@Nullable VirtualFile startDir) {
        if (startDir == null) {
            List<VcsRoot> list = Collections.emptyList();
            if (list == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(2);
            }
            return list;
        }
        Set<VcsRoot> set = Collections.unmodifiableSet(this.scanForDirectory(startDir));
        if (set == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<VcsRoot> getOrDetect() {
        Object object = this.LOCK;
        // MONITORENTER : object
        if (this.myDetectedRoots != null) {
            List list = ContainerUtil.mapNotNull(this.myDetectedRoots, it -> it.toVcsRoot(this.myProject));
            // MONITOREXIT : object
            if (list != null) return list;
            VcsRootDetectorImpl.$$$reportNull$$$0(4);
            return list;
        }
        Collection<VcsRoot> collection = this.detect();
        // MONITOREXIT : object
        if (collection != null) return collection;
        VcsRootDetectorImpl.$$$reportNull$$$0(5);
        return collection;
    }

    @NotNull
    private Set<VcsRoot> scanForDirectory(@NotNull VirtualFile dirToScan) {
        if (dirToScan == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(6);
        }
        if (!VcsRootChecker.EXTENSION_POINT_NAME.hasAnyExtensions()) {
            Set<VcsRoot> set = Collections.emptySet();
            if (set == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(7);
            }
            return set;
        }
        HashSet<VcsRoot> detectedRoots = new HashSet<VcsRoot>(this.scanForRootsInsideDir(dirToScan, null));
        detectedRoots.addAll(this.scanForRootsAboveDirs(Collections.singletonList(dirToScan), detectedRoots));
        HashSet<VcsRoot> hashSet = detectedRoots;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    private Collection<VcsRoot> scanForRootsInContentRoots() {
        if (this.myProject.isDisposed()) {
            List<VcsRoot> list = Collections.emptyList();
            if (list == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        if (!VcsRootChecker.EXTENSION_POINT_NAME.hasAnyExtensions()) {
            List<VcsRoot> list = Collections.emptyList();
            if (list == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList contentRoots = ContainerUtil.newArrayList((Object[])ProjectRootManager.getInstance((Project)this.myProject).getContentRoots());
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null && !contentRoots.contains(baseDir)) {
            contentRoots.add(baseDir);
        }
        HashSet<VcsRoot> detectedRoots = new HashSet<VcsRoot>();
        HashSet<VirtualFile> skipDirs = new HashSet<VirtualFile>();
        ContainerUtil.sort((List)contentRoots, Comparator.comparing(root -> -root.getPath().length()));
        for (VirtualFile dir : contentRoots) {
            detectedRoots.addAll(this.scanForRootsInsideDir(dir, skipDirs));
            skipDirs.add(dir);
        }
        detectedRoots.addAll(this.scanForRootsAboveDirs(contentRoots, detectedRoots));
        HashSet<VcsRoot> hashSet = detectedRoots;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(11);
        }
        return hashSet;
    }

    private Set<VcsRoot> scanForRootsInsideDir(@NotNull VirtualFile root, @Nullable Set<VirtualFile> skipDirs) {
        if (root == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(12);
        }
        HashSet<VcsRoot> roots = new HashSet<VcsRoot>();
        VcsRootScanner.visitDirsRecursivelyWithoutExcluded(this.myProject, ProjectRootManager.getInstance((Project)this.myProject), root, dir -> {
            if (skipDirs != null && skipDirs.contains(dir)) {
                return VirtualFileVisitor.SKIP_CHILDREN;
            }
            VcsRoot vcsRoot = this.getVcsRootFor((VirtualFile)dir);
            if (vcsRoot != null) {
                LOG.debug("Found VCS " + vcsRoot.getVcs() + " in " + vcsRoot.getPath() + " under " + root.getPath());
                roots.add(vcsRoot);
            }
            return VirtualFileVisitor.CONTINUE;
        });
        return roots;
    }

    @NotNull
    private Collection<VcsRoot> scanForRootsAboveDirs(@NotNull Collection<VirtualFile> dirsToScan, @NotNull Collection<VcsRoot> detectedRoots) {
        if (dirsToScan == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(13);
        }
        if (detectedRoots == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(14);
        }
        HashSet<VcsRoot> result2 = new HashSet<VcsRoot>();
        HashSet<VirtualFile> skipDirs = new HashSet<VirtualFile>();
        for (VcsRoot root : detectedRoots) {
            skipDirs.add(root.getPath());
        }
        ContainerUtil.addIfNotNull(skipDirs, (Object)VfsUtil.getUserHomeDir());
        for (VirtualFile dir : dirsToScan) {
            VcsRoot root = this.scanForRootsAboveDir(dir, skipDirs);
            if (root == null) continue;
            result2.add(root);
        }
        HashSet<VcsRoot> hashSet = result2;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    @Nullable
    private VcsRoot scanForRootsAboveDir(@NotNull VirtualFile root, @NotNull Set<VirtualFile> skipDirs) {
        Pattern ignorePattern;
        if (root == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(16);
        }
        if (skipDirs == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(17);
        }
        if (VcsRootScanner.isUnderIgnoredDirectory(this.myProject, ignorePattern = VcsRootScanner.parseDirIgnorePattern(), root)) {
            return null;
        }
        for (VirtualFile parent = root; parent != null && skipDirs.add(parent); parent = parent.getParent()) {
            VcsRoot vcsRoot = this.getVcsRootFor(parent, root);
            if (vcsRoot == null) continue;
            LOG.debug("Found VCS " + vcsRoot.getVcs() + " in " + vcsRoot.getPath() + " above " + root.getPath());
            return vcsRoot;
        }
        return null;
    }

    @Nullable
    private VcsRoot getVcsRootFor(@NotNull VirtualFile dir) {
        if (dir == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(18);
        }
        return this.getVcsRootFor(dir, null);
    }

    @Nullable
    private VcsRoot getVcsRootFor(@NotNull VirtualFile maybeRoot, @Nullable VirtualFile dirToCheckForIgnore) {
        if (maybeRoot == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(19);
        }
        ProgressManager.checkCanceled();
        String path2 = maybeRoot.getPath();
        return (VcsRoot)VcsRootChecker.EXTENSION_POINT_NAME.computeSafeIfAny(checker -> {
            if (checker.isRoot(path2) && (dirToCheckForIgnore == null || !checker.isIgnored(maybeRoot, dirToCheckForIgnore))) {
                AbstractVcs vcs = this.myVcsManager.findVcsByName(checker.getSupportedVcs().getName());
                if (vcs != null) {
                    return new VcsRoot(vcs, maybeRoot);
                }
                return null;
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirToScan";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsToScan";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoots";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipDirs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDetect";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForDirectory";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForRootsInContentRoots";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForRootsAboveDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "scanForDirectory";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "scanForRootsInsideDir";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "scanForRootsAboveDirs";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "scanForRootsAboveDir";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DetectedVcsRoot {
        @Nullable
        private final String myVcsName;
        @NotNull
        private final VirtualFile myPath;

        private DetectedVcsRoot(@NotNull VcsRoot root) {
            if (root == null) {
                DetectedVcsRoot.$$$reportNull$$$0(0);
            }
            AbstractVcs vcs = root.getVcs();
            this.myVcsName = vcs != null ? vcs.getName() : null;
            this.myPath = root.getPath();
        }

        @Nullable
        public VcsRoot toVcsRoot(@NotNull Project project) {
            if (project == null) {
                DetectedVcsRoot.$$$reportNull$$$0(1);
            }
            if (this.myVcsName == null) {
                return null;
            }
            AbstractVcs vcs = AllVcses.getInstance(project).getByName(this.myVcsName);
            return vcs != null ? new VcsRoot(vcs, this.myPath) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl$DetectedVcsRoot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toVcsRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

