/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.LocalTimeCounter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class BinaryLightVirtualFile
extends LightVirtualFileBase {
    private byte[] myContent;

    public BinaryLightVirtualFile(String name) {
        this(name, ArrayUtilRt.EMPTY_BYTE_ARRAY);
    }

    public BinaryLightVirtualFile(String name, byte @NotNull [] content) {
        if (content == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(0);
        }
        this(name, null, content, LocalTimeCounter.currentTime());
    }

    public BinaryLightVirtualFile(String name, FileType fileType, byte @NotNull [] content) {
        if (content == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(1);
        }
        this(name, fileType, content, LocalTimeCounter.currentTime());
    }

    public BinaryLightVirtualFile(String name, FileType fileType, byte @NotNull [] content, long modificationStamp) {
        if (content == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(2);
        }
        super(name, fileType, modificationStamp);
        this.myContent = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        this.setContent(content);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return VfsUtilCore.byteStreamSkippingBOM(this.myContent, this);
    }

    @Override
    @NotNull
    public OutputStream getOutputStream(Object requestor, final long newModificationStamp, long newTimeStamp) throws IOException {
        OutputStream outputStream = VfsUtilCore.outputStreamAddingBOM(new ByteArrayOutputStream(){

            @Override
            public void close() {
                BinaryLightVirtualFile.this.setModificationStamp(newModificationStamp);
                BinaryLightVirtualFile.this.setContent(this.toByteArray());
            }
        }, this);
        if (outputStream == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(3);
        }
        return outputStream;
    }

    @Override
    public byte @NotNull [] contentsToByteArray() throws IOException {
        if (this.myContent == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(4);
        }
        return this.myContent;
    }

    private void setContent(byte @NotNull [] content) {
        if (content == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(5);
        }
        this.myContent = content;
    }

    public byte @NotNull [] getContent() {
        if (this.myContent == null) {
            BinaryLightVirtualFile.$$$reportNull$$$0(6);
        }
        return this.myContent;
    }

    @Override
    public String toString() {
        return "BinaryLightVirtualFile: " + this.getPresentableUrl();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/BinaryLightVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/BinaryLightVirtualFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

