/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CompositeShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.BrowseFolderRunnable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

class RunConfigurationStorageUi {
    private final JPanel myMainPanel;
    private final ComboBox<String> myPathComboBox;
    @NonNls
    private final @SystemIndependent String myDotIdeaStoragePath;
    private Runnable myClosePopupAction;

    RunConfigurationStorageUi(@NotNull Project project, @NotNull String dotIdeaStoragePath, @NotNull Function<String, String> pathToErrorMessage, @NotNull Disposable uiDisposable) {
        if (project == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(0);
        }
        if (dotIdeaStoragePath == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(1);
        }
        if (pathToErrorMessage == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(2);
        }
        if (uiDisposable == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(3);
        }
        this.myDotIdeaStoragePath = dotIdeaStoragePath;
        this.myPathComboBox = this.createPathComboBox(project, uiDisposable);
        ComponentValidator validator = new ComponentValidator(uiDisposable);
        JTextComponent comboBoxEditorComponent = (JTextComponent)this.myPathComboBox.getEditor().getEditorComponent();
        validator.withValidator(() -> {
            String errorMessage = (String)pathToErrorMessage.fun((Object)this.getPath());
            return errorMessage != null ? new ValidationInfo(errorMessage, this.myPathComboBox) : null;
        }).andRegisterOnDocumentListener(comboBoxEditorComponent).installOn((JComponent)comboBoxEditorComponent);
        JPanel comboBoxPanel = UI.PanelFactory.panel(this.myPathComboBox).withLabel(ExecutionBundle.message((String)"run.configuration.store.in", (Object[])new Object[0])).moveLabelOnTop().withComment(RunConfigurationStorageUi.getCompatibilityHintText(project), false).withCommentHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                this.myPathComboBox.getEditor().setItem(FileUtil.toSystemDependentName((String)this.myDotIdeaStoragePath));
            }
        }).createPanel();
        JButton doneButton = new JButton(ExecutionBundle.message((String)"run.configuration.done.button", (Object[])new Object[0]));
        doneButton.addActionListener(e -> this.myClosePopupAction.run());
        JPanel doneButtonPanel = new JPanel(new BorderLayout());
        doneButtonPanel.add((Component)doneButton, "East");
        this.myMainPanel = FormBuilder.createFormBuilder().addComponent((JComponent)comboBoxPanel).addComponent((JComponent)doneButtonPanel).getPanel();
        this.myMainPanel.setFocusCycleRoot(true);
        this.myMainPanel.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
        DumbAwareAction.create(e -> {
            if (this.myPathComboBox.isPopupVisible()) {
                this.myPathComboBox.setPopupVisible(false);
            } else {
                validator.updateInfo(null);
                this.myClosePopupAction.run();
            }
        }).registerCustomShortcutSet((ShortcutSet)new CompositeShortcutSet(new ShortcutSet[]{CommonShortcuts.ENTER, CommonShortcuts.ESCAPE}), (JComponent)this.myMainPanel, uiDisposable);
    }

    @NotNull
    private ComboBox<String> createPathComboBox(final @NotNull Project project, @NotNull Disposable uiDisposable) {
        if (project == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(4);
        }
        if (uiDisposable == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(5);
        }
        ComboBox comboBox2 = new ComboBox(JBUI.scale((int)500));
        comboBox2.setEditable(true);
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, true, false, false, false, false){

            public boolean isFileVisible(VirtualFile file2, boolean showHiddenFiles) {
                if (file2.getPath().equals(RunConfigurationStorageUi.this.myDotIdeaStoragePath)) {
                    return true;
                }
                return file2.isDirectory() && super.isFileVisible(file2, showHiddenFiles);
            }

            public boolean isFileSelectable(VirtualFile file2) {
                if (file2.getPath().equals(RunConfigurationStorageUi.this.myDotIdeaStoragePath)) {
                    return true;
                }
                return file2.isDirectory() && super.isFileSelectable(file2) && ProjectFileIndex.getInstance((Project)project).isInContent(file2) && !file2.getPath().endsWith("/.idea") && !file2.getPath().contains("/.idea/");
            }
        };
        BrowseFolderRunnable<ComboBox<String>> selectFolderAction = new BrowseFolderRunnable<ComboBox<String>>(null, null, project, descriptor2, comboBox2, TextComponentAccessor.STRING_COMBOBOX_WHOLE_TEXT){};
        comboBox2.initBrowsableEditor((Runnable)selectFolderAction, uiDisposable);
        ComboBox comboBox3 = comboBox2;
        if (comboBox3 == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(6);
        }
        return comboBox3;
    }

    @NotNull
    private static String getCompatibilityHintText(@NotNull Project project) {
        if (project == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(7);
        }
        String oldStorage = ProjectKt.isDirectoryBased(project) ? FileUtil.toSystemDependentName((String)".idea/runConfigurations") : PathUtil.getFileName((String)StringUtil.notNullize((String)project.getProjectFilePath()));
        String string = ExecutionBundle.message((String)"run.configuration.storage.compatibility.hint", (Object[])new Object[]{oldStorage});
        if (string == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(8);
        }
        return string;
    }

    JPanel getMainPanel() {
        return this.myMainPanel;
    }

    void reset(@NotNull @SystemIndependent String folderPath, Collection<String> pathsToSuggest, @NotNull Runnable closePopupAction) {
        if (folderPath == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(9);
        }
        if (closePopupAction == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(10);
        }
        this.myPathComboBox.setSelectedItem((Object)FileUtil.toSystemDependentName((String)folderPath));
        for (String s : pathsToSuggest) {
            this.myPathComboBox.addItem((Object)FileUtil.toSystemDependentName((String)s));
        }
        this.myClosePopupAction = closePopupAction;
    }

    @NotNull
    String getPath() {
        String string = StringUtil.trimTrailing((String)FileUtil.toSystemIndependentName((String)this.myPathComboBox.getEditor().getItem().toString().trim()), (char)'/');
        if (string == null) {
            RunConfigurationStorageUi.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotIdeaStoragePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToErrorMessage";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiDisposable";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/impl/RunConfigurationStorageUi";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closePopupAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/impl/RunConfigurationStorageUi";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathComboBox";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibilityHintText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createPathComboBox";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibilityHintText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

