/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.FrameworkType;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.io.PathKt;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class FrameworkDetectorRegistryImpl
extends FrameworkDetectorRegistry
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FrameworkDetectorRegistryImpl.class);
    private static final int REGISTRY_VERSION = 0;
    private Object2IntMap<String> myDetectorIds;
    private Int2ObjectMap<FrameworkDetector> myDetectorById;
    private MultiMap<FileType, Integer> myDetectorsByFileType;
    private int myDetectorsVersion;
    private volatile MultiMap<FileType, Pair<ElementPattern<FileContent>, Integer>> myDetectorsMap;
    private volatile Set<FileType> myAcceptedTypes;
    private final AtomicInteger myNextId = new AtomicInteger();

    public FrameworkDetectorRegistryImpl() {
        this.loadDetectors();
        FrameworkDetector.EP_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FrameworkDetector>(){

            public void extensionAdded(@NotNull FrameworkDetector detector, @NotNull PluginDescriptor pluginDescriptor) {
                if (detector == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                int id2 = FrameworkDetectorRegistryImpl.this.myNextId.getAndIncrement();
                FrameworkDetectorRegistryImpl.this.myDetectorIds.put((Object)detector.getDetectorId(), id2);
                FrameworkDetectorRegistryImpl.this.myDetectorById.put(id2, (Object)detector);
                FrameworkDetectorRegistryImpl.this.myDetectorsByFileType.putValue((Object)detector.getFileType(), (Object)id2);
                FrameworkDetectorRegistryImpl.this.onDetectorsChanged();
            }

            public void extensionRemoved(@NotNull FrameworkDetector detector, @NotNull PluginDescriptor pluginDescriptor) {
                if (detector == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (FrameworkDetectorRegistryImpl.this.myDetectorIds.containsKey((Object)detector.getDetectorId())) {
                    int id2 = FrameworkDetectorRegistryImpl.this.myDetectorIds.removeInt((Object)detector.getDetectorId());
                    FrameworkDetectorRegistryImpl.this.myDetectorById.remove(id2);
                    FrameworkDetectorRegistryImpl.this.myDetectorsByFileType.remove((Object)detector.getFileType(), (Object)id2);
                    FrameworkDetectorRegistryImpl.this.onDetectorsChanged();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "detector";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, (Disposable)this);
        this.saveDetectors();
    }

    private void loadDetectors() {
        HashMap<String, FrameworkDetector> newDetectors = new HashMap<String, FrameworkDetector>();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            newDetectors.put(detector.getDetectorId(), detector);
        }
        this.myDetectorIds = new Object2IntOpenHashMap();
        Path file2 = FrameworkDetectorRegistryImpl.getDetectorsRegistryFile();
        int maxId = 0;
        if (Files.exists(file2, new LinkOption[0])) {
            LOG.debug("loading framework detectors registry from " + file2.toAbsolutePath());
            ArrayList<String> unknownIds = new ArrayList<String>();
            boolean versionChanged = false;
            try (DataInputStream input = new DataInputStream(new BufferedInputStream(Files.newInputStream(file2, new OpenOption[0])));){
                input.readInt();
                this.myDetectorsVersion = input.readInt();
                int size = input.readInt();
                while (size-- > 0) {
                    String stringId = input.readUTF();
                    int intId = input.readInt();
                    maxId = Math.max(maxId, intId);
                    int version2 = input.readInt();
                    FrameworkDetector detector = (FrameworkDetector)newDetectors.remove(stringId);
                    if (detector != null) {
                        if (version2 != detector.getDetectorVersion()) {
                            LOG.info("Version of framework detector '" + stringId + "' changed: " + version2 + " -> " + detector.getDetectorVersion());
                            versionChanged = true;
                        }
                        this.myDetectorIds.put((Object)stringId, intId);
                        continue;
                    }
                    unknownIds.add(stringId);
                }
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            if (!unknownIds.isEmpty()) {
                LOG.debug("Unknown framework detectors: " + unknownIds);
            }
            if (versionChanged || !newDetectors.isEmpty()) {
                if (!newDetectors.isEmpty()) {
                    LOG.info("New framework detectors: " + newDetectors.keySet());
                }
                ++this.myDetectorsVersion;
                LOG.info("Framework detection index version changed to " + this.myDetectorsVersion);
            }
        }
        this.myNextId.set(maxId + 1);
        for (String newDetector : newDetectors.keySet()) {
            this.myDetectorIds.put((Object)newDetector, this.myNextId.getAndIncrement());
        }
        this.myDetectorById = new Int2ObjectOpenHashMap();
        this.myDetectorsByFileType = new MultiMap();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            int id2 = this.myDetectorIds.getInt((Object)detector.getDetectorId());
            this.myDetectorsByFileType.putValue((Object)detector.getFileType(), (Object)id2);
            this.myDetectorById.put(id2, (Object)detector);
            LOG.debug("'" + detector.getDetectorId() + "' framework detector: id = " + id2);
        }
    }

    private void saveDetectors() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Path file2 = FrameworkDetectorRegistryImpl.getDetectorsRegistryFile();
        try (DataOutputStream output = new DataOutputStream(new BufferedOutputStream(PathKt.outputStream((Path)file2)));){
            output.writeInt(0);
            output.writeInt(this.myDetectorsVersion);
            FrameworkDetector[] detectors = (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions();
            output.writeInt(detectors.length);
            for (FrameworkDetector detector : detectors) {
                output.writeUTF(detector.getDetectorId());
                output.writeInt(this.myDetectorIds.getInt((Object)detector.getDetectorId()));
                output.writeInt(detector.getDetectorVersion());
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    @Override
    @NotNull
    public MultiMap<FileType, Pair<ElementPattern<FileContent>, Integer>> getDetectorsMap() {
        MultiMap<FileType, Pair<ElementPattern<FileContent>, Integer>> cached = this.myDetectorsMap;
        if (cached != null) {
            MultiMap<FileType, Pair<ElementPattern<FileContent>, Integer>> multiMap = cached;
            if (multiMap == null) {
                FrameworkDetectorRegistryImpl.$$$reportNull$$$0(0);
            }
            return multiMap;
        }
        MultiMap detectorsMap = new MultiMap();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            detectorsMap.putValue((Object)detector.getFileType(), (Object)Pair.create((Object)detector.createSuitableFilePattern(), (Object)this.getDetectorId(detector)));
        }
        this.myDetectorsMap = detectorsMap;
        MultiMap multiMap = detectorsMap;
        if (multiMap == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(1);
        }
        return multiMap;
    }

    @Override
    @NotNull
    public Set<FileType> getAcceptedFileTypes() {
        Set<FileType> cached = this.myAcceptedTypes;
        if (cached != null) {
            Set<FileType> set = cached;
            if (set == null) {
                FrameworkDetectorRegistryImpl.$$$reportNull$$$0(2);
            }
            return set;
        }
        HashSet<FileType> acceptedTypes = new HashSet<FileType>();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            acceptedTypes.add(detector.getFileType());
        }
        this.myAcceptedTypes = acceptedTypes;
        HashSet<FileType> hashSet = acceptedTypes;
        if (hashSet == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    private void onDetectorsChanged() {
        this.myAcceptedTypes = null;
        this.myDetectorsMap = null;
        ++this.myDetectorsVersion;
        this.saveDetectors();
    }

    private static Path getDetectorsRegistryFile() {
        return FrameworkDetectorRegistryImpl.getDetectionDirPath().resolve("detectors-registry.dat");
    }

    @NotNull
    public static Path getDetectionDirPath() {
        Path path = PathManagerEx.getAppSystemDir().resolve("frameworks").resolve("detection");
        if (path == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(4);
        }
        return path;
    }

    @Override
    public FrameworkType findFrameworkType(@NotNull String typeId) {
        if (typeId == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(5);
        }
        for (FrameworkType frameworkType : this.getFrameworkTypes()) {
            if (!typeId.equals(frameworkType.getId())) continue;
            return frameworkType;
        }
        return null;
    }

    @Override
    @NotNull
    public List<? extends FrameworkType> getFrameworkTypes() {
        ArrayList<FrameworkType> types = new ArrayList<FrameworkType>();
        for (FrameworkDetector detector : (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions()) {
            types.add(detector.getFrameworkType());
        }
        ArrayList<FrameworkType> arrayList = types;
        if (arrayList == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    public int getDetectorsVersion() {
        return this.myDetectorsVersion;
    }

    @Override
    public int getDetectorId(@NotNull FrameworkDetector detector) {
        if (detector == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(7);
        }
        return this.myDetectorIds.getInt((Object)detector.getDetectorId());
    }

    @Override
    public FrameworkDetector getDetectorById(int id2) {
        return (FrameworkDetector)this.myDetectorById.get(id2);
    }

    @Override
    @NotNull
    public Collection<Integer> getDetectorIds(@NotNull FileType fileType) {
        if (fileType == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(8);
        }
        Collection collection = this.myDetectorsByFileType.get((Object)fileType);
        if (collection == null) {
            FrameworkDetectorRegistryImpl.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Override
    public int[] getAllDetectorIds() {
        return this.myDetectorIds.values().toIntArray();
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectorsMap";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedFileTypes";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectionDirPath";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/framework/detection/impl/FrameworkDetectorRegistryImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkTypes";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetectorIds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFrameworkType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDetectorId";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDetectorIds";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

