/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.RecentProjectsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.wm.impl.ProjectFrameBounds;
import com.intellij.openapi.wm.impl.welcomeScreen.WelcomeFrame;
import com.intellij.projectImport.ProjectAttachProcessor;
import com.intellij.ui.IdeUICustomization;
import org.jetbrains.annotations.NotNull;

public final class CloseProjectAction
extends AnAction
implements DumbAware {
    public CloseProjectAction() {
        this.getTemplatePresentation().setText(IdeUICustomization.getInstance().projectMessage("action.close.project.text", new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CloseProjectAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        assert (project != null);
        ProjectFrameBounds.getInstance(project).updateDefaultFrameInfoOnProjectClose();
        ProjectManagerEx.getInstanceEx().closeAndDispose(project);
        RecentProjectsManager.getInstance().updateLastProjectPath();
        WelcomeFrame.showIfNoProjectOpened();
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            CloseProjectAction.$$$reportNull$$$0(1);
        }
        Presentation presentation2 = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        presentation2.setEnabled(project != null);
        if (ProjectAttachProcessor.canAttachToProject() && project != null && ModuleManager.getInstance((Project)project).getModules().length > 1) {
            presentation2.setText(IdeBundle.messagePointer((String)"action.close.projects.in.current.window", (Object[])new Object[0]));
        } else {
            presentation2.setText(IdeUICustomization.getInstance().projectMessage("action.close.project.text", new Object[0]));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/CloseProjectAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

