/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.gdpr;

import com.intellij.ide.Prefs;
import com.intellij.ide.gdpr.Version;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PlatformUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class EndUserAgreement {
    private static final Logger LOG = Logger.getInstance(EndUserAgreement.class);
    private static final String POLICY_TEXT_PROPERTY = "jb.privacy.policy.text";
    private static final String PRIVACY_POLICY_DOCUMENT_NAME = "privacy";
    private static final String PRIVACY_POLICY_EAP_DOCUMENT_NAME = "privacyEap";
    private static final String EULA_DOCUMENT_NAME = "eua";
    private static final String EULA_EAP_DOCUMENT_NAME = "euaEap";
    private static final String PRIVACY_POLICY_CONTENT_FILE_NAME = "Cached";
    private static final String DEFAULT_DOC_NAME = "eua";
    private static final String DEFAULT_DOC_EAP_NAME = "euaEap";
    private static final String ACTIVE_DOC_FILE_NAME = "documentName";
    private static final String ACTIVE_DOC_EAP_FILE_NAME = "documentName.eap";
    private static final String RELATIVE_RESOURCE_PATH = "PrivacyPolicy";
    private static final String VERSION_COMMENT_START = "<!--";
    private static final String VERSION_COMMENT_END = "-->";
    private static final Version MAGIC_VERSION = new Version(999, 999);

    public static Path getDocumentContentFile() {
        return EndUserAgreement.getDocumentContentFile(EndUserAgreement.getDocumentName());
    }

    @NotNull
    private static Path getDocumentContentFile(String docName) {
        Path path = EndUserAgreement.getDataRoot().resolve(PRIVACY_POLICY_DOCUMENT_NAME.equals(docName) ? PRIVACY_POLICY_CONTENT_FILE_NAME : docName + ".cached");
        if (path == null) {
            EndUserAgreement.$$$reportNull$$$0(0);
        }
        return path;
    }

    @NotNull
    private static Path getDocumentNameFile() {
        Path path = EndUserAgreement.getDataRoot().resolve(EndUserAgreement.isEAP() ? ACTIVE_DOC_EAP_FILE_NAME : ACTIVE_DOC_FILE_NAME);
        if (path == null) {
            EndUserAgreement.$$$reportNull$$$0(1);
        }
        return path;
    }

    private static boolean isEAP() {
        return ApplicationInfoImpl.getShadowInstance().isEAP();
    }

    @NotNull
    private static Path getDataRoot() {
        Path path = PathManager.getCommonDataPath().resolve(RELATIVE_RESOURCE_PATH);
        if (path == null) {
            EndUserAgreement.$$$reportNull$$$0(2);
        }
        return path;
    }

    private static String getBundledResourcePath(String docName) {
        return PRIVACY_POLICY_DOCUMENT_NAME.equals(docName) ? "/PrivacyPolicy.html" : "/" + docName + ".html";
    }

    public static void setAccepted(@NotNull Document doc) {
        Version version2;
        if (doc == null) {
            EndUserAgreement.$$$reportNull$$$0(3);
        }
        if ((version2 = doc.getVersion()).isUnknown()) {
            Prefs.remove((String)EndUserAgreement.getAcceptedVersionKey(doc.getName()));
        } else {
            Prefs.put((String)EndUserAgreement.getAcceptedVersionKey(doc.getName()), (String)version2.toString());
        }
    }

    @NotNull
    private static Version getAcceptedVersion(String docName) {
        Version version2 = Version.fromString(Prefs.get((String)EndUserAgreement.getAcceptedVersionKey(docName), null));
        if (version2 == null) {
            EndUserAgreement.$$$reportNull$$$0(4);
        }
        return version2;
    }

    @NotNull
    public static Document getLatestDocument() {
        String docName;
        block5: {
            Document document;
            Document fromProperty;
            String text = System.getProperty(POLICY_TEXT_PROPERTY, null);
            if (text != null && !(fromProperty = EndUserAgreement.loadContent(PRIVACY_POLICY_DOCUMENT_NAME, new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)))).getVersion().isUnknown()) {
                Document document2 = fromProperty;
                if (document2 == null) {
                    EndUserAgreement.$$$reportNull$$$0(5);
                }
                return document2;
            }
            docName = EndUserAgreement.getDocumentName();
            try {
                Document fromFile = EndUserAgreement.loadContent(docName, Files.newInputStream(EndUserAgreement.getDocumentContentFile(docName), new OpenOption[0]));
                if (fromFile.getVersion().isUnknown()) break block5;
                document = fromFile;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (document == null) {
                EndUserAgreement.$$$reportNull$$$0(6);
            }
            return document;
        }
        return EndUserAgreement.loadContent(docName, EndUserAgreement.class.getResourceAsStream(EndUserAgreement.getBundledResourcePath(docName)));
    }

    public static boolean updateCachedContentToLatestBundledVersion() {
        block5: {
            try {
                Document bundled;
                Document cached;
                String docName = EndUserAgreement.getDocumentName();
                Path cacheFile = EndUserAgreement.getDocumentContentFile(docName);
                if (!Files.exists(cacheFile, new LinkOption[0]) || (cached = EndUserAgreement.loadContent(docName, Files.newInputStream(cacheFile, new OpenOption[0]))).getVersion().isUnknown() || (bundled = EndUserAgreement.loadContent(docName, EndUserAgreement.class.getResourceAsStream(EndUserAgreement.getBundledResourcePath(docName)))).getVersion().isUnknown() || !bundled.getVersion().isNewer(cached.getVersion())) break block5;
                try {
                    FileUtil.writeToFile((File)EndUserAgreement.getDocumentContentFile(docName).toFile(), (String)bundled.getText());
                }
                catch (FileNotFoundException e) {
                    LOG.info(e.getMessage());
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public static void update(String docName, String text) {
        try {
            FileUtil.writeToFile((File)EndUserAgreement.getDocumentContentFile(docName).toFile(), (String)text);
            FileUtil.writeToFile((File)EndUserAgreement.getDocumentNameFile().toFile(), (String)docName);
        }
        catch (FileNotFoundException e) {
            LOG.info(e.getMessage());
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    @NotNull
    private static Document loadContent(String docName, InputStream stream) {
        if (stream != null) {
            InputStreamReader reader = new InputStreamReader(stream instanceof ByteArrayInputStream ? stream : new BufferedInputStream(stream), StandardCharsets.UTF_8);
            Document document = new Document(docName, new String(FileUtil.adaptiveLoadText((Reader)reader)));
            ((Reader)reader).close();
            Document document2 = document;
            if (document2 == null) {
                EndUserAgreement.$$$reportNull$$$0(7);
            }
            return document2;
            {
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
        }
        return new Document(docName, "");
    }

    @NotNull
    private static String getDocumentName() {
        block4: {
            String string;
            if (!PlatformUtils.isCommercialEdition()) {
                return EndUserAgreement.isEAP() ? PRIVACY_POLICY_EAP_DOCUMENT_NAME : PRIVACY_POLICY_DOCUMENT_NAME;
            }
            try {
                String docName = new String(Files.readAllBytes(EndUserAgreement.getDocumentNameFile()), StandardCharsets.UTF_8);
                if (StringUtilRt.isEmptyOrSpaces((CharSequence)docName)) break block4;
                string = docName;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                EndUserAgreement.$$$reportNull$$$0(8);
            }
            return string;
        }
        return EndUserAgreement.isEAP() ? "euaEap" : "eua";
    }

    @NotNull
    private static String getAcceptedVersionKey(String docName) {
        if (PRIVACY_POLICY_DOCUMENT_NAME.equals(docName)) {
            return "JetBrains.privacy_policy.accepted_version";
        }
        String keyName = docName;
        if ("euaEap".equals(docName)) {
            keyName = "ij_" + keyName;
        }
        String string = "JetBrains.privacy_policy." + keyName + "_accepted_version";
        if (string == null) {
            EndUserAgreement.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/gdpr/EndUserAgreement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentContentFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentNameFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataRoot";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/gdpr/EndUserAgreement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVersion";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLatestDocument";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAcceptedVersionKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setAccepted";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Document {
        private final String myName;
        private final String myText;
        private final Version myVersion;

        public Document(String name, String text) {
            this.myName = name;
            this.myText = text;
            this.myVersion = Document.parseVersion(text);
        }

        public boolean isPrivacyPolicy() {
            return EndUserAgreement.PRIVACY_POLICY_DOCUMENT_NAME.equals(this.myName) || EndUserAgreement.PRIVACY_POLICY_EAP_DOCUMENT_NAME.equals(this.myName);
        }

        public boolean isAccepted() {
            Version thisVersion = this.getVersion();
            if (thisVersion.isUnknown() || MAGIC_VERSION.equals(thisVersion)) {
                return true;
            }
            Version acceptedByUser = EndUserAgreement.getAcceptedVersion(this.getName());
            return !acceptedByUser.isUnknown() && acceptedByUser.getMajor() >= thisVersion.getMajor();
        }

        public String getName() {
            return this.myName;
        }

        public Version getVersion() {
            return this.myVersion;
        }

        public String getText() {
            return this.myText;
        }

        /*
         * Loose catch block
         */
        @NotNull
        private static Version parseVersion(String text) {
            block11: {
                if (!StringUtil.isEmptyOrSpaces((String)text)) {
                    BufferedReader reader;
                    block10: {
                        int endComment;
                        int startComment;
                        reader = new BufferedReader(new StringReader(text));
                        String line = reader.readLine();
                        if (line == null || (startComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_START)) < 0 || (endComment = line.indexOf(EndUserAgreement.VERSION_COMMENT_END)) <= startComment) break block10;
                        Version version2 = Version.fromString(line.substring(startComment + EndUserAgreement.VERSION_COMMENT_START.length(), endComment).trim());
                        reader.close();
                        Version version3 = version2;
                        if (version3 == null) {
                            Document.$$$reportNull$$$0(0);
                        }
                        return version3;
                    }
                    try {
                        reader.close();
                        break block11;
                        {
                            catch (Throwable throwable) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                    }
                    catch (IOException e) {
                        LOG.info((Throwable)e);
                    }
                }
            }
            Version version4 = Version.UNKNOWN;
            if (version4 == null) {
                Document.$$$reportNull$$$0(1);
            }
            return version4;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/gdpr/EndUserAgreement$Document", "parseVersion"));
        }
    }
}

