/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnmarkRootAction
extends MarkRootActionBase {
    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @Nullable Module module, @NotNull MarkRootActionBase.RootsSelection selection) {
        if (e == null) {
            UnmarkRootAction.$$$reportNull$$$0(0);
        }
        if (selection == null) {
            UnmarkRootAction.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"ide.hide.excluded.files") && !selection.mySelectedExcludeRoots.isEmpty() && selection.mySelectedDirectories.isEmpty() && selection.mySelectedRoots.isEmpty()) {
            e.getPresentation().setEnabledAndVisible(true);
            e.getPresentation().setText(LangBundle.messagePointer((String)"mark.as.unmark.excluded", (Object[])new Object[0]));
            return;
        }
        super.doUpdate(e, module, selection);
        String text = this.getActionText(e, module, selection);
        if (text != null) {
            e.getPresentation().setText(text);
        }
    }

    @Nullable
    protected String getActionText(@NotNull AnActionEvent e, @Nullable Module module, @NotNull MarkRootActionBase.RootsSelection selection) {
        Set<ModuleSourceRootEditHandler<?>> selectedRootHandlers;
        if (e == null) {
            UnmarkRootAction.$$$reportNull$$$0(2);
        }
        if (selection == null) {
            UnmarkRootAction.$$$reportNull$$$0(3);
        }
        if (!(selectedRootHandlers = UnmarkRootAction.getHandlersForSelectedRoots(selection)).isEmpty()) {
            if (selectedRootHandlers.size() == 1) {
                ModuleSourceRootEditHandler<?> handler2 = selectedRootHandlers.iterator().next();
                return LangBundle.message((String)"mark.as.unmark", (Object[])new Object[]{StringUtil.pluralize((String)handler2.getFullRootTypeName(), (int)selection.mySelectedRoots.size())});
            }
            return LangBundle.message((String)"mark.as.unmark.several", (Object[])new Object[0]);
        }
        return null;
    }

    @NotNull
    private static Set<ModuleSourceRootEditHandler<?>> getHandlersForSelectedRoots(@NotNull MarkRootActionBase.RootsSelection selection) {
        if (selection == null) {
            UnmarkRootAction.$$$reportNull$$$0(4);
        }
        HashSet selectedRootHandlers = new HashSet();
        for (SourceFolder root : selection.mySelectedRoots) {
            ContainerUtil.addIfNotNull(selectedRootHandlers, ModuleSourceRootEditHandler.getEditHandler(root.getRootType()));
        }
        HashSet hashSet = selectedRootHandlers;
        if (hashSet == null) {
            UnmarkRootAction.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module) {
        if (selection == null) {
            UnmarkRootAction.$$$reportNull$$$0(6);
        }
        if (module == null) {
            UnmarkRootAction.$$$reportNull$$$0(7);
        }
        return selection.mySelectedDirectories.isEmpty() && !UnmarkRootAction.getHandlersForSelectedRoots(selection).isEmpty();
    }

    @Override
    protected void modifyRoots(@NotNull VirtualFile file2, @NotNull ContentEntry entry) {
        if (file2 == null) {
            UnmarkRootAction.$$$reportNull$$$0(8);
        }
        if (entry == null) {
            UnmarkRootAction.$$$reportNull$$$0(9);
        }
        for (ExcludeFolder excludeFolder : entry.getExcludeFolders()) {
            if (!file2.equals(excludeFolder.getFile())) continue;
            entry.removeExcludeFolder(excludeFolder);
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/actions/UnmarkRootAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/actions/UnmarkRootAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlersForSelectedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doUpdate";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getActionText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHandlersForSelectedRoots";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "modifyRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

