/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipsOrderUtil;
import com.intellij.internal.statistic.eventLog.EventLogConfiguration;
import com.intellij.internal.statistic.local.ActionSummary;
import com.intellij.internal.statistic.local.ActionsLocalSummary;
import com.intellij.internal.statistic.utils.StatisticsUploadAssistant;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005\u0014\u0015\u0016\u0017\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0016\u0010\u0012\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0007J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000e*\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ide/util/TipsOrderUtil;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "MAPPER", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "RANDOM_SHUFFLE_ALGORITHM", "", "TIPS_SERVER_URL", "serverRecommendation", "Lcom/intellij/ide/util/TipsOrderUtil$ServerRecommendation;", "shuffle", "Lcom/intellij/ide/util/TipsOrderUtil$RecommendationDescription;", "tips", "", "Lcom/intellij/ide/util/TipAndTrickBean;", "sort", "reorder", "RecommendationDescription", "RecommendationsStartupActivity", "ServerRecommendation", "TipsRequest", "UsageInfo", "intellij.platform.ide.impl"})
public final class TipsOrderUtil {
    private static final Logger LOG;
    private static final String RANDOM_SHUFFLE_ALGORITHM = "default_shuffle";
    private static final String TIPS_SERVER_URL = "https://feature-recommendation.analytics.aws.intellij.net/tips/v1";
    private static final ObjectMapper MAPPER;
    private static volatile ServerRecommendation serverRecommendation;
    public static final TipsOrderUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final RecommendationDescription sort(@NotNull List<? extends TipAndTrickBean> tips) {
        Intrinsics.checkParameterIsNotNull(tips, (String)"tips");
        Object object = serverRecommendation;
        if (object == null || (object = INSTANCE.reorder((ServerRecommendation)object, tips)) == null) {
            object = INSTANCE.shuffle(tips);
        }
        return object;
    }

    private final RecommendationDescription shuffle(List<? extends TipAndTrickBean> tips) {
        return new RecommendationDescription(RANDOM_SHUFFLE_ALGORITHM, CollectionsKt.shuffled((Iterable)tips), null);
    }

    /*
     * WARNING - void declaration
     */
    private final RecommendationDescription reorder(@NotNull ServerRecommendation $this$reorder, List<? extends TipAndTrickBean> tips) {
        boolean bl = false;
        Map map2 = new LinkedHashMap();
        boolean bl2 = false;
        boolean bl3 = false;
        Map $this$apply = map2;
        boolean bl4 = false;
        Iterable $this$forEachIndexed$iv = $this$reorder.showingOrder;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void tipFile;
            int n = index$iv++;
            boolean bl5 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            String string = (String)item$iv;
            int index = n2;
            boolean bl6 = false;
            $this$apply.put(tipFile, index);
        }
        Map tip2index = map2;
        for (TipAndTrickBean tipAndTrickBean : tips) {
            Map map3 = tip2index;
            String string = tipAndTrickBean.fileName;
            boolean bl6 = false;
            Map map4 = map3;
            boolean bl7 = false;
            if (map4.containsKey(string)) continue;
            LOG.error("Unknown tips file: " + tipAndTrickBean.fileName);
            return null;
        }
        Iterable iterable = tips;
        String string = $this$reorder.usedAlgorithm;
        boolean $i$f$sortedBy = false;
        Iterable iterable2 = iterable;
        boolean bl8 = false;
        Comparator comparator2 = new Comparator<T>(tip2index){
            final /* synthetic */ Map $tip2index$inlined;
            {
                this.$tip2index$inlined = map2;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                TipAndTrickBean it = (TipAndTrickBean)((Object)a);
                boolean bl2 = false;
                it = (TipAndTrickBean)((Object)b);
                Comparable comparable = (Integer)this.$tip2index$inlined.get(it.fileName);
                bl2 = false;
                Integer n = (Integer)this.$tip2index$inlined.get(it.fileName);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)n);
            }
        };
        List list2 = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator2);
        String string2 = $this$reorder.version;
        List list3 = list2;
        String string3 = string;
        return new RecommendationDescription(string3, list3, string2);
    }

    private TipsOrderUtil() {
    }

    static {
        TipsOrderUtil tipsOrderUtil;
        INSTANCE = tipsOrderUtil = new TipsOrderUtil();
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TipsOrderUtil.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
        MAPPER = new ObjectMapper();
    }

    public static final /* synthetic */ Logger access$getLOG$p(TipsOrderUtil $this) {
        TipsOrderUtil tipsOrderUtil = $this;
        return LOG;
    }

    public static final /* synthetic */ ObjectMapper access$getMAPPER$p(TipsOrderUtil $this) {
        TipsOrderUtil tipsOrderUtil = $this;
        return MAPPER;
    }

    public static final /* synthetic */ ServerRecommendation access$getServerRecommendation$p(TipsOrderUtil $this) {
        TipsOrderUtil tipsOrderUtil = $this;
        return serverRecommendation;
    }

    public static final /* synthetic */ void access$setServerRecommendation$p(TipsOrderUtil $this, ServerRecommendation serverRecommendation) {
        TipsOrderUtil tipsOrderUtil = $this;
        TipsOrderUtil.serverRecommendation = serverRecommendation;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J/\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/util/TipsOrderUtil$RecommendationDescription;", "", "algorithm", "", "tips", "", "Lcom/intellij/ide/util/TipAndTrickBean;", "version", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;)V", "getAlgorithm", "()Ljava/lang/String;", "getTips", "()Ljava/util/List;", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide.impl"})
    public static final class RecommendationDescription {
        @NotNull
        private final String algorithm;
        @NotNull
        private final List<TipAndTrickBean> tips;
        @Nullable
        private final String version;

        @NotNull
        public final String getAlgorithm() {
            return this.algorithm;
        }

        @NotNull
        public final List<TipAndTrickBean> getTips() {
            return this.tips;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public RecommendationDescription(@NotNull String algorithm, @NotNull List<? extends TipAndTrickBean> tips, @Nullable String version2) {
            Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
            Intrinsics.checkParameterIsNotNull(tips, (String)"tips");
            this.algorithm = algorithm;
            this.tips = tips;
            this.version = version2;
        }

        @NotNull
        public final String component1() {
            return this.algorithm;
        }

        @NotNull
        public final List<TipAndTrickBean> component2() {
            return this.tips;
        }

        @Nullable
        public final String component3() {
            return this.version;
        }

        @NotNull
        public final RecommendationDescription copy(@NotNull String algorithm, @NotNull List<? extends TipAndTrickBean> tips, @Nullable String version2) {
            Intrinsics.checkParameterIsNotNull((Object)algorithm, (String)"algorithm");
            Intrinsics.checkParameterIsNotNull(tips, (String)"tips");
            return new RecommendationDescription(algorithm, tips, version2);
        }

        public static /* synthetic */ RecommendationDescription copy$default(RecommendationDescription recommendationDescription, String string, List list2, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = recommendationDescription.algorithm;
            }
            if ((n & 2) != 0) {
                list2 = recommendationDescription.tips;
            }
            if ((n & 4) != 0) {
                string2 = recommendationDescription.version;
            }
            return recommendationDescription.copy(string, list2, string2);
        }

        @NotNull
        public String toString() {
            return "RecommendationDescription(algorithm=" + this.algorithm + ", tips=" + this.tips + ", version=" + this.version + ")";
        }

        public int hashCode() {
            String string = this.algorithm;
            List<TipAndTrickBean> list2 = this.tips;
            String string2 = this.version;
            return ((string != null ? string.hashCode() : 0) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof RecommendationDescription)) break block3;
                    RecommendationDescription recommendationDescription = (RecommendationDescription)object;
                    if (!Intrinsics.areEqual((Object)this.algorithm, (Object)recommendationDescription.algorithm) || !Intrinsics.areEqual(this.tips, recommendationDescription.tips) || !Intrinsics.areEqual((Object)this.version, (Object)recommendationDescription.version)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0006H\u0002J\b\u0010\n\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/util/TipsOrderUtil$RecommendationsStartupActivity;", "Lcom/intellij/openapi/startup/StartupActivity$DumbAware;", "()V", "alarm", "Lcom/intellij/util/Alarm;", "runActivity", "", "project", "Lcom/intellij/openapi/project/Project;", "scheduleSyncRequest", "sync", "intellij.platform.ide.impl"})
    public static final class RecommendationsStartupActivity
    implements StartupActivity.DumbAware {
        private final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)ApplicationManager.getApplication());

        public void runActivity(@NotNull Project project) {
            block3: {
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    Application application = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                    if (!application.isEAP() || !StatisticsUploadAssistant.isSendAllowed()) break block2;
                    Application application2 = ApplicationManager.getApplication();
                    Intrinsics.checkExpressionValueIsNotNull((Object)application2, (String)"ApplicationManager.getApplication()");
                    if (!application2.isHeadlessEnvironment()) break block3;
                }
                return;
            }
            this.scheduleSyncRequest();
        }

        private final void scheduleSyncRequest() {
            this.alarm.addRequest(new Runnable(this){
                final /* synthetic */ RecommendationsStartupActivity this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void run() {
                    try {
                        RecommendationsStartupActivity.access$sync(this.this$0);
                    }
                    catch (Throwable throwable) {
                        RecommendationsStartupActivity.access$getAlarm$p(this.this$0).addRequest(new Runnable(this){
                            final /* synthetic */ scheduleSyncRequest.1 this$0;

                            public final void run() {
                                RecommendationsStartupActivity.access$sync(this.this$0.this$0);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, TimeUnit.HOURS.toMillis(3L));
                        throw throwable;
                    }
                    RecommendationsStartupActivity.access$getAlarm$p(this.this$0).addRequest(new /* invalid duplicate definition of identical inner class */, TimeUnit.HOURS.toMillis(3L));
                }
                {
                    this.this$0 = recommendationsStartupActivity;
                }
            }, 0);
        }

        /*
         * WARNING - void declaration
         */
        private final void sync() {
            void $this$mapValuesTo$iv$iv;
            Logger logger = TipsOrderUtil.access$getLOG$p(INSTANCE);
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
            logger.assertTrue(!application.isDispatchThread());
            TipsOrderUtil.access$getLOG$p(INSTANCE).debug("Fetching tips order from the server: https://feature-recommendation.analytics.aws.intellij.net/tips/v1");
            ExtensionPointName<TipAndTrickBean> extensionPointName = TipAndTrickBean.EP_NAME;
            Intrinsics.checkExpressionValueIsNotNull(extensionPointName, (String)"TipAndTrickBean.EP_NAME");
            List list2 = ContainerUtil.map((Collection)extensionPointName.getExtensionList(), (Function)sync.allTips.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ContainerUtil.map(TipAnd\u2026TrickBean -> x.fileName }");
            List allTips2 = list2;
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(ActionsLocalSummary.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            Map $this$mapValues$iv = ((ActionsLocalSummary)object).getActionsStats();
            boolean $i$f$mapValues = false;
            Map map2 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl = false;
                Object k = it$iv$iv.getKey();
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k2 = k;
                Map map4 = map3;
                boolean bl2 = false;
                UsageInfo usageInfo = new UsageInfo(((ActionSummary)it.getValue()).times, ((ActionSummary)it.getValue()).last);
                map4.put(k2, usageInfo);
            }
            Map actionsSummary = destination$iv$iv;
            long startTimestamp = System.currentTimeMillis();
            HttpRequests.post((String)TipsOrderUtil.TIPS_SERVER_URL, (String)"application/json; charset=utf-8").connect((HttpRequests.RequestProcessor)new HttpRequests.RequestProcessor<Unit>(allTips2, actionsSummary, startTimestamp){
                final /* synthetic */ List $allTips;
                final /* synthetic */ Map $actionsSummary;
                final /* synthetic */ long $startTimestamp;

                public final void process(@NotNull HttpRequests.Request request2) {
                    Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
                    int bucket = EventLogConfiguration.INSTANCE.getBucket();
                    String string = PlatformUtils.getPlatformPrefix();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"PlatformUtils.getPlatformPrefix()");
                    TipsRequest tipsRequest = new TipsRequest(this.$allTips, this.$actionsSummary, string, bucket);
                    request2.write(TipsOrderUtil.access$getMAPPER$p(TipsOrderUtil.INSTANCE).writeValueAsBytes((Object)tipsRequest));
                    ServerRecommendation recommendation = (ServerRecommendation)TipsOrderUtil.access$getMAPPER$p(TipsOrderUtil.INSTANCE).readValue(request2.readString(), ServerRecommendation.class);
                    if (TipsOrderUtil.access$getLOG$p(TipsOrderUtil.INSTANCE).isDebugEnabled()) {
                        long duration = System.currentTimeMillis() - this.$startTimestamp;
                        String algorithmInfo = recommendation.usedAlgorithm + ':' + recommendation.version;
                        TipsOrderUtil.access$getLOG$p(TipsOrderUtil.INSTANCE).debug("Server recommendation made. Algorithm: " + algorithmInfo + ". Duration: " + duration);
                    }
                    TipsOrderUtil.access$setServerRecommendation$p(TipsOrderUtil.INSTANCE, recommendation);
                }
                {
                    this.$allTips = list2;
                    this.$actionsSummary = map2;
                    this.$startTimestamp = l;
                }
            }, null, TipsOrderUtil.access$getLOG$p(INSTANCE));
        }

        public static final /* synthetic */ void access$sync(RecommendationsStartupActivity $this) {
            $this.sync();
        }

        public static final /* synthetic */ Alarm access$getAlarm$p(RecommendationsStartupActivity $this) {
            return $this.alarm;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ide/util/TipsOrderUtil$UsageInfo;", "", "usageCount", "", "lastUsedTimestamp", "", "(IJ)V", "getLastUsedTimestamp", "()J", "getUsageCount", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.ide.impl"})
    private static final class UsageInfo {
        private final int usageCount;
        private final long lastUsedTimestamp;

        public final int getUsageCount() {
            return this.usageCount;
        }

        public final long getLastUsedTimestamp() {
            return this.lastUsedTimestamp;
        }

        public UsageInfo(int usageCount, long lastUsedTimestamp) {
            this.usageCount = usageCount;
            this.lastUsedTimestamp = lastUsedTimestamp;
        }

        public final int component1() {
            return this.usageCount;
        }

        public final long component2() {
            return this.lastUsedTimestamp;
        }

        @NotNull
        public final UsageInfo copy(int usageCount, long lastUsedTimestamp) {
            return new UsageInfo(usageCount, lastUsedTimestamp);
        }

        public static /* synthetic */ UsageInfo copy$default(UsageInfo usageInfo, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = usageInfo.usageCount;
            }
            if ((n2 & 2) != 0) {
                l = usageInfo.lastUsedTimestamp;
            }
            return usageInfo.copy(n, l);
        }

        @NotNull
        public String toString() {
            return "UsageInfo(usageCount=" + this.usageCount + ", lastUsedTimestamp=" + this.lastUsedTimestamp + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.usageCount) * 31 + Long.hashCode(this.lastUsedTimestamp);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof UsageInfo)) break block3;
                    UsageInfo usageInfo = (UsageInfo)object;
                    if (this.usageCount != usageInfo.usageCount || this.lastUsedTimestamp != usageInfo.lastUsedTimestamp) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B7\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\nH\u00c6\u0003JC\u0010\u0018\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\nH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/util/TipsOrderUtil$TipsRequest;", "", "tips", "", "", "usageInfo", "", "Lcom/intellij/ide/util/TipsOrderUtil$UsageInfo;", "ideName", "bucket", "", "(Ljava/util/List;Ljava/util/Map;Ljava/lang/String;I)V", "getBucket", "()I", "getIdeName", "()Ljava/lang/String;", "getTips", "()Ljava/util/List;", "getUsageInfo", "()Ljava/util/Map;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.platform.ide.impl"})
    private static final class TipsRequest {
        @NotNull
        private final List<String> tips;
        @NotNull
        private final Map<String, UsageInfo> usageInfo;
        @NotNull
        private final String ideName;
        private final int bucket;

        @NotNull
        public final List<String> getTips() {
            return this.tips;
        }

        @NotNull
        public final Map<String, UsageInfo> getUsageInfo() {
            return this.usageInfo;
        }

        @NotNull
        public final String getIdeName() {
            return this.ideName;
        }

        public final int getBucket() {
            return this.bucket;
        }

        public TipsRequest(@NotNull List<String> tips, @NotNull Map<String, UsageInfo> usageInfo, @NotNull String ideName, int bucket) {
            Intrinsics.checkParameterIsNotNull(tips, (String)"tips");
            Intrinsics.checkParameterIsNotNull(usageInfo, (String)"usageInfo");
            Intrinsics.checkParameterIsNotNull((Object)ideName, (String)"ideName");
            this.tips = tips;
            this.usageInfo = usageInfo;
            this.ideName = ideName;
            this.bucket = bucket;
        }

        @NotNull
        public final List<String> component1() {
            return this.tips;
        }

        @NotNull
        public final Map<String, UsageInfo> component2() {
            return this.usageInfo;
        }

        @NotNull
        public final String component3() {
            return this.ideName;
        }

        public final int component4() {
            return this.bucket;
        }

        @NotNull
        public final TipsRequest copy(@NotNull List<String> tips, @NotNull Map<String, UsageInfo> usageInfo, @NotNull String ideName, int bucket) {
            Intrinsics.checkParameterIsNotNull(tips, (String)"tips");
            Intrinsics.checkParameterIsNotNull(usageInfo, (String)"usageInfo");
            Intrinsics.checkParameterIsNotNull((Object)ideName, (String)"ideName");
            return new TipsRequest(tips, usageInfo, ideName, bucket);
        }

        public static /* synthetic */ TipsRequest copy$default(TipsRequest tipsRequest, List list2, Map map2, String string, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list2 = tipsRequest.tips;
            }
            if ((n2 & 2) != 0) {
                map2 = tipsRequest.usageInfo;
            }
            if ((n2 & 4) != 0) {
                string = tipsRequest.ideName;
            }
            if ((n2 & 8) != 0) {
                n = tipsRequest.bucket;
            }
            return tipsRequest.copy(list2, map2, string, n);
        }

        @NotNull
        public String toString() {
            return "TipsRequest(tips=" + this.tips + ", usageInfo=" + this.usageInfo + ", ideName=" + this.ideName + ", bucket=" + this.bucket + ")";
        }

        public int hashCode() {
            List<String> list2 = this.tips;
            Map<String, UsageInfo> map2 = this.usageInfo;
            String string = this.ideName;
            return (((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (map2 != null ? ((Object)map2).hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + Integer.hashCode(this.bucket);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TipsRequest)) break block3;
                    TipsRequest tipsRequest = (TipsRequest)object;
                    if (!Intrinsics.areEqual(this.tips, tipsRequest.tips) || !Intrinsics.areEqual(this.usageInfo, tipsRequest.usageInfo) || !Intrinsics.areEqual((Object)this.ideName, (Object)tipsRequest.ideName) || this.bucket != tipsRequest.bucket) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/util/TipsOrderUtil$ServerRecommendation;", "", "()V", "showingOrder", "", "", "usedAlgorithm", "version", "intellij.platform.ide.impl"})
    public static final class ServerRecommendation {
        @JvmField
        @NotNull
        public List<String> showingOrder = CollectionsKt.emptyList();
        @JvmField
        @NotNull
        public String usedAlgorithm = "unknown";
        @JvmField
        @Nullable
        public String version;
    }
}

