/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.model;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.model.BranchedVirtualFile;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelPatch;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
@ApiStatus.Internal
public class ModelBranchImpl
implements ModelBranch {
    private final Map<VirtualFile, VirtualFile> myVFileCopies;
    private final Map<Document, List<DocumentEvent>> myDocumentChanges;
    private final List<Runnable> myAfterMerge;
    private final SimpleModificationTracker myFileSetChanges;
    private final Project myProject;
    private boolean myMerged;

    private ModelBranchImpl(@NotNull Project project) {
        if (project == null) {
            ModelBranchImpl.$$$reportNull$$$0(0);
        }
        this.myVFileCopies = new HashMap<VirtualFile, VirtualFile>();
        this.myDocumentChanges = new HashMap<Document, List<DocumentEvent>>();
        this.myAfterMerge = new ArrayList<Runnable>();
        this.myFileSetChanges = new SimpleModificationTracker();
        this.myProject = project;
    }

    @NotNull
    static ModelPatch performInBranch(@NotNull Project project, @NotNull Consumer<ModelBranch> action2) {
        if (project == null) {
            ModelBranchImpl.$$$reportNull$$$0(1);
        }
        if (action2 == null) {
            ModelBranchImpl.$$$reportNull$$$0(2);
        }
        final ModelBranchImpl branch = new ModelBranchImpl(project);
        action2.accept(branch);
        return new ModelPatch(){

            public void applyBranchChanges() {
                branch.mergeBack();
            }

            @NotNull
            public Map<VirtualFile, CharSequence> getBranchChanges() {
                HashMap<VirtualFile, CharSequence> result2 = new HashMap<VirtualFile, CharSequence>();
                for (Document document : branch.myDocumentChanges.keySet()) {
                    VirtualFile file2 = Objects.requireNonNull(FileDocumentManager.getInstance().getFile(document));
                    VirtualFile original = branch.findOriginalFile(file2);
                    result2.put(original, document.getImmutableCharSequence());
                }
                HashMap<VirtualFile, CharSequence> hashMap = result2;
                if (hashMap == null) {
                    1.$$$reportNull$$$0(0);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/model/ModelBranchImpl$1", "getBranchChanges"));
            }
        };
    }

    public void runAfterMerge(@NotNull Runnable action2) {
        if (action2 == null) {
            ModelBranchImpl.$$$reportNull$$$0(3);
        }
        this.myAfterMerge.add(action2);
    }

    @NotNull
    private VirtualFile obtainFileCopy(@NotNull VirtualFile original) {
        if (original == null) {
            ModelBranchImpl.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile = this.myVFileCopies.computeIfAbsent(original, __ -> {
            assert (!(original instanceof VirtualFileWindow));
            Document origDoc = FileDocumentManager.getInstance().getDocument(original);
            assert (origDoc != null);
            assert (PsiDocumentManager.getInstance((Project)this.myProject).isCommitted(origDoc));
            BranchedVirtualFile copy2 = new BranchedVirtualFile(original, origDoc.getImmutableCharSequence(), (ModelBranch)this);
            copy2.putUserData(AbstractFileViewProvider.FREE_THREADED, (Object)true);
            this.myFileSetChanges.incModificationCount();
            Document copyDoc = FileDocumentManager.getInstance().getDocument((VirtualFile)copy2);
            assert (copyDoc != null);
            final ArrayList events = new ArrayList();
            this.myDocumentChanges.put(copyDoc, events);
            copyDoc.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    events.add(event);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/model/ModelBranchImpl$2", "documentChanged"));
                }
            });
            return copy2;
        });
        if (virtualFile == null) {
            ModelBranchImpl.$$$reportNull$$$0(5);
        }
        return virtualFile;
    }

    @Nullable
    private PsiFile findSameLanguageRoot(@Nullable PsiFile original, @Nullable VirtualFile vFileCopy) {
        if (original == null || vFileCopy == null) {
            return null;
        }
        FileViewProvider viewProvider = PsiManager.getInstance((Project)this.myProject).findViewProvider(vFileCopy);
        return viewProvider == null ? null : viewProvider.getPsi(original.getLanguage());
    }

    @Nullable
    public VirtualFile findFileCopy(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModelBranchImpl.$$$reportNull$$$0(6);
        }
        assert (ModelBranch.getFileBranch((VirtualFile)file2) != this);
        return this.myVFileCopies.get(file2);
    }

    @NotNull
    public <T extends PsiElement> T obtainPsiCopy(@NotNull T original) {
        if (original == null) {
            ModelBranchImpl.$$$reportNull$$$0(7);
        }
        PsiFile file2 = original.getContainingFile();
        assert (file2 != null) : original;
        VirtualFile vFileCopy = this.obtainFileCopy(file2.getViewProvider().getVirtualFile());
        PsiFile fileCopy = Objects.requireNonNull(this.findSameLanguageRoot(file2, vFileCopy));
        PsiElement psiElement = Objects.requireNonNull(PsiTreeUtil.findSameElementInCopy(original, (PsiFile)fileCopy));
        if (psiElement == null) {
            ModelBranchImpl.$$$reportNull$$$0(8);
        }
        return (T)psiElement;
    }

    @Nullable
    public <T extends PsiElement> T findPsiCopy(@NotNull T original) {
        PsiFile file2;
        if (original == null) {
            ModelBranchImpl.$$$reportNull$$$0(9);
        }
        if ((file2 = original.getContainingFile()) == null) {
            return null;
        }
        PsiFile fileCopy = this.findSameLanguageRoot(file2, this.findFileCopy(file2.getViewProvider().getVirtualFile()));
        return (T)(fileCopy == null ? null : PsiTreeUtil.findSameElementInCopy(original, (PsiFile)fileCopy));
    }

    @Nullable
    public <T extends PsiSymbolReference> T findReferenceCopy(@NotNull T original) {
        PsiElement psiCopy;
        if (original == null) {
            ModelBranchImpl.$$$reportNull$$$0(10);
        }
        if ((psiCopy = this.findPsiCopy(original.getElement())) == null) {
            return null;
        }
        TextRange range2 = original.getRangeInElement();
        return (T)((PsiSymbolReference)ContainerUtil.find((Object[])psiCopy.getReferences(), r -> r.getClass() == original.getClass() && range2.equals((Object)r.getRangeInElement())));
    }

    @Nullable
    public <T extends PsiElement> T findOriginalPsi(@NotNull T branched) {
        if (branched == null) {
            ModelBranchImpl.$$$reportNull$$$0(11);
        }
        assert (this.myMerged);
        PsiFile branchedFile = branched.getContainingFile();
        PsiFile originalFile = this.findSameLanguageRoot(branchedFile, this.findOriginalFile(branchedFile.getViewProvider().getVirtualFile()));
        return (T)(originalFile == null ? null : PsiTreeUtil.findSameElementInCopy(branched, (PsiFile)originalFile));
    }

    @NotNull
    public VirtualFile findOriginalFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ModelBranchImpl.$$$reportNull$$$0(12);
        }
        BranchedVirtualFile branched = (BranchedVirtualFile)file2;
        assert (branched.branch == this);
        VirtualFile virtualFile = branched.original;
        if (virtualFile == null) {
            ModelBranchImpl.$$$reportNull$$$0(13);
        }
        return virtualFile;
    }

    public long getBranchedPsiModificationCount() {
        return this.myFileSetChanges.getModificationCount() + this.myVFileCopies.values().stream().map(arg_0 -> ((PsiManager)PsiManager.getInstance((Project)this.myProject)).findFile(arg_0)).filter(Objects::nonNull).mapToLong(PsiFile::getModificationStamp).sum();
    }

    private void mergeBack() {
        assert (!this.myMerged);
        this.myMerged = true;
        for (Document document : this.myDocumentChanges.keySet()) {
            VirtualFile file2 = Objects.requireNonNull(FileDocumentManager.getInstance().getFile(document));
            DocumentImpl original = (DocumentImpl)FileDocumentManager.getInstance().getDocument(this.findOriginalFile(file2));
            assert (original != null);
            for (DocumentEvent event : this.myDocumentChanges.get(document)) {
                original.replaceString(event.getOffset(), event.getOffset() + event.getOldLength(), event.getMoveOffset(), event.getNewFragment(), LocalTimeCounter.currentTime(), false);
            }
        }
        for (Runnable runnable2 : this.myAfterMerge) {
            runnable2.run();
        }
    }

    @NotNull
    public GlobalSearchScope modifyScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ModelBranchImpl.$$$reportNull$$$0(14);
        }
        return new DelegatingGlobalSearchScope(scope, new Object[]{this, this.getBranchedPsiModificationCount()}){

            public boolean contains(@NotNull VirtualFile file2) {
                ModelBranch fileBranch;
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((fileBranch = ModelBranch.getFileBranch((VirtualFile)file2)) == ModelBranchImpl.this) {
                    return super.contains(ModelBranchImpl.this.findOriginalFile(file2));
                }
                if (fileBranch == null) {
                    return ModelBranchImpl.this.findFileCopy(file2) == null && super.contains(file2);
                }
                return false;
            }

            @NotNull
            public Collection<ModelBranch> getModelBranchesAffectingScope() {
                Set<ModelBranch> set = Collections.singleton(ModelBranchImpl.this);
                if (set == null) {
                    3.$$$reportNull$$$0(1);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/model/ModelBranchImpl$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/model/ModelBranchImpl$3";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getModelBranchesAffectingScope";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "contains";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static boolean hasBranchedFilesInScope(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            ModelBranchImpl.$$$reportNull$$$0(15);
        }
        return !ModelBranchImpl.processBranchedFilesInScope(scope, (Processor<? super VirtualFile>)((Processor)__ -> false));
    }

    public static boolean processBranchedFilesInScope(@NotNull GlobalSearchScope scope, @NotNull Processor<? super VirtualFile> processor2) {
        Collection branches;
        if (scope == null) {
            ModelBranchImpl.$$$reportNull$$$0(16);
        }
        if (processor2 == null) {
            ModelBranchImpl.$$$reportNull$$$0(17);
        }
        return (branches = scope.getModelBranchesAffectingScope()).isEmpty() || ModelBranchImpl.processBranchedFilesInScope(scope, processor2, branches);
    }

    private static boolean processBranchedFilesInScope(GlobalSearchScope scope, Processor<? super VirtualFile> processor2, Collection<ModelBranch> branches) {
        for (ModelBranch branch : branches) {
            for (VirtualFile file2 : ((ModelBranchImpl)branch).myVFileCopies.values()) {
                if (!scope.contains(file2) || processor2.process((Object)file2)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/model/ModelBranchImpl";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branched";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/model/ModelBranchImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainFileCopy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainPsiCopy";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findOriginalFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performInBranch";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runAfterMerge";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "obtainFileCopy";
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFileCopy";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "obtainPsiCopy";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPsiCopy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceCopy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalPsi";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findOriginalFile";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "modifyScope";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "hasBranchedFilesInScope";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processBranchedFilesInScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

