/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileChooser.tree.FileNode;
import com.intellij.openapi.fileChooser.tree.FileRefresher;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.ui.tree.Identifiable;
import com.intellij.ui.tree.MapBasedTree;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.AbstractTreeModel;
import java.lang.reflect.Method;
import java.nio.file.FileSystems;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public final class FileTreeModel
extends AbstractTreeModel
implements Identifiable,
InvokerSupplier {
    private final Invoker invoker;
    private final State state;
    private volatile List<Root> roots;

    public FileTreeModel(@NotNull FileChooserDescriptor descriptor2, FileRefresher refresher) {
        if (descriptor2 == null) {
            FileTreeModel.$$$reportNull$$$0(0);
        }
        this(descriptor2, refresher, true, false);
    }

    public FileTreeModel(@NotNull FileChooserDescriptor descriptor2, FileRefresher refresher, boolean sortDirectories, boolean sortArchives) {
        if (descriptor2 == null) {
            FileTreeModel.$$$reportNull$$$0(1);
        }
        this.invoker = Invoker.forBackgroundThreadWithReadAction((Disposable)this);
        if (refresher != null) {
            Disposer.register((Disposable)this, (Disposable)refresher);
        }
        this.state = new State(descriptor2, refresher, sortDirectories, sortArchives);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileTreeModel.this.invoker.invoke(() -> FileTreeModel.this.process(events));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/openapi/fileChooser/tree/FileTreeModel$1", "after"));
            }
        });
    }

    public void invalidate() {
        this.invoker.invoke(() -> {
            if (this.roots != null) {
                for (Root root : this.roots) {
                    root.tree.invalidate();
                }
            }
            this.treeStructureChanged(this.state.path, null, null);
        });
    }

    @Override
    public Object getUniqueID(@NotNull TreePath path) {
        if (path == null) {
            FileTreeModel.$$$reportNull$$$0(2);
        }
        Object object = path.getLastPathComponent();
        TreePath parent = path.getParentPath();
        return parent != null && object instanceof Node ? this.getUniqueID(parent, (Node)object, new ArrayDeque()) : (parent != null || object != this.state ? null : this.state.toString());
    }

    private Object getUniqueID(TreePath path, Node node, ArrayDeque<? super String> deque) {
        deque.addFirst(node.getName());
        Object object = path.getLastPathComponent();
        TreePath parent = path.getParentPath();
        return parent != null && object instanceof Node ? this.getUniqueID(parent, (Node)object, deque) : (parent != null || object != this.state ? null : deque.toArray());
    }

    @Override
    @NotNull
    public Invoker getInvoker() {
        Invoker invoker = this.invoker;
        if (invoker == null) {
            FileTreeModel.$$$reportNull$$$0(3);
        }
        return invoker;
    }

    public final Object getRoot() {
        if (this.state.path != null) {
            return this.state;
        }
        if (this.roots == null) {
            this.roots = this.state.getRoots();
        }
        return 1 == this.roots.size() ? this.roots.get(0) : null;
    }

    public final Object getChild(Object object, int index) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            if (0 <= index && index < this.roots.size()) {
                return this.roots.get(index);
            }
        } else if (object instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            return entry.getChild(index);
        }
        return null;
    }

    public final int getChildCount(Object object) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            return this.roots.size();
        }
        if (object instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            return entry.getChildCount();
        }
        return 0;
    }

    public final boolean isLeaf(Object object) {
        if (object instanceof Node) {
            assert (object != this.state);
            MapBasedTree.Entry<Node> entry = this.getEntry((Node)object, false);
            if (entry != null) {
                return entry.isLeaf();
            }
        }
        return false;
    }

    public final int getIndexOfChild(Object object, Object child2) {
        MapBasedTree.Entry<Node> entry;
        if (object == this.state) {
            if (this.roots == null) {
                this.roots = this.state.getRoots();
            }
            for (int i2 = 0; i2 < this.roots.size(); ++i2) {
                if (child2 != this.roots.get(i2)) continue;
                return i2;
            }
        } else if (object instanceof Node && child2 instanceof Node && (entry = this.getEntry((Node)object, true)) != null) {
            return entry.getIndexOf((Node)child2);
        }
        return -1;
    }

    private boolean hasEntry(VirtualFile file2) {
        if (this.roots != null) {
            for (Root root : this.roots) {
                MapBasedTree.Entry entry = root.tree.findEntry(file2);
                if (entry == null) continue;
                return true;
            }
        }
        return false;
    }

    private MapBasedTree.Entry<Node> getEntry(Node node, boolean loadChildren) {
        if (this.roots != null) {
            for (Root root : this.roots) {
                MapBasedTree.Entry<Node> entry = root.tree.getEntry(node);
                if (entry == null) continue;
                if (loadChildren && entry.isLoadingRequired()) {
                    root.updateChildren(this.state, entry);
                }
                return entry;
            }
        }
        return null;
    }

    private void process(List<? extends VFileEvent> events) {
        if (this.roots == null) {
            return;
        }
        HashSet<VirtualFile> files2 = new HashSet<VirtualFile>();
        HashSet<VirtualFile> parents2 = new HashSet<VirtualFile>();
        for (VFileEvent virtualFile : events) {
            VirtualFile file2;
            if (virtualFile instanceof VFilePropertyChangeEvent) {
                if (!this.hasEntry(virtualFile.getFile())) continue;
                files2.add(virtualFile.getFile());
                continue;
            }
            if (virtualFile instanceof VFileCreateEvent) {
                VFileCreateEvent create2 = (VFileCreateEvent)virtualFile;
                if (!this.hasEntry(create2.getParent())) continue;
                parents2.add(create2.getParent());
                continue;
            }
            if (virtualFile instanceof VFileCopyEvent) {
                VFileCopyEvent copy2 = (VFileCopyEvent)virtualFile;
                if (!this.hasEntry(copy2.getNewParent())) continue;
                parents2.add(copy2.getNewParent());
                continue;
            }
            if (virtualFile instanceof VFileMoveEvent) {
                VFileMoveEvent move = (VFileMoveEvent)virtualFile;
                if (this.hasEntry(move.getNewParent())) {
                    parents2.add(move.getNewParent());
                }
                if (!this.hasEntry(move.getOldParent())) continue;
                parents2.add(move.getOldParent());
                continue;
            }
            if (!(virtualFile instanceof VFileDeleteEvent) || !this.hasEntry(file2 = virtualFile.getFile())) continue;
            files2.add(file2);
            file2 = file2.getParent();
            parents2.add((VirtualFile)(this.hasEntry(file2) ? file2 : null));
        }
        for (VirtualFile virtualFile : parents2) {
            for (Root root : this.roots) {
                boolean contained;
                MapBasedTree.Entry entry = root.tree.findEntry(virtualFile);
                if (entry == null) continue;
                MapBasedTree.UpdateResult update2 = root.updateChildren(this.state, entry);
                boolean removed = !update2.getRemoved().isEmpty();
                boolean inserted = !update2.getInserted().isEmpty();
                boolean bl = contained = !update2.getContained().isEmpty();
                if (!removed && !inserted && !contained) continue;
                if (!removed && inserted) {
                    if (this.listeners.isEmpty()) continue;
                    this.listeners.treeNodesInserted(update2.getEvent(this, entry, update2.getInserted()));
                    continue;
                }
                if (!inserted && removed) {
                    if (this.listeners.isEmpty()) continue;
                    this.listeners.treeNodesRemoved(update2.getEvent(this, entry, update2.getRemoved()));
                    continue;
                }
                this.treeStructureChanged(entry, null, null);
            }
        }
        for (VirtualFile virtualFile : files2) {
        }
    }

    private static VirtualFile findFile(String path) {
        return LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileChooser/tree/FileTreeModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileChooser/tree/FileTreeModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvoker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueID";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Root
    extends Node {
        private final MapBasedTree<VirtualFile, Node> tree;

        private Root(State state, VirtualFile file2) {
            super(state, file2);
            if (state.refresher != null && state.refresher.isRecursive()) {
                state.refresher.register(file2);
            }
            this.tree = new MapBasedTree<VirtualFile, Node>(false, node -> node.getFile(), state.path);
            this.tree.onInsert(node -> Root.markDirtyInternal(node.getFile()));
            this.tree.updateRoot((Pair<Node, Boolean>)Pair.create((Object)this, (Object)state.isLeaf(file2)));
        }

        private static void markDirtyInternal(VirtualFile file2) {
            Method method2;
            if (file2 instanceof VirtualFileSystemEntry && (method2 = ReflectionUtil.getDeclaredMethod(VirtualFileSystemEntry.class, (String)"markDirtyInternal", (Class[])new Class[0])) != null) {
                try {
                    method2.invoke((Object)file2, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private MapBasedTree.UpdateResult<Node> updateChildren(State state, MapBasedTree.Entry<Node> parent) {
            VirtualFile[] children2 = state.getChildren(parent.getNode().getFile());
            if (children2 == null) {
                return this.tree.update(parent, null);
            }
            if (children2.length == 0) {
                return this.tree.update(parent, Collections.emptyList());
            }
            return this.tree.update(parent, Arrays.stream(children2).filter(x$0 -> state.isVisible(x$0)).sorted((x$0, x$1) -> state.compare(x$0, x$1)).map(file2 -> {
                MapBasedTree.Entry<Node> entry = this.tree.findEntry((VirtualFile)file2);
                return entry != null && parent == entry.getParentPath() ? Pair.create((Object)entry.getNode(), (Object)entry.isLeaf()) : Pair.create((Object)new Node(state, (VirtualFile)file2), (Object)state.isLeaf(file2));
            }).collect(Collectors.toList()));
        }
    }

    private static class Node
    extends FileNode {
        private boolean invalid;

        private Node(State state, VirtualFile file2) {
            super(file2);
            if (state.refresher != null && !state.refresher.isRecursive()) {
                state.refresher.register(file2);
            }
            this.updateContent(state);
        }

        private boolean updateContent(State state) {
            VirtualFile file2 = this.getFile();
            if (file2 == null) {
                return this.updateName(state.descriptor.getTitle());
            }
            Icon icon2 = state.descriptor.getIcon(file2);
            String name = state.descriptor.getName(file2);
            String comment = state.descriptor.getComment(file2);
            if (name == null || comment == null) {
                name = file2.getName();
            }
            boolean updated = false;
            if (this.updateIcon(icon2)) {
                updated = true;
            }
            if (this.updateName(name)) {
                updated = true;
            }
            if (this.updateComment(comment)) {
                updated = true;
            }
            if (this.updateValid(file2.isValid())) {
                updated = true;
            }
            if (this.updateHidden(FileElement.isFileHidden((VirtualFile)file2))) {
                updated = true;
            }
            if (this.updateSpecial(file2.is(VFileProperty.SPECIAL))) {
                updated = true;
            }
            if (this.updateSymlink(file2.is(VFileProperty.SYMLINK))) {
                updated = true;
            }
            if (this.updateWritable(file2.isWritable())) {
                updated = true;
            }
            return updated;
        }

        public String toString() {
            return this.getName();
        }
    }

    private static final class State {
        private final TreePath path;
        private final FileChooserDescriptor descriptor;
        private final FileRefresher refresher;
        private final boolean sortDirectories;
        private final boolean sortArchives;
        private final List<VirtualFile> roots;

        private State(FileChooserDescriptor descriptor2, FileRefresher refresher, boolean sortDirectories, boolean sortArchives) {
            this.descriptor = descriptor2;
            this.refresher = refresher;
            this.sortDirectories = sortDirectories;
            this.sortArchives = sortArchives;
            this.roots = State.getRoots(descriptor2);
            this.path = this.roots != null && 1 == this.roots.size() ? null : new TreePath(this);
        }

        private int compare(VirtualFile one, VirtualFile two) {
            if (one == null && two == null) {
                return 0;
            }
            if (one == null) {
                return -1;
            }
            if (two == null) {
                return 1;
            }
            if (this.sortDirectories) {
                boolean isArchive;
                boolean isDirectory = one.isDirectory();
                if (isDirectory != two.isDirectory()) {
                    return isDirectory ? -1 : 1;
                }
                if (!isDirectory && this.sortArchives && this.descriptor.isChooseJarContents() && (isArchive = FileElement.isArchive((VirtualFile)one)) != FileElement.isArchive((VirtualFile)two)) {
                    return isArchive ? -1 : 1;
                }
            }
            return StringUtil.naturalCompare((String)one.getName(), (String)two.getName());
        }

        private static boolean isValid(VirtualFile file2) {
            return file2 != null && file2.isValid();
        }

        private boolean isVisible(VirtualFile file2) {
            return State.isValid(file2) && this.descriptor.isFileVisible(file2, this.descriptor.isShowHiddenFiles());
        }

        private boolean isLeaf(VirtualFile file2) {
            if (file2 == null || file2.isDirectory()) {
                return false;
            }
            return !this.descriptor.isChooseJarContents() || !FileElement.isArchive((VirtualFile)file2);
        }

        private VirtualFile[] getChildren(VirtualFile file2) {
            if (file2.isDirectory()) {
                return file2.getChildren();
            }
            if (!this.descriptor.isChooseJarContents() || !FileElement.isArchive((VirtualFile)file2)) {
                return null;
            }
            String path = file2.getPath() + "!/";
            VirtualFile jar = JarFileSystem.getInstance().findFileByPath(path);
            return jar == null ? VirtualFile.EMPTY_ARRAY : jar.getChildren();
        }

        private List<Root> getRoots() {
            List<VirtualFile> files2 = this.roots;
            if (files2 == null) {
                files2 = State.getSystemRoots();
            }
            if (files2 == null || files2.isEmpty()) {
                return Collections.emptyList();
            }
            return ContainerUtil.map(files2, file2 -> new Root(this, (VirtualFile)file2));
        }

        private static List<VirtualFile> getRoots(FileChooserDescriptor descriptor2) {
            List list2 = ContainerUtil.filter((Collection)descriptor2.getRoots(), State::isValid);
            return list2.isEmpty() && descriptor2.isShowFileSystemRoots() ? null : list2;
        }

        private static List<VirtualFile> getSystemRoots() {
            return StreamSupport.stream(FileSystems.getDefault().getRootDirectories().spliterator(), false).map(root -> FileTreeModel.findFile(root.toAbsolutePath().toString())).filter(State::isValid).collect(Collectors.toList());
        }

        public String toString() {
            return this.descriptor.getTitle();
        }
    }
}

