/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.ToggleDistractionFreeModeAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.notebook.editor.BackedVirtualFile;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.EditorTabPresentationUtil;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.fileEditor.impl.EditorWindowHolder;
import com.intellij.openapi.fileEditor.impl.EditorWithProviderComposite;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.FileEditorAssociateFinder;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorOpenOptions;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.tabs.impl.tabsLayout.TabsLayoutInfo;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.Stack;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBRectangle;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditorWindow {
    private static final Logger LOG = Logger.getInstance(EditorWindow.class);
    public static final DataKey<EditorWindow> DATA_KEY = DataKey.create((String)"editorWindow");
    protected JPanel myPanel;
    @NotNull
    private final EditorTabbedContainer myTabbedPane;
    @NotNull
    private final EditorsSplitters myOwner;
    private boolean myIsDisposed;
    public static final Key<Integer> INITIAL_INDEX_KEY = Key.create((String)"initial editor index");
    private final Stack<Pair<String, FileEditorOpenOptions>> myRemovedTabs;

    protected EditorWindow(@NotNull EditorsSplitters owner, @NotNull Disposable parentDisposable) {
        if (owner == null) {
            EditorWindow.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            EditorWindow.$$$reportNull$$$0(1);
        }
        this.myRemovedTabs = new Stack<Pair<String, FileEditorOpenOptions>>(){

            public void push(Pair<String, FileEditorOpenOptions> pair) {
                if (this.size() >= EditorWindow.getTabLimit()) {
                    this.remove(0);
                }
                super.push(pair);
            }
        };
        this.myOwner = owner;
        this.myPanel = new JPanel(new BorderLayout());
        this.myPanel.setOpaque(false);
        this.myPanel.setFocusable(false);
        this.myTabbedPane = new EditorTabbedContainer(this, this.getManager().getProject(), parentDisposable);
        this.myPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
        if (UISettings.getInstance().getScrollTabLayoutInEditor()) {
            this.setTabLayoutPolicy(1);
        } else {
            this.setTabLayoutPolicy(0);
        }
        this.myOwner.addWindow(this);
        if (this.myOwner.getCurrentWindow() == null) {
            this.myOwner.setCurrentWindow(this, false);
        }
        this.updateTabsVisibility(UISettings.getInstance());
    }

    void updateTabsVisibility(@NotNull UISettings settings) {
        if (settings == null) {
            EditorWindow.$$$reportNull$$$0(2);
        }
        this.myTabbedPane.getTabs().getPresentation().setHideTabs(settings.getEditorTabPlacement() == 0 || settings.getPresentationMode());
    }

    public boolean isShowing() {
        return this.myPanel.isShowing();
    }

    public void closeAllExcept(@Nullable VirtualFile selectedFile) {
        FileEditorManagerImpl.runBulkTabChange(this.myOwner, __ -> {
            for (VirtualFile file2 : this.getFiles()) {
                if (Comparing.equal((Object)file2, (Object)selectedFile) || this.isFilePinned(file2)) continue;
                this.closeFile(file2);
            }
        });
    }

    void dispose() {
        try {
            this.myOwner.removeWindow(this);
        }
        finally {
            this.myIsDisposed = true;
        }
    }

    public boolean isDisposed() {
        return this.myIsDisposed;
    }

    public void closeFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(3);
        }
        this.closeFile(file2, true);
    }

    public void closeFile(@NotNull VirtualFile file2, boolean disposeIfNeeded) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(4);
        }
        this.closeFile(file2, disposeIfNeeded, true);
    }

    boolean hasClosedTabs() {
        return !this.myRemovedTabs.empty();
    }

    void restoreClosedTab() {
        assert (this.hasClosedTabs()) : "Nothing to restore";
        Pair info = (Pair)this.myRemovedTabs.pop();
        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl((String)info.getFirst());
        if (file2 != null) {
            this.getManager().openFileImpl4(this, file2, null, new FileEditorOpenOptions().withPin(((FileEditorOpenOptions)info.getSecond()).getPin()).withCurrentTab(true).withFocusEditor(true).withIndex(((FileEditorOpenOptions)info.getSecond()).getIndex()));
        }
    }

    public void closeFile(@NotNull VirtualFile file2, boolean disposeIfNeeded, boolean transferFocus) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(5);
        }
        FileEditorManagerImpl editorManager = this.getManager();
        FileEditorManagerImpl.runBulkTabChange(this.myOwner, splitters -> {
            List<EditorWithProviderComposite> editors = splitters.findEditorComposites(file2);
            if (editors.isEmpty()) {
                return;
            }
            try {
                EditorWithProviderComposite editor = this.findFileComposite(file2);
                FileEditorManagerListener.Before beforePublisher = (FileEditorManagerListener.Before)editorManager.getProject().getMessageBus().syncPublisher(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER);
                beforePublisher.beforeFileClosed((FileEditorManager)editorManager, file2);
                if (editor != null) {
                    int componentIndex = this.findComponentIndex(editor.getComponent());
                    if (componentIndex >= 0) {
                        int indexToSelect = this.calcIndexToSelect(file2, componentIndex);
                        FileEditorOpenOptions options2 = new FileEditorOpenOptions().withIndex(componentIndex).withPin(editor.isPinned());
                        Pair pair = Pair.create((Object)file2.getUrl(), (Object)options2);
                        this.myRemovedTabs.push((Object)pair);
                        this.myTabbedPane.removeTabAt(componentIndex, indexToSelect, transferFocus);
                        editorManager.disposeComposite(editor);
                    }
                } else {
                    Splitter splitter;
                    JComponent otherComponent;
                    if (this.inSplitter() && (otherComponent = (splitter = (Splitter)this.myPanel.getParent()).getOtherComponent((Component)this.myPanel)) != null) {
                        IdeFocusManager.findInstance().requestFocus((Component)otherComponent, true);
                    }
                    this.myPanel.removeAll();
                }
                if (disposeIfNeeded && this.getTabCount() == 0) {
                    this.removeFromSplitter();
                } else {
                    this.myPanel.revalidate();
                }
            }
            finally {
                editorManager.removeSelectionRecord(file2, this);
                ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
                editorManager.notifyPublisher(() -> {
                    Project project = editorManager.getProject();
                    if (!project.isDisposed()) {
                        FileEditorManagerListener afterPublisher = (FileEditorManagerListener)project.getMessageBus().syncPublisher(FileEditorManagerListener.FILE_EDITOR_MANAGER);
                        afterPublisher.fileClosed((FileEditorManager)editorManager, file2);
                    }
                });
                splitters.afterFileClosed(file2);
            }
        });
    }

    void removeFromSplitter() {
        if (!this.inSplitter()) {
            return;
        }
        if (this.myOwner.getCurrentWindow() == this) {
            EditorWindow[] siblings = this.findSiblings();
            this.myOwner.setCurrentWindow(siblings[0], true);
        }
        Splitter splitter = (Splitter)this.myPanel.getParent();
        JComponent otherComponent = splitter.getOtherComponent((Component)this.myPanel);
        Container parent = splitter.getParent().getParent();
        if (parent instanceof Splitter) {
            Splitter parentSplitter = (Splitter)parent;
            if (parentSplitter.getFirstComponent() == splitter.getParent()) {
                parentSplitter.setFirstComponent(otherComponent);
            } else {
                parentSplitter.setSecondComponent(otherComponent);
            }
        } else if (parent instanceof EditorsSplitters) {
            Component currentFocusComponent = IdeFocusManager.getGlobalInstance().getFocusedDescendantFor((Component)parent);
            parent.removeAll();
            parent.add((Component)otherComponent, "Center");
            parent.revalidate();
            if (currentFocusComponent != null) {
                currentFocusComponent.requestFocusInWindow();
            }
        } else {
            throw new IllegalStateException("Unknown container: " + parent);
        }
        this.dispose();
    }

    int calcIndexToSelect(@NotNull VirtualFile fileBeingClosed, int fileIndex) {
        int currentlySelectedIndex;
        if (fileBeingClosed == null) {
            EditorWindow.$$$reportNull$$$0(6);
        }
        if ((currentlySelectedIndex = this.myTabbedPane.getSelectedIndex()) != fileIndex) {
            return currentlySelectedIndex;
        }
        UISettings uiSettings = UISettings.getInstance();
        if (uiSettings.getState().getActiveMruEditorOnClose()) {
            List<VirtualFile> histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFileList();
            for (int idx = histFiles.size() - 1; idx >= 0; --idx) {
                int histFileIndex;
                EditorWithProviderComposite editor;
                VirtualFile histFile = histFiles.get(idx);
                if (histFile.equals(fileBeingClosed) || (editor = this.findFileComposite(histFile)) == null || (histFileIndex = this.findComponentIndex(editor.getComponent())) < 0) continue;
                return histFileIndex;
            }
        } else if (uiSettings.getActiveRightEditorOnClose() && fileIndex + 1 < this.myTabbedPane.getTabCount()) {
            return fileIndex + 1;
        }
        if (fileIndex > 0) {
            return fileIndex - 1;
        }
        return -1;
    }

    @NotNull
    public FileEditorManagerImpl getManager() {
        FileEditorManagerImpl fileEditorManagerImpl = this.myOwner.getManager();
        if (fileEditorManagerImpl == null) {
            EditorWindow.$$$reportNull$$$0(7);
        }
        return fileEditorManagerImpl;
    }

    public int getTabCount() {
        return this.myTabbedPane.getTabCount();
    }

    void setForegroundAt(int index, @NotNull Color color) {
        if (color == null) {
            EditorWindow.$$$reportNull$$$0(8);
        }
        this.myTabbedPane.setForegroundAt(index, color);
    }

    void setWaveColor(int index, @Nullable Color color) {
        this.myTabbedPane.setWaveColor(index, color);
    }

    private void setIconAt(int index, Icon icon2) {
        this.myTabbedPane.setIconAt(index, icon2);
    }

    private void setTitleAt(int index, @NotNull String text) {
        if (text == null) {
            EditorWindow.$$$reportNull$$$0(9);
        }
        this.myTabbedPane.setTitleAt(index, text);
    }

    private void setBackgroundColorAt(int index, @Nullable Color color) {
        this.myTabbedPane.setBackgroundColorAt(index, color);
    }

    private void setToolTipTextAt(int index, @Nullable String text) {
        this.myTabbedPane.setToolTipTextAt(index, text);
    }

    void setTabLayoutPolicy(int policy) {
        this.myTabbedPane.setTabLayoutPolicy(policy);
    }

    void setTabsPlacement(int tabPlacement) {
        this.myTabbedPane.setTabPlacement(tabPlacement);
    }

    void updateTabsLayout(@NotNull TabsLayoutInfo newTabsLayoutInfo) {
        if (newTabsLayoutInfo == null) {
            EditorWindow.$$$reportNull$$$0(10);
        }
        this.myTabbedPane.updateTabsLayout(newTabsLayoutInfo);
    }

    public void setAsCurrentWindow(boolean requestFocus) {
        this.myOwner.setCurrentWindow(this, requestFocus);
    }

    void updateFileBackgroundColor(@NotNull VirtualFile file2) {
        int index;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(11);
        }
        if ((index = this.findEditorIndex(this.findFileComposite(file2))) != -1) {
            Color color = EditorTabPresentationUtil.getEditorTabBackgroundColor(this.getManager().getProject(), file2, this);
            this.setBackgroundColorAt(index, color);
        }
    }

    @NotNull
    public EditorsSplitters getOwner() {
        EditorsSplitters editorsSplitters = this.myOwner;
        if (editorsSplitters == null) {
            EditorWindow.$$$reportNull$$$0(12);
        }
        return editorsSplitters;
    }

    boolean isEmptyVisible() {
        return this.myTabbedPane.isEmptyVisible();
    }

    public Dimension getSize() {
        return this.myPanel.getSize();
    }

    @NotNull
    public EditorTabbedContainer getTabbedPane() {
        EditorTabbedContainer editorTabbedContainer = this.myTabbedPane;
        if (editorTabbedContainer == null) {
            EditorWindow.$$$reportNull$$$0(13);
        }
        return editorTabbedContainer;
    }

    public void requestFocus(boolean forced) {
        this.myTabbedPane.requestFocus(forced);
    }

    public boolean isValid() {
        return this.myPanel.isShowing();
    }

    private void checkConsistency() {
        LOG.assertTrue(this.myOwner.containsWindow(this), (Object)"EditorWindow not in collection");
    }

    @Nullable
    public EditorWithProviderComposite getSelectedEditor() {
        return this.getSelectedEditor(false);
    }

    @Nullable
    public EditorWithProviderComposite getSelectedEditor(boolean ignorePopup) {
        TComp comp = (TComp)ObjectUtils.tryCast((Object)this.myTabbedPane.getSelectedComponent(ignorePopup), TComp.class);
        return comp == null ? null : comp.myEditor;
    }

    public EditorWithProviderComposite @NotNull [] getEditors() {
        int tabCount = this.getTabCount();
        EditorWithProviderComposite[] res2 = new EditorWithProviderComposite[tabCount];
        for (int i2 = 0; i2 != tabCount; ++i2) {
            res2[i2] = this.getEditorAt(i2);
        }
        if (res2 == null) {
            EditorWindow.$$$reportNull$$$0(14);
        }
        return res2;
    }

    public VirtualFile @NotNull [] getFiles() {
        int tabCount = this.getTabCount();
        VirtualFile[] res2 = new VirtualFile[tabCount];
        for (int i2 = 0; i2 != tabCount; ++i2) {
            res2[i2] = this.getEditorAt(i2).getFile();
        }
        if (res2 == null) {
            EditorWindow.$$$reportNull$$$0(15);
        }
        return res2;
    }

    public void setSelectedEditor(@NotNull EditorComposite editor, boolean focusEditor) {
        int index;
        if (editor == null) {
            EditorWindow.$$$reportNull$$$0(16);
        }
        if ((index = this.findFileIndex(editor.getFile())) != -1 && !this.isDisposed()) {
            this.myTabbedPane.setSelectedIndex(index, focusEditor);
        }
    }

    public void setEditor(@Nullable EditorWithProviderComposite editor, boolean focusEditor) {
        this.setEditor(editor, true, focusEditor);
    }

    public void setEditor(@Nullable EditorWithProviderComposite editor, boolean selectEditor, boolean focusEditor) {
        if (editor != null) {
            int index = this.findEditorIndex(editor);
            if (index != -1) {
                if (selectEditor) {
                    this.setSelectedEditor(editor, focusEditor);
                }
            } else {
                int selectedIndex;
                Integer initialIndex = (Integer)editor.getFile().getUserData(INITIAL_INDEX_KEY);
                int indexToInsert = initialIndex != null ? initialIndex : (UISettings.getInstance().getOpenTabsAtTheEnd() ? this.myTabbedPane.getTabCount() : ((selectedIndex = this.myTabbedPane.getSelectedIndex()) >= 0 ? selectedIndex + 1 : 0));
                VirtualFile file2 = editor.getFile();
                Icon template = AllIcons.FileTypes.Text;
                EmptyIcon emptyIcon = EmptyIcon.create((int)template.getIconWidth(), (int)template.getIconHeight());
                this.myTabbedPane.insertTab(file2, (Icon)emptyIcon, new TComp(this, editor), null, indexToInsert, editor);
                this.trimToSize(file2, false);
                if (selectEditor) {
                    this.setSelectedEditor(editor, focusEditor);
                }
                this.myOwner.updateFileIconImmediately(file2);
                this.myOwner.updateFileColor(file2);
            }
            this.myOwner.setCurrentWindow(this, false);
        }
        this.myOwner.validate();
    }

    private boolean splitAvailable() {
        return this.getTabCount() >= 1;
    }

    @Nullable
    public EditorWindow split(int orientation, boolean forceSplit, @Nullable VirtualFile virtualFile, boolean focusNew) {
        this.checkConsistency();
        if (!this.splitAvailable()) {
            return null;
        }
        FileEditorManagerImpl fileEditorManager = this.myOwner.getManager();
        if (!forceSplit && this.inSplitter()) {
            EditorWindow[] siblings = this.findSiblings();
            EditorWindow target2 = siblings[0];
            if (virtualFile != null) {
                FileEditor[] editors = (FileEditor[])fileEditorManager.openFileImpl3((EditorWindow)target2, (VirtualFile)virtualFile, (boolean)focusNew, null).first;
                this.syncCaretIfPossible(editors);
            }
            return target2;
        }
        JPanel panel2 = this.myPanel;
        panel2.setBorder(null);
        int tabCount = this.getTabCount();
        if (tabCount != 0) {
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.setOpaque(false);
            OnePixelSplitter splitter = new OnePixelSplitter(orientation == 0, 0.5f, 0.1f, 0.9f);
            EditorWindow res2 = new EditorWindow(this.myOwner, this.myOwner.parentDisposable);
            EditorWithProviderComposite selectedEditor = this.getSelectedEditor();
            panel2.remove(this.myTabbedPane.getComponent());
            panel2.add((Component)splitter, "Center");
            splitter.setFirstComponent((JComponent)this.myPanel);
            this.myPanel.add((Component)this.myTabbedPane.getComponent(), "Center");
            splitter.setSecondComponent((JComponent)res2.myPanel);
            VirtualFile file2 = selectedEditor.getFile();
            if (virtualFile == null) {
                for (FileEditorAssociateFinder finder : FileEditorAssociateFinder.EP_NAME.getExtensionList()) {
                    VirtualFile associatedFile = finder.getAssociatedFileToOpen(fileEditorManager.getProject(), file2);
                    if (associatedFile == null) continue;
                    virtualFile = associatedFile;
                    break;
                }
            }
            VirtualFile nextFile = virtualFile == null ? file2 : virtualFile;
            HistoryEntry currentState = selectedEditor.currentStateAsHistoryEntry();
            FileEditor[] editors = (FileEditor[])fileEditorManager.openFileImpl4((EditorWindow)res2, (VirtualFile)nextFile, (HistoryEntry)currentState, (FileEditorOpenOptions)new FileEditorOpenOptions().withCurrentTab((boolean)true).withFocusEditor((boolean)focusNew).withExactState()).first;
            this.syncCaretIfPossible(editors);
            res2.setFilePinned(nextFile, this.isFilePinned(file2));
            if (!focusNew) {
                res2.setSelectedEditor(selectedEditor, true);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)selectedEditor.getFocusComponent(), true));
            }
            panel2.revalidate();
            return res2;
        }
        return null;
    }

    private void syncCaretIfPossible(FileEditor @NotNull [] toSync) {
        EditorWithProviderComposite from;
        if (toSync == null) {
            EditorWindow.$$$reportNull$$$0(17);
        }
        if ((from = this.getSelectedEditor()) == null) {
            return;
        }
        FileEditor caretSource = from.getSelectedEditor();
        if (!(caretSource instanceof TextEditor)) {
            return;
        }
        Editor editorFrom = ((TextEditor)caretSource).getEditor();
        int offset = editorFrom.getCaretModel().getOffset();
        if (offset <= 0) {
            return;
        }
        int scrollOffset = editorFrom.getScrollingModel().getVerticalScrollOffset();
        for (FileEditor fileEditor : toSync) {
            if (!(fileEditor instanceof TextEditor)) continue;
            Editor editor = ((TextEditor)fileEditor).getEditor();
            if (editorFrom.getDocument() != editor.getDocument()) continue;
            editor.getCaretModel().moveToOffset(offset);
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.scrollVertically(scrollOffset);
            SwingUtilities.invokeLater(() -> {
                if (!editor.isDisposed()) {
                    scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
                }
            });
        }
    }

    public EditorWindow @NotNull [] findSiblings() {
        this.checkConsistency();
        ArrayList<EditorWindow> res2 = new ArrayList<EditorWindow>();
        if (this.myPanel.getParent() instanceof Splitter) {
            Splitter splitter = (Splitter)this.myPanel.getParent();
            for (EditorWindow win : this.myOwner.getWindows()) {
                if (win == this || !SwingUtilities.isDescendingFrom(win.myPanel, (Component)splitter)) continue;
                res2.add(win);
            }
        }
        EditorWindow[] editorWindowArray = res2.toArray(new EditorWindow[0]);
        if (editorWindowArray == null) {
            EditorWindow.$$$reportNull$$$0(18);
        }
        return editorWindowArray;
    }

    void changeOrientation() {
        this.checkConsistency();
        Container parent = this.myPanel.getParent();
        if (parent instanceof Splitter) {
            Splitter splitter;
            splitter.setOrientation(!(splitter = (Splitter)parent).getOrientation());
        }
    }

    void updateFileIcon(@NotNull VirtualFile file2) {
        int index;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(19);
        }
        LOG.assertTrue((index = this.findEditorIndex(this.findFileComposite(file2))) != -1);
        this.setIconAt(index, this.getFileIcon(file2));
    }

    void updateFileName(@NotNull VirtualFile file2) {
        int index;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(20);
        }
        if ((index = this.findEditorIndex(this.findFileComposite(file2))) != -1) {
            this.setTitleAt(index, EditorTabPresentationUtil.getEditorTabTitle(this.getManager().getProject(), file2, this));
            this.setToolTipTextAt(index, UISettings.getInstance().getShowTabsTooltips() ? this.getManager().getFileTooltipText(file2) : null);
        }
    }

    private Icon getFileIcon(@NotNull VirtualFile file2) {
        Object modifiedIcon;
        Icon pinIcon;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(21);
        }
        if (!file2.isValid()) {
            Icon fakeIcon = FileTypes.UNKNOWN.getIcon();
            assert (fakeIcon != null) : "Can't find the icon for unknown file type";
            return fakeIcon;
        }
        Icon baseIcon = IconUtil.getIcon((VirtualFile)file2, (int)2, (Project)this.getManager().getProject());
        int count = 1;
        EditorWithProviderComposite composite = this.findFileComposite(file2);
        if (composite != null && composite.isPinned()) {
            ++count;
            pinIcon = AllIcons.Nodes.TabPin;
        } else {
            pinIcon = null;
        }
        UISettings settings = UISettings.getInstance();
        if (settings.getMarkModifiedTabsWithAsterisk()) {
            Icon crop = IconUtil.cropIcon((Icon)AllIcons.General.Modified, (Rectangle)new JBRectangle(3, 3, 7, 7));
            modifiedIcon = settings.getMarkModifiedTabsWithAsterisk() && composite != null && composite.isModified() ? crop : new EmptyIcon(7, 7);
            ++count;
        } else {
            modifiedIcon = null;
        }
        if (count == 1) {
            return baseIcon;
        }
        int i2 = 0;
        LayeredIcon result2 = new LayeredIcon(count);
        result2.setIcon(baseIcon, i2++);
        if (pinIcon != null) {
            result2.setIcon(pinIcon, i2++);
        }
        if (modifiedIcon != null) {
            result2.setIcon((Icon)modifiedIcon, i2++, -modifiedIcon.getIconWidth() / 2, 0);
        }
        return JBUI.scale((JBUI.JBIcon)result2);
    }

    public void unsplit(boolean setCurrent) {
        this.checkConsistency();
        Container splitter = this.myPanel.getParent();
        if (!(splitter instanceof Splitter)) {
            return;
        }
        EditorWithProviderComposite editorToSelect = this.getSelectedEditor();
        EditorWindow[] siblings = this.findSiblings();
        JPanel parent = (JPanel)splitter.getParent();
        for (EditorWindow eachSibling : siblings) {
            EditorWithProviderComposite selected2 = eachSibling.getSelectedEditor();
            if (editorToSelect != null) continue;
            editorToSelect = selected2;
        }
        for (EditorWindow sibling : siblings) {
            EditorWithProviderComposite[] siblingEditors;
            for (EditorWithProviderComposite siblingEditor : siblingEditors = sibling.getEditors()) {
                if (editorToSelect == null) {
                    editorToSelect = siblingEditor;
                }
                this.processSiblingEditor(siblingEditor);
            }
            LOG.assertTrue(sibling != this);
            sibling.dispose();
        }
        parent.remove(splitter);
        parent.add((Component)this.myTabbedPane.getComponent(), "Center");
        parent.revalidate();
        this.myPanel = parent;
        if (editorToSelect != null) {
            this.setSelectedEditor(editorToSelect, true);
        }
        if (setCurrent) {
            this.myOwner.setCurrentWindow(this, false);
        }
    }

    private void processSiblingEditor(@NotNull EditorWithProviderComposite siblingEditor) {
        if (siblingEditor == null) {
            EditorWindow.$$$reportNull$$$0(22);
        }
        if (this.getTabCount() < UISettings.getInstance().getState().getEditorTabLimit() && this.findFileComposite(siblingEditor.getFile()) == null) {
            this.setEditor(siblingEditor, true);
        } else {
            this.getManager().disposeComposite(siblingEditor);
        }
    }

    void unsplitAll() {
        this.checkConsistency();
        while (this.inSplitter()) {
            this.unsplit(true);
        }
    }

    public boolean inSplitter() {
        this.checkConsistency();
        return this.myPanel.getParent() instanceof Splitter;
    }

    public VirtualFile getSelectedFile() {
        this.checkConsistency();
        EditorWithProviderComposite editor = this.getSelectedEditor();
        return editor == null ? null : editor.getFile();
    }

    @Nullable
    public EditorWithProviderComposite findFileComposite(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(23);
        }
        if (file2 instanceof BackedVirtualFile) {
            file2 = ((BackedVirtualFile)file2).getOriginFile();
        }
        for (int i2 = 0; i2 != this.getTabCount(); ++i2) {
            EditorWithProviderComposite editor = this.getEditorAt(i2);
            if (!editor.getFile().equals(file2)) continue;
            return editor;
        }
        return null;
    }

    private int findComponentIndex(@NotNull Component component2) {
        if (component2 == null) {
            EditorWindow.$$$reportNull$$$0(24);
        }
        for (int i2 = 0; i2 != this.getTabCount(); ++i2) {
            EditorWithProviderComposite editor = this.getEditorAt(i2);
            if (!editor.getComponent().equals(component2)) continue;
            return i2;
        }
        return -1;
    }

    int findEditorIndex(EditorComposite editorToFind) {
        for (int i2 = 0; i2 != this.getTabCount(); ++i2) {
            EditorWithProviderComposite editor = this.getEditorAt(i2);
            if (!editor.equals(editorToFind)) continue;
            return i2;
        }
        return -1;
    }

    int findFileIndex(@NotNull VirtualFile fileToFind) {
        if (fileToFind == null) {
            EditorWindow.$$$reportNull$$$0(25);
        }
        for (int i2 = 0; i2 != this.getTabCount(); ++i2) {
            VirtualFile file2 = this.getFileAt(i2);
            if (!file2.equals(fileToFind)) continue;
            return i2;
        }
        return -1;
    }

    @NotNull
    private EditorWithProviderComposite getEditorAt(int i2) {
        EditorWithProviderComposite editorWithProviderComposite = ((TComp)this.myTabbedPane.getComponentAt((int)i2)).myEditor;
        if (editorWithProviderComposite == null) {
            EditorWindow.$$$reportNull$$$0(26);
        }
        return editorWithProviderComposite;
    }

    public boolean isFileOpen(@NotNull VirtualFile file2) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(27);
        }
        return this.findFileComposite(file2) != null;
    }

    public boolean isFilePinned(@NotNull VirtualFile file2) {
        EditorWithProviderComposite editorComposite;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(28);
        }
        if ((editorComposite = this.findFileComposite(file2)) == null) {
            throw new IllegalArgumentException("file is not open: " + file2.getPath());
        }
        return editorComposite.isPinned();
    }

    public void setFilePinned(@NotNull VirtualFile file2, boolean pinned) {
        EditorWithProviderComposite editorComposite;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(29);
        }
        if ((editorComposite = this.findFileComposite(file2)) == null) {
            throw new IllegalArgumentException("file is not open: " + file2.getPath());
        }
        boolean wasPinned = editorComposite.isPinned();
        editorComposite.setPinned(pinned);
        if (wasPinned != pinned && ApplicationManager.getApplication().isDispatchThread()) {
            this.updateFileIcon(file2);
        }
    }

    void trimToSize(@Nullable VirtualFile fileToIgnore, boolean transferFocus) {
        this.getManager().getReady(this).doWhenDone(() -> {
            if (!this.isDisposed()) {
                this.doTrimSize(fileToIgnore, UISettings.getInstance().getState().getCloseNonModifiedFilesFirst(), transferFocus);
            }
        });
    }

    private void doTrimSize(@Nullable VirtualFile fileToIgnore, boolean closeNonModifiedFilesFirst, boolean transferFocus) {
        int limit = EditorWindow.getTabLimit();
        Set<VirtualFile> closingOrder = this.getTabClosingOrder(closeNonModifiedFilesFirst);
        VirtualFile selectedFile = this.getSelectedFile();
        if (selectedFile != null && this.shouldCloseSelected(selectedFile, fileToIgnore)) {
            this.defaultCloseFile(selectedFile, transferFocus);
            closingOrder.remove(selectedFile);
        }
        for (VirtualFile file2 : closingOrder) {
            if (this.myTabbedPane.getTabCount() <= limit || this.myTabbedPane.getTabCount() == 0 || this.areAllTabsPinned(fileToIgnore)) {
                return;
            }
            if (!this.fileCanBeClosed(file2, fileToIgnore)) continue;
            this.defaultCloseFile(file2, transferFocus);
        }
    }

    public static int getTabLimit() {
        int limit = UISettings.getInstance().getEditorTabLimit();
        if (ToggleDistractionFreeModeAction.isDistractionFreeModeEnabled() && ToggleDistractionFreeModeAction.getStandardTabPlacement() == 0) {
            limit = 1;
        }
        return limit;
    }

    @NotNull
    private Set<VirtualFile> getTabClosingOrder(boolean closeNonModifiedFilesFirst) {
        VirtualFile[] allFiles = this.getFiles();
        List<VirtualFile> histFiles = EditorHistoryManager.getInstance(this.getManager().getProject()).getFileList();
        LinkedHashSet<VirtualFile> closingOrder = new LinkedHashSet<VirtualFile>();
        for (VirtualFile file2 : allFiles) {
            if (histFiles.contains(file2)) continue;
            closingOrder.add(file2);
        }
        if (closeNonModifiedFilesFirst) {
            for (VirtualFile file3 : histFiles) {
                EditorWithProviderComposite composite = this.findFileComposite(file3);
                if (composite == null || this.myOwner.getManager().isChanged(composite)) continue;
                closingOrder.add(file3);
            }
            for (int i2 = 0; i2 < this.myTabbedPane.getTabCount(); ++i2) {
                VirtualFile file4 = this.getFileAt(i2);
                if (this.myOwner.getManager().isChanged(this.getEditorAt(i2))) continue;
                closingOrder.add(file4);
            }
        }
        closingOrder.addAll(histFiles);
        for (int i3 = 0; i3 < this.myTabbedPane.getTabCount(); ++i3) {
            closingOrder.add(this.getFileAt(i3));
        }
        VirtualFile selectedFile = this.getSelectedFile();
        closingOrder.remove(selectedFile);
        closingOrder.add(selectedFile);
        LinkedHashSet<VirtualFile> linkedHashSet = closingOrder;
        if (linkedHashSet == null) {
            EditorWindow.$$$reportNull$$$0(30);
        }
        return linkedHashSet;
    }

    private boolean shouldCloseSelected(@NotNull VirtualFile file2, @Nullable VirtualFile fileToIgnore) {
        Component owner;
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(31);
        }
        if (!UISettings.getInstance().getReuseNotModifiedTabs() || !this.myOwner.getManager().getProject().isInitialized()) {
            return false;
        }
        if (!this.isFileOpen(file2) || this.isFilePinned(file2)) {
            return false;
        }
        if (file2.equals(fileToIgnore)) {
            return false;
        }
        EditorWithProviderComposite composite = this.findFileComposite(file2);
        if (composite == null) {
            return false;
        }
        if (!(ApplicationManager.getApplication().isUnitTestMode() || (owner = IdeFocusManager.getInstance((Project)this.myOwner.getManager().getProject()).getFocusOwner()) != null && SwingUtilities.isDescendingFrom(owner, composite.getSelectedEditor().getComponent()))) {
            return false;
        }
        return !this.myOwner.getManager().isChanged(composite);
    }

    private boolean areAllTabsPinned(@Nullable VirtualFile fileToIgnore) {
        for (int i2 = this.myTabbedPane.getTabCount() - 1; i2 >= 0; --i2) {
            if (!this.fileCanBeClosed(this.getFileAt(i2), fileToIgnore)) continue;
            return false;
        }
        return true;
    }

    private void defaultCloseFile(@NotNull VirtualFile file2, boolean transferFocus) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(32);
        }
        this.closeFile(file2, true, transferFocus);
    }

    private boolean fileCanBeClosed(@NotNull VirtualFile file2, @Nullable VirtualFile fileToIgnore) {
        if (file2 == null) {
            EditorWindow.$$$reportNull$$$0(33);
        }
        return this.isFileOpen(file2) && !file2.equals(fileToIgnore) && !this.isFilePinned(file2);
    }

    @NotNull
    VirtualFile getFileAt(int i2) {
        VirtualFile virtualFile = this.getEditorAt(i2).getFile();
        if (virtualFile == null) {
            EditorWindow.$$$reportNull$$$0(34);
        }
        return virtualFile;
    }

    public String toString() {
        return "EditorWindow: files=" + Arrays.asList(this.getFiles());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 26: 
            case 30: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 26: 
            case 30: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileBeingClosed";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 26: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorWindow";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTabsLayoutInfo";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSync";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "siblingEditor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToFind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorWindow";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwner";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabbedPane";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditors";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findSiblings";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorAt";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getTabClosingOrder";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateTabsVisibility";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "closeFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "calcIndexToSelect";
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 26: 
            case 30: 
            case 34: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setForegroundAt";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setTitleAt";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateTabsLayout";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateFileBackgroundColor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedEditor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "syncCaretIfPossible";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "updateFileIcon";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateFileName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getFileIcon";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "processSiblingEditor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findFileComposite";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findComponentIndex";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findFileIndex";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isFileOpen";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isFilePinned";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setFilePinned";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "shouldCloseSelected";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "defaultCloseFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "fileCanBeClosed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 26: 
            case 30: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class TComp
    extends JPanel
    implements DataProvider,
    EditorWindowHolder {
        @NotNull
        final EditorWithProviderComposite myEditor;
        protected final EditorWindow myWindow;

        TComp(@NotNull EditorWindow window, @NotNull EditorWithProviderComposite editor) {
            if (window == null) {
                TComp.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                TComp.$$$reportNull$$$0(1);
            }
            super(new BorderLayout());
            this.myEditor = editor;
            this.myWindow = window;
            this.add((Component)editor.getComponent(), "Center");
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!this.hasFocus()) {
                            return;
                        }
                        JComponent focus = myEditor.getSelectedWithProvider().getFileEditor().getPreferredFocusedComponent();
                        if (focus != null && !focus.hasFocus()) {
                            IdeFocusManager.getGlobalInstance().requestFocus((Component)focus, true);
                        }
                    });
                }
            });
            this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container aContainer, Component aComponent) {
                    return myEditor.getFocusComponent();
                }

                @Override
                public Component getComponentBefore(Container aContainer, Component aComponent) {
                    return myEditor.getFocusComponent();
                }

                @Override
                public Component getFirstComponent(Container aContainer) {
                    return myEditor.getFocusComponent();
                }

                @Override
                public Component getLastComponent(Container aContainer) {
                    return myEditor.getFocusComponent();
                }

                @Override
                public Component getDefaultComponent(Container aContainer) {
                    return myEditor.getFocusComponent();
                }
            });
        }

        @Override
        @NotNull
        public EditorWindow getEditorWindow() {
            EditorWindow editorWindow = this.myWindow;
            if (editorWindow == null) {
                TComp.$$$reportNull$$$0(2);
            }
            return editorWindow;
        }

        public Object getData(@NotNull String dataId) {
            if (dataId == null) {
                TComp.$$$reportNull$$$0(3);
            }
            if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
                VirtualFile virtualFile = this.myEditor.getFile();
                return virtualFile.isValid() ? virtualFile : null;
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return this.myEditor.getFileEditorManager().getProject();
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "window";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/fileEditor/impl/EditorWindow$TComp";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/fileEditor/impl/EditorWindow$TComp";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorWindow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getData";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

