/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.newEditor;

import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.newEditor.CopySettingsPathAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.function.Supplier;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0002\u001a$\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0002\u001a+\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u00012\u000e\b\u0004\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\u0012H\u0082\b\u001a\u0014\u0010\u0013\u001a\u0004\u0018\u00010\u00012\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0016"}, d2={"pathActionName", "", "getPathActionName", "()Ljava/lang/String;", "copy", "", "names", "", "copyLink", "", "supplier", "Ljava/util/function/Supplier;", "isHttp", "createSwingAction", "Ljavax/swing/Action;", "id", "name", "performer", "Lkotlin/Function0;", "getTextLabel", "component", "", "intellij.platform.ide.impl"})
public final class CopySettingsPathActionKt {
    private static final String getPathActionName() {
        String string = ActionsBundle.message((String)(SystemInfo.isMac ? "action.CopySettingsPath.mac.text" : "action.CopySettingsPath.text"), (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ActionsBundle.message(if\u2026n.CopySettingsPath.text\")");
        return string;
    }

    private static final boolean copy(Collection<String> names2) {
        Transferable transferable = CopySettingsPathAction.Companion.createTransferable(names2);
        if (transferable == null) {
            return false;
        }
        CopyPasteManager.getInstance().setContents(transferable);
        return true;
    }

    private static final String getTextLabel(Object component2) {
        boolean bl;
        boolean bl2;
        CharSequence charSequence;
        String text;
        if (component2 instanceof JToggleButton) {
            text = ((JToggleButton)component2).getText();
            charSequence = text;
            bl2 = false;
            bl = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                return text;
            }
        }
        if (component2 instanceof JLabel) {
            text = ((JLabel)component2).getText();
            charSequence = text;
            bl2 = false;
            bl = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                return text;
            }
        } else if (component2 instanceof JComponent) {
            return CopySettingsPathActionKt.getTextLabel(((JComponent)component2).getClientProperty("labeledBy"));
        }
        return null;
    }

    private static final Action createSwingAction(String id2, String name, Function0<Unit> performer) {
        AbstractAction action2;
        block1: {
            int $i$f$createSwingAction = 0;
            action2 = new AbstractAction(performer, name, name){
                final /* synthetic */ Function0 $performer;
                final /* synthetic */ String $name;

                public void actionPerformed(@NotNull ActionEvent event) {
                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                    this.$performer.invoke();
                }
                {
                    this.$performer = $captured_local_variable$0;
                    this.$name = $captured_local_variable$1;
                    super($super_call_param$2);
                }
            };
            if (id2 == null) break block1;
            KeyboardShortcut keyboardShortcut = ActionManager.getInstance().getKeyboardShortcut(id2);
            if (keyboardShortcut != null) {
                KeyboardShortcut keyboardShortcut2 = keyboardShortcut;
                boolean bl = false;
                boolean bl2 = false;
                KeyboardShortcut it = keyboardShortcut2;
                boolean bl3 = false;
                KeyboardShortcut keyboardShortcut3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)keyboardShortcut3, (String)"it");
                action2.putValue("AcceleratorKey", keyboardShortcut3.getFirstKeyStroke());
            }
        }
        return action2;
    }

    private static final void copyLink(Supplier<Collection<String>> supplier2, boolean isHttp) {
        StringBuilder builder2 = new StringBuilder();
        if (isHttp) {
            builder2.append("http://localhost:").append(BuiltInServerManager.Companion.getInstance().getPort()).append("/api");
        } else {
            builder2.append("jetbrains://").append(PlatformUtils.getPlatformPrefix());
        }
        builder2.append("/settings?name=");
        Collection<String> collection = supplier2.get();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"supplier.get()");
        CollectionsKt.joinTo$default((Iterable)collection, (Appendable)builder2, (CharSequence)"--", null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>(UrlEscapers.urlFormParameterEscaper()){

            public final String invoke(String p1) {
                return ((Escaper)this.receiver).escape(p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(Escaper.class);
            }

            public final String getName() {
                return "escape";
            }

            public final String getSignature() {
                return "escape(Ljava/lang/String;)Ljava/lang/String;";
            }
        }), (int)60, null);
        CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(builder2));
    }

    public static final /* synthetic */ String access$getTextLabel(Object component2) {
        return CopySettingsPathActionKt.getTextLabel(component2);
    }

    public static final /* synthetic */ boolean access$copy(Collection names2) {
        return CopySettingsPathActionKt.copy(names2);
    }

    public static final /* synthetic */ String access$getPathActionName$p() {
        return CopySettingsPathActionKt.getPathActionName();
    }

    public static final /* synthetic */ Action access$createSwingAction(String id2, String name, Function0 performer) {
        return CopySettingsPathActionKt.createSwingAction(id2, name, (Function0<Unit>)performer);
    }

    public static final /* synthetic */ void access$copyLink(Supplier supplier2, boolean isHttp) {
        CopySettingsPathActionKt.copyLink(supplier2, isHttp);
    }
}

