/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.formatter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.GenericLineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.python.psi.PyFStringFragment;
import com.jetbrains.python.psi.StringLiteralExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLineWrapPositionStrategy
extends GenericLineWrapPositionStrategy {
    public PyLineWrapPositionStrategy() {
        this.addRule(new GenericLineWrapPositionStrategy.Rule(',', GenericLineWrapPositionStrategy.WrapCondition.AFTER, 11.0));
        this.addRule(new GenericLineWrapPositionStrategy.Rule(' '));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('\t'));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('(', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('[', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
        this.addRule(new GenericLineWrapPositionStrategy.Rule('{', GenericLineWrapPositionStrategy.WrapCondition.AFTER));
    }

    protected boolean canUseOffset(@NotNull Document document, int offset, boolean virtual) {
        if (document == null) {
            PyLineWrapPositionStrategy.$$$reportNull$$$0(0);
        }
        if (virtual) {
            return true;
        }
        CharSequence text2 = document.getCharsSequence();
        char c = text2.charAt(offset);
        if (!StringUtil.isWhiteSpace((char)c)) {
            return true;
        }
        int i = CharArrayUtil.shiftBackward((CharSequence)text2, (int)offset, (String)" \t");
        if (i < 2) {
            return true;
        }
        return text2.charAt(i - 2) != 'd' || text2.charAt(i - 1) != 'e' || text2.charAt(i) != 'f';
    }

    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        PsiElement element;
        StringLiteralExpression string;
        PsiFile psiFile;
        int wrapPosition;
        if (document == null) {
            PyLineWrapPositionStrategy.$$$reportNull$$$0(1);
        }
        if ((wrapPosition = super.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, isSoftWrap)) < 0) {
            return wrapPosition;
        }
        CharSequence text2 = document.getImmutableCharSequence();
        if (wrapPosition >= text2.length()) {
            return wrapPosition;
        }
        if (project == null) {
            return wrapPosition;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        if (documentManager != null && (psiFile = documentManager.getPsiFile(document)) != null && (string = (StringLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)(element = psiFile.findElementAt(wrapPosition)), StringLiteralExpression.class)) != null) {
            char charBefore;
            PyFStringFragment fragment = (PyFStringFragment)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PyFStringFragment.class);
            if (fragment != null) {
                return Math.max(fragment.getTextOffset(), startOffset);
            }
            if (wrapPosition > 0 && ((charBefore = text2.charAt(wrapPosition - 1)) == '\'' || charBefore == '\"')) {
                return wrapPosition + 1;
            }
            char c = text2.charAt(wrapPosition);
            if (StringUtil.isWhiteSpace((char)c)) {
                return wrapPosition + 1;
            }
        }
        return wrapPosition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "document";
        objectArray2[1] = "com/jetbrains/python/formatter/PyLineWrapPositionStrategy";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canUseOffset";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateWrapPosition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

