/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyRenameUnresolvedRefQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyBundle.message("QFIX.rename.unresolved.reference", new Object[0]);
        if (string == null) {
            PyRenameUnresolvedRefQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        PsiElement element;
        if (project == null) {
            PyRenameUnresolvedRefQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor2 == null) {
            PyRenameUnresolvedRefQuickFix.$$$reportNull$$$0(2);
        }
        if (!((element = descriptor2.getPsiElement()) instanceof PyReferenceExpression)) {
            return;
        }
        PyReferenceExpression referenceExpression = (PyReferenceExpression)element;
        ScopeOwner parentScope = ScopeUtil.getScopeOwner((PsiElement)referenceExpression);
        if (parentScope == null) {
            return;
        }
        List<PyReferenceExpression> refs = PyRenameUnresolvedRefQuickFix.collectExpressionsToRename(referenceExpression, parentScope);
        LookupElement[] items = PyRenameUnresolvedRefQuickFix.collectLookupItems(parentScope);
        String name = referenceExpression.getReferencedName();
        ReferenceNameExpression refExpr = new ReferenceNameExpression(items, name);
        TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)parentScope);
        for (PyReferenceExpression expr : refs) {
            if (!expr.equals(referenceExpression)) {
                builder.replaceElement((PsiElement)expr, name, name, false);
                continue;
            }
            builder.replaceElement((PsiElement)expr, name, (Expression)refExpr, true);
        }
        Editor editor2 = PyRenameUnresolvedRefQuickFix.getEditor(project, element.getContainingFile(), parentScope.getTextRange().getStartOffset());
        if (editor2 != null) {
            Template template = builder.buildInlineTemplate();
            TemplateManager.getInstance((Project)project).startTemplate(editor2, template);
        }
    }

    public static boolean isValidReference(PsiReference reference) {
        if (!(reference instanceof PyReferenceImpl)) {
            return false;
        }
        ResolveResult[] results = ((PyReferenceImpl)reference).multiResolve(true);
        if (results.length == 0) {
            return false;
        }
        for (ResolveResult result : results) {
            if (result.isValidResult()) continue;
            return false;
        }
        return true;
    }

    private static List<PyReferenceExpression> collectExpressionsToRename(final @NotNull PyReferenceExpression expression, @NotNull ScopeOwner parentScope) {
        if (expression == null) {
            PyRenameUnresolvedRefQuickFix.$$$reportNull$$$0(3);
        }
        if (parentScope == null) {
            PyRenameUnresolvedRefQuickFix.$$$reportNull$$$0(4);
        }
        final ArrayList<PyReferenceExpression> result = new ArrayList<PyReferenceExpression>();
        PyRecursiveElementVisitor visitor2 = new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                if (node.textMatches((PsiElement)expression) && !PyRenameUnresolvedRefQuickFix.isValidReference((PsiReference)node.getReference())) {
                    result.add(node);
                }
                super.visitPyReferenceExpression(node);
            }
        };
        parentScope.accept(visitor2);
        return result;
    }

    @Nullable
    private static Editor getEditor(@NotNull Project project, @NotNull PsiFile file, int offset) {
        VirtualFile virtualFile;
        if (project == null) {
            PyRenameUnresolvedRefQuickFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            PyRenameUnresolvedRefQuickFix.$$$reportNull$$$0(6);
        }
        return (virtualFile = file.getVirtualFile()) != null ? FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, virtualFile, offset), true) : null;
    }

    private static LookupElement[] collectLookupItems(@NotNull ScopeOwner parentScope) {
        if (parentScope == null) {
            PyRenameUnresolvedRefQuickFix.$$$reportNull$$$0(7);
        }
        LinkedHashSet<LookupElementBuilder> items = new LinkedHashSet<LookupElementBuilder>();
        Collection<String> usedNames = PyUtil.collectUsedNames((PsiElement)parentScope);
        for (String name : usedNames) {
            if (name == null) continue;
            items.add(LookupElementBuilder.create((String)name));
        }
        return items.toArray(LookupElement.EMPTY_ARRAY);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/PyRenameUnresolvedRefQuickFix";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentScope";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/PyRenameUnresolvedRefQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectExpressionsToRename";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectLookupItems";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReferenceNameExpression
    extends Expression {
        LookupElement[] myItems;
        private final String myOldReferenceName;

        ReferenceNameExpression(LookupElement[] items, String oldReferenceName) {
            this.myItems = items;
            this.myOldReferenceName = oldReferenceName;
            Arrays.sort(this.myItems, new HammingComparator());
        }

        public Result calculateResult(ExpressionContext context) {
            if (this.myItems == null || this.myItems.length == 0) {
                return new TextResult(this.myOldReferenceName);
            }
            return new TextResult(this.myItems[0].getLookupString());
        }

        public Result calculateQuickResult(ExpressionContext context) {
            return null;
        }

        public LookupElement[] calculateLookupItems(ExpressionContext context) {
            if (this.myItems == null || this.myItems.length == 1) {
                return null;
            }
            return this.myItems;
        }

        class HammingComparator
        implements Comparator<LookupElement> {
            HammingComparator() {
            }

            @Override
            public int compare(LookupElement lookupItem1, LookupElement lookupItem2) {
                String s1 = lookupItem1.getLookupString();
                String s2 = lookupItem2.getLookupString();
                int diff1 = 0;
                for (int i = 0; i < Math.min(s1.length(), ReferenceNameExpression.this.myOldReferenceName.length()); ++i) {
                    if (s1.charAt(i) == ReferenceNameExpression.this.myOldReferenceName.charAt(i)) continue;
                    ++diff1;
                }
                int diff2 = 0;
                for (int i = 0; i < Math.min(s2.length(), ReferenceNameExpression.this.myOldReferenceName.length()); ++i) {
                    if (s2.charAt(i) == ReferenceNameExpression.this.myOldReferenceName.charAt(i)) continue;
                    ++diff2;
                }
                return diff1 - diff2;
            }
        }
    }
}

