/*
 * Decompiled with CFR 0.152.
 */
package tr.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UtilsFile {
    private UtilsFile() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        if (sourceFile == null || targetFile == null) {
            throw new NullPointerException("Source file and target file must not be null");
        }
        File directory = targetFile.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Could not create directory '" + directory + "'");
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(sourceFile));
            outputStream = new BufferedOutputStream(new FileOutputStream(targetFile));
            try {
                byte[] buffer = new byte[32768];
                int readBytes = inputStream.read(buffer);
                while (readBytes > 0) {
                    outputStream.write(buffer, 0, readBytes);
                    readBytes = inputStream.read(buffer);
                }
            }
            catch (IOException ex) {
                targetFile.delete();
                throw ex;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void renameFile(File orig, File dest) throws IOException {
        int i;
        boolean destExists = dest.exists();
        if (destExists) {
            for (i = 0; i < 3; ++i) {
                if (dest.delete()) {
                    destExists = false;
                    break;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (!destExists) {
            for (i = 0; i < 3; ++i) {
                if (orig.renameTo(dest)) {
                    return;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        UtilsFile.copyFile(orig, dest);
        for (i = 0; i < 3; ++i) {
            if (orig.delete()) {
                return;
            }
            try {
                Thread.sleep(71L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        throw new IOException("Can not delete: " + orig.getAbsolutePath());
    }

    public static final File getTempDir() throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        File dir = new File(tmpdir);
        if (dir.isDirectory() && dir.canWrite()) {
            return dir;
        }
        tmpdir = System.getProperty("user.home");
        dir = new File(tmpdir);
        if (dir.isDirectory() && dir.canWrite()) {
            return dir;
        }
        throw new IOException("A writeable temporary directory could not be found.");
    }

    public static final String getExtension(String name) {
        int index;
        if (name != null && (index = name.lastIndexOf(46)) > 0 && index < name.length() - 1) {
            return name.substring(index + 1).toLowerCase();
        }
        return null;
    }

    public static final String setExtension(String path, String extn) {
        if (path == null || extn == null) {
            return null;
        }
        return path + "." + extn;
    }

    public static final String removeExtension(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(".");
        if (index < 0) {
            return path;
        }
        return path.substring(0, index);
    }
}

