/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.crypto.PseudoRandomFunction;
import de.rub.nds.tlsattacker.core.crypto.SSLUtils;
import de.rub.nds.tlsattacker.core.exceptions.CryptoException;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipher;
import de.rub.nds.tlsattacker.core.record.cipher.RecordCipherFactory;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySet;
import de.rub.nds.tlsattacker.core.record.cipher.cryptohelper.KeySetGenerator;
import de.rub.nds.tlsattacker.core.state.Session;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ClientKeyExchangeHandler<Message extends ClientKeyExchangeMessage>
extends HandshakeMessageHandler<Message> {
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    public void adjustPremasterSecret(ClientKeyExchangeMessage message) {
        if (message.getComputations().getPremasterSecret() != null) {
            byte[] premasterSecret = (byte[])message.getComputations().getPremasterSecret().getValue();
            this.tlsContext.setPreMasterSecret(premasterSecret);
            LOGGER.debug("Set PremasterSecret in Context to " + ArrayConverter.bytesToHexString((byte[])premasterSecret));
        } else {
            LOGGER.debug("Did not set in Context PremasterSecret");
        }
    }

    protected byte[] calculateMasterSecret(ClientKeyExchangeMessage message) throws CryptoException {
        Chooser chooser = this.tlsContext.getChooser();
        if (chooser.getSelectedProtocolVersion() == ProtocolVersion.SSL3) {
            LOGGER.debug("Calculate SSL MasterSecret with Client and Server Nonces, which are: " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getComputations().getClientServerRandom().getValue())));
            return SSLUtils.calculateMasterSecretSSL3(chooser.getPreMasterSecret(), (byte[])message.getComputations().getClientServerRandom().getValue());
        }
        PRFAlgorithm prfAlgorithm = AlgorithmResolver.getPRFAlgorithm(chooser.getSelectedProtocolVersion(), chooser.getSelectedCipherSuite());
        if (chooser.isUseExtendedMasterSecret()) {
            LOGGER.debug("Calculating ExtendedMasterSecret");
            byte[] sessionHash = this.tlsContext.getDigest().digest(chooser.getSelectedProtocolVersion(), chooser.getSelectedCipherSuite());
            LOGGER.debug("Premastersecret: " + ArrayConverter.bytesToHexString((byte[])chooser.getPreMasterSecret()));
            LOGGER.debug("SessionHash: " + ArrayConverter.bytesToHexString((byte[])sessionHash));
            byte[] extendedMasterSecret = PseudoRandomFunction.compute(prfAlgorithm, chooser.getPreMasterSecret(), "extended master secret", sessionHash, 48);
            return extendedMasterSecret;
        }
        LOGGER.debug("Calculating MasterSecret");
        byte[] masterSecret = PseudoRandomFunction.compute(prfAlgorithm, chooser.getPreMasterSecret(), "master secret", (byte[])message.getComputations().getClientServerRandom().getValue(), 48);
        return masterSecret;
    }

    public void adjustMasterSecret(ClientKeyExchangeMessage message) {
        byte[] masterSecret;
        try {
            masterSecret = this.calculateMasterSecret(message);
        }
        catch (CryptoException ex) {
            throw new UnsupportedOperationException("Could not calculate masterSecret", ex);
        }
        this.tlsContext.setMasterSecret(masterSecret);
        LOGGER.debug("Set MasterSecret in Context to " + ArrayConverter.bytesToHexString((byte[])masterSecret));
    }

    protected void setRecordCipher() {
        KeySet keySet = this.getKeySet(this.tlsContext);
        LOGGER.debug("Setting new Cipher in RecordLayer");
        RecordCipher recordCipher = RecordCipherFactory.getRecordCipher(this.tlsContext, keySet);
        this.tlsContext.getRecordLayer().setRecordCipher(recordCipher);
    }

    protected void spawnNewSession() {
        Session session = new Session(this.tlsContext.getChooser().getServerSessionId(), this.tlsContext.getChooser().getMasterSecret());
        this.tlsContext.addNewSession(session);
        LOGGER.debug("Spawning new resumable Session");
    }

    private KeySet getKeySet(TlsContext context) {
        try {
            LOGGER.debug("Generating new KeySet");
            return KeySetGenerator.generateKeySet(context);
        }
        catch (CryptoException | NoSuchAlgorithmException ex) {
            throw new UnsupportedOperationException("The specified Algorithm is not supported", ex);
        }
    }
}

